/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.datafixers.util.Pair;
import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.MFFSMod;
import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.TargetPosPair;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.block.ForceFieldBlockImpl;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.blockentity.ModularBlockEntity;
import dev.su5ed.mffs.item.CustomProjectorModeItem;
import dev.su5ed.mffs.menu.ProjectorMenu;
import dev.su5ed.mffs.network.UpdateAnimationSpeed;
import dev.su5ed.mffs.setup.ModBlocks;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.setup.ModSounds;
import dev.su5ed.mffs.setup.ModTags;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.ObjectCache;
import dev.su5ed.mffs.util.SetBlockEvent;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class ProjectorBlockEntity
extends ModularBlockEntity
implements Projector {
    private static final String TRANSLATION_CACHE_KEY = "getTranslation";
    private static final String POSITIVE_SCALE_CACHE_KEY = "getPositiveScale";
    private static final String NEGATIVE_SCALE_CACHE_KEY = "getNegativeScale";
    private static final String ROTATION_YAW_CACHE_KEY = "getRotationYaw";
    private static final String ROTATION_PITCH_CACHE_KEY = "getRotationPitch";
    private static final String ROTATION_ROLL_CACHE_KEY = "getRotationRoll";
    private static final String INTERIOR_POINTS_CACHE_KEY = "getInteriorPoints";
    private final LazyOptional<Projector> projectorOptional = LazyOptional.of(() -> this);
    private final List<ScheduledEvent> scheduledEvents = new ArrayList<ScheduledEvent>();
    public final InventorySlot secondaryCard;
    public final InventorySlot projectorModeSlot;
    public final ListMultimap<Direction, InventorySlot> fieldModuleSlots;
    public final List<InventorySlot> upgradeSlots;
    private final Semaphore semaphore = new Semaphore();
    private final Set<BlockPos> projectedBlocks = Collections.synchronizedSet(new HashSet());
    private final LoadingCache<BlockPos, Pair<BlockState, Boolean>> projectionCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BlockPos, Pair<BlockState, Boolean>>(){

        public Pair<BlockState, Boolean> load(BlockPos key) {
            return ProjectorBlockEntity.this.canProjectPos(key);
        }
    });
    private int clientAnimationSpeed;

    public ProjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BaseBlockEntity>)((BlockEntityType)ModObjects.PROJECTOR_BLOCK_ENTITY.get()), pos, state, 50);
        this.secondaryCard = this.addSlot("secondaryCard", InventorySlot.Mode.BOTH, ModUtil::isCard);
        this.projectorModeSlot = this.addSlot("projectorMode", InventorySlot.Mode.BOTH, ModUtil::isProjectorMode, stack -> this.destroyField());
        this.fieldModuleSlots = (ListMultimap)StreamEx.of((Object[])Direction.values()).flatMap(side -> IntStreamEx.range((int)2).mapToEntry(i -> side, i -> this.addSlot("field_module_" + side.m_122433_() + "_" + i, InventorySlot.Mode.BOTH, stack -> ModUtil.isModule(stack, Module.Category.FIELD), stack -> this.destroyField()))).toListAndThen(ImmutableListMultimap::copyOf);
        this.upgradeSlots = this.createUpgradeSlots(6, this::isMatrixModuleOrPass, (ItemStack stack) -> this.destroyField());
    }

    @SubscribeEvent
    public void onSetBlock(SetBlockEvent event) {
        if (event.getLevel() == this.f_58857_ && !this.semaphore.isInStage(ProjectionStage.STANDBY) && !event.getState().m_60713_((Block)ModBlocks.FORCE_FIELD.get())) {
            this.projectionCache.invalidate((Object)event.getPos());
        }
    }

    private boolean isMatrixModuleOrPass(ItemStack stack) {
        return stack.getCapability(ModCapabilities.MODULE_TYPE).map(ModuleType::getCategories).map(categories -> categories.isEmpty() || categories.contains((Object)Module.Category.MATRIX)).orElse(true);
    }

    public int computeAnimationSpeed() {
        int speed = 4;
        int fortronCost = this.getFortronCost();
        if (this.isActive() && this.getMode().isPresent() && this.fortronStorage.extractFortron(fortronCost, true) >= fortronCost) {
            speed = (int)((float)speed * ((float)fortronCost / 8.0f));
        }
        return Math.min(120, speed);
    }

    public int getAnimationSpeed() {
        return this.clientAnimationSpeed;
    }

    public void setClientAnimationSpeed(int clientAnimationSpeed) {
        if (!this.f_58857_.f_46443_) {
            throw new IllegalStateException("Must only be called on the client");
        }
        this.clientAnimationSpeed = clientAnimationSpeed;
    }

    @Override
    public BlockEntity be() {
        return this;
    }

    @Override
    public BlockState getCachedBlockState(BlockPos pos) {
        return (BlockState)((Pair)this.projectionCache.getUnchecked((Object)pos)).getFirst();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.reCalculateForceField();
        }
    }

    public void m_7651_() {
        if (!this.f_58857_.f_46443_) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
        super.m_7651_();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.PROJECTOR) {
            return this.projectorOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void addModuleSlots(List<? super InventorySlot> list) {
        super.addModuleSlots(list);
        list.addAll(this.upgradeSlots);
        list.addAll(this.fieldModuleSlots.values());
    }

    @Override
    public void tickServer() {
        int speed;
        super.tickServer();
        Iterator<ScheduledEvent> it = this.scheduledEvents.iterator();
        while (it.hasNext()) {
            ScheduledEvent event = it.next();
            if (!event.countDown()) continue;
            event.runnable.run();
            it.remove();
        }
        int fortronCost = this.getFortronCost();
        if (this.isActive() && this.getMode().isPresent() && this.fortronStorage.extractFortron(fortronCost, true) >= fortronCost) {
            this.consumeCost();
            if (this.getTicks() % 10L == 0L) {
                if (this.semaphore.isInStage(ProjectionStage.STANDBY)) {
                    this.reCalculateForceField();
                } else if (this.semaphore.isReady() && this.semaphore.isComplete(ProjectionStage.SELECTING)) {
                    this.projectField();
                }
            }
            if (this.getTicks() % 40L == 0L && !this.hasModule(ModModules.SILENCE)) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.FIELD.get(), SoundSource.BLOCKS, 0.4f, 1.0f - this.f_58857_.f_46441_.m_188501_() * 0.1f);
            }
        } else {
            this.destroyField();
        }
        if ((speed = this.computeAnimationSpeed()) != this.clientAnimationSpeed) {
            this.clientAnimationSpeed = speed;
            this.sendToChunk(new UpdateAnimationSpeed(this.f_58858_, speed));
        }
    }

    @Override
    public void beforeBlockRemove() {
        this.destroyField();
        super.beforeBlockRemove();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new ProjectorMenu(containerId, this.f_58858_, player, inventory);
    }

    @Override
    protected int doGetFortronCost() {
        return super.doGetFortronCost() + 5;
    }

    @Override
    public float getAmplifier() {
        return Math.max(Math.min(this.getCalculatedFieldPositions().size() / 1000, 10), 1);
    }

    @Override
    protected void onInventoryChanged() {
        super.onInventoryChanged();
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
        }
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("animationSpeed", this.computeAnimationSpeed());
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.clientAnimationSpeed = tag.m_128451_("animationSpeed");
    }

    @Override
    public Optional<ProjectorMode> getMode() {
        return this.getModeStack().getCapability(ModCapabilities.PROJECTOR_MODE).resolve();
    }

    @Override
    public ItemStack getModeStack() {
        return this.projectorModeSlot.getItem();
    }

    @Override
    public Collection<InventorySlot> getSlotsFromSide(Direction side) {
        return this.fieldModuleSlots.get((Object)side);
    }

    @Override
    public Collection<InventorySlot> getUpgradeSlots() {
        return this.upgradeSlots;
    }

    @Override
    public BlockPos getTranslation() {
        return this.cached(TRANSLATION_CACHE_KEY, () -> {
            int zTranslationNeg = this.getModuleCount(ModModules.TRANSLATION, this.getSlotsFromSide(Direction.NORTH));
            int zTranslationPos = this.getModuleCount(ModModules.TRANSLATION, this.getSlotsFromSide(Direction.SOUTH));
            int xTranslationNeg = this.getModuleCount(ModModules.TRANSLATION, this.getSlotsFromSide(Direction.WEST));
            int xTranslationPos = this.getModuleCount(ModModules.TRANSLATION, this.getSlotsFromSide(Direction.EAST));
            int yTranslationPos = this.getModuleCount(ModModules.TRANSLATION, this.getSlotsFromSide(Direction.UP));
            int yTranslationNeg = this.getModuleCount(ModModules.TRANSLATION, this.getSlotsFromSide(Direction.DOWN));
            return new BlockPos(xTranslationPos - xTranslationNeg, yTranslationPos - yTranslationNeg, zTranslationPos - zTranslationNeg);
        });
    }

    @Override
    public BlockPos getPositiveScale() {
        return this.cached(POSITIVE_SCALE_CACHE_KEY, () -> {
            int zScalePos = this.getModuleCount(ModModules.SCALE, this.getSlotsFromSide(Direction.SOUTH));
            int xScalePos = this.getModuleCount(ModModules.SCALE, this.getSlotsFromSide(Direction.EAST));
            int yScalePos = this.getModuleCount(ModModules.SCALE, this.getSlotsFromSide(Direction.UP));
            int omnidirectionalScale = this.getModuleCount(ModModules.SCALE, this.getUpgradeSlots());
            return new BlockPos(xScalePos += omnidirectionalScale, yScalePos += omnidirectionalScale, zScalePos += omnidirectionalScale);
        });
    }

    @Override
    public BlockPos getNegativeScale() {
        return this.cached(NEGATIVE_SCALE_CACHE_KEY, () -> {
            int zScaleNeg = this.getModuleCount(ModModules.SCALE, this.getSlotsFromSide(Direction.NORTH));
            int xScaleNeg = this.getModuleCount(ModModules.SCALE, this.getSlotsFromSide(Direction.WEST));
            int yScaleNeg = this.getModuleCount(ModModules.SCALE, this.getSlotsFromSide(Direction.DOWN));
            int omnidirectionalScale = this.getModuleCount(ModModules.SCALE, this.getUpgradeSlots());
            return new BlockPos(xScaleNeg += omnidirectionalScale, yScaleNeg += omnidirectionalScale, zScaleNeg += omnidirectionalScale);
        });
    }

    @Override
    public int getRotationYaw() {
        return this.cached(ROTATION_YAW_CACHE_KEY, () -> {
            int rotation = this.getModuleCount(ModModules.ROTATION, this.getSlotsFromSide(Direction.EAST)) - this.getModuleCount(ModModules.ROTATION, this.getSlotsFromSide(Direction.WEST));
            return rotation * 2;
        });
    }

    @Override
    public int getRotationPitch() {
        return this.cached(ROTATION_PITCH_CACHE_KEY, () -> {
            int rotation = this.getModuleCount(ModModules.ROTATION, this.getSlotsFromSide(Direction.UP)) - this.getModuleCount(ModModules.ROTATION, this.getSlotsFromSide(Direction.DOWN));
            return rotation * 2;
        });
    }

    @Override
    public int getRotationRoll() {
        return this.cached(ROTATION_ROLL_CACHE_KEY, () -> {
            int rotation = this.getModuleCount(ModModules.ROTATION, this.getSlotsFromSide(Direction.SOUTH)) - this.getModuleCount(ModModules.ROTATION, this.getSlotsFromSide(Direction.NORTH));
            return rotation * 2;
        });
    }

    @Override
    public Collection<TargetPosPair> getCalculatedFieldPositions() {
        return this.semaphore.getOrDefault(ProjectionStage.CALCULATING, List.of());
    }

    @Override
    public Set<BlockPos> getInteriorPoints() {
        return this.cached(INTERIOR_POINTS_CACHE_KEY, () -> {
            Set<Vec3> interiorPoints = this.getMode().orElseThrow().getInteriorPoints(this);
            BlockPos translation = this.f_58858_.m_121955_((Vec3i)this.getTranslation());
            int rotationYaw = this.getRotationYaw();
            int rotationPitch = this.getRotationPitch();
            int rotationRoll = this.getRotationRoll();
            return StreamEx.of(interiorPoints).map(pos -> rotationYaw != 0 || rotationPitch != 0 || rotationRoll != 0 ? ModUtil.rotateByAngleExact(pos, rotationYaw, rotationPitch, rotationRoll) : pos).map(pos -> BlockPos.m_274446_((Position)pos).m_121955_((Vec3i)translation)).toSet();
        });
    }

    public void projectField() {
        CompletableFuture<Object> task = this.semaphore.beginStage(ProjectionStage.PROJECTING);
        for (Module module : this.getModuleInstances()) {
            module.beforeProject(this);
        }
        BlockState state = ((ForceFieldBlockImpl)ModBlocks.FORCE_FIELD.get()).m_49966_();
        List projectable = (List)this.semaphore.getResult(ProjectionStage.SELECTING);
        block1: for (TargetPosPair pair : projectable) {
            BlockPos pos = pair.pos();
            for (Module module : this.getModuleInstances()) {
                Module.ProjectAction action = module.onProject(this, pos);
                if (action == Module.ProjectAction.SKIP) continue block1;
                if (action != Module.ProjectAction.INTERRUPT) continue;
                break block1;
            }
            this.f_58857_.m_7731_(pos, state, 4);
            this.f_58857_.m_141902_(pos, (BlockEntityType)ModObjects.FORCE_FIELD_BLOCK_ENTITY.get()).ifPresent(be -> {
                be.setProjector(this.f_58858_);
                BlockState camouflage = this.getCamoBlock(pair.original());
                if (camouflage != null) {
                    be.setCamouflage(camouflage);
                }
            });
            this.f_58857_.m_7260_(pos, state, state, 3);
            this.fortronStorage.extractFortron(1, false);
            this.projectedBlocks.add(pos);
            this.projectionCache.invalidate((Object)pos);
        }
        task.complete(null);
        this.runSelectionTask();
    }

    @Override
    public void schedule(int delay, Runnable runnable) {
        this.scheduledEvents.add(new ScheduledEvent(delay, runnable));
    }

    private Pair<BlockState, Boolean> canProjectPos(BlockPos pos) {
        BlockState state = this.f_58857_.m_8055_(pos);
        boolean canProject = (state.m_60795_() || state.m_278721_() || state.m_204336_(ModTags.FORCEFIELD_REPLACEABLE) || this.hasModule(ModModules.DISINTEGRATION) && state.m_60800_((BlockGetter)this.f_58857_, pos) != -1.0f) && !state.m_60713_((Block)ModBlocks.FORCE_FIELD.get()) && !pos.equals((Object)this.f_58858_);
        return Pair.of((Object)state, (Object)canProject);
    }

    @Override
    public void destroyField() {
        Collection<TargetPosPair> fieldPositions = this.getCalculatedFieldPositions();
        this.projectedBlocks.clear();
        this.projectionCache.invalidateAll();
        this.semaphore.reset();
        if (!this.f_58857_.f_46443_) {
            ((StreamEx)StreamEx.of(fieldPositions).map(TargetPosPair::pos).filter(pos -> this.f_58857_.m_8055_(pos).m_60713_((Block)ModBlocks.FORCE_FIELD.get()))).forEach(pos -> this.f_58857_.m_7471_(pos, false));
        }
    }

    @Override
    public int getProjectionSpeed() {
        return 28 + 28 * this.getModuleCount(ModModules.SPEED, this.getUpgradeSlots());
    }

    @Override
    public int getModuleCount(ModuleType<?> module, Collection<InventorySlot> slots) {
        return module == ModModules.SCALE && this.getModeStack().m_41720_() instanceof CustomProjectorModeItem ? 0 : super.getModuleCount(module, slots);
    }

    private void reCalculateForceField() {
        if (this.getMode().isPresent()) {
            Item item = this.getModeStack().m_41720_();
            if (item instanceof ObjectCache) {
                ObjectCache cache = (ObjectCache)item;
                cache.clearCache();
            }
            ((CompletableFuture)this.runCalculationTask().thenCompose(v -> this.runSelectionTask())).exceptionally(throwable -> {
                MFFSMod.LOGGER.error("Error calculating force field blocks", throwable);
                return null;
            });
        }
    }

    public BlockState getCamoBlock(Vec3 pos) {
        if (!this.f_58857_.f_46443_ && this.hasModule(ModModules.CAMOUFLAGE)) {
            CustomProjectorModeItem custom;
            Map<Vec3, BlockState> map;
            BlockState block;
            Item item = this.getModeStack().m_41720_();
            if (item instanceof CustomProjectorModeItem && (block = (map = (custom = (CustomProjectorModeItem)item).getFieldBlocks(this, this.getModeStack())).get(pos)) != null) {
                return block;
            }
            return this.getAllModuleItemsStream().mapPartial(ProjectorBlockEntity::getFilterBlock).findFirst().map(Block::m_49966_).orElse(null);
        }
        return null;
    }

    private CompletableFuture<?> runCalculationTask() {
        return ((CompletableFuture)this.semaphore.beginStage(ProjectionStage.CALCULATING).completeAsync(this::calculateFieldPositions).whenComplete((list, ex) -> {
            for (Module module : this.getModuleInstances()) {
                module.onCalculate(this, (Collection<TargetPosPair>)list);
            }
            Collections.shuffle(list);
        })).exceptionally(throwable -> {
            MFFSMod.LOGGER.error("Error calculating force field", throwable);
            return List.of();
        });
    }

    private List<TargetPosPair> calculateFieldPositions() {
        ProjectorMode mode = this.getMode().orElseThrow();
        Set<Vec3> fieldPoints = this.hasModule(ModModules.INVERTER) ? mode.getInteriorPoints(this) : mode.getExteriorPoints(this);
        BlockPos translation = this.getTranslation();
        int rotationYaw = this.getRotationYaw();
        int rotationPitch = this.getRotationPitch();
        int rotationRoll = this.getRotationRoll();
        return StreamEx.of(fieldPoints).mapToEntry(pos -> rotationYaw != 0 || rotationPitch != 0 || rotationRoll != 0 ? ModUtil.rotateByAngleExact(pos, rotationYaw, rotationPitch, rotationRoll) : pos).mapValues(pos -> pos.m_82520_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()).m_82520_((double)translation.m_123341_(), (double)translation.m_123342_(), (double)translation.m_123343_())).filterValues(pos -> pos.m_7098_() <= (double)this.f_58857_.m_141928_()).mapKeyValue((original, pos) -> new TargetPosPair(new BlockPos((int)Math.round(pos.f_82479_), (int)Math.round(pos.f_82480_), (int)Math.round(pos.f_82481_)), (Vec3)original)).toMutableList();
    }

    private CompletableFuture<?> runSelectionTask() {
        return this.semaphore.beginStage(ProjectionStage.SELECTING).completeAsync(this::selectProjectablePositions).exceptionally(throwable -> {
            MFFSMod.LOGGER.error("Error selecting force field blocks", throwable);
            return List.of();
        });
    }

    private List<TargetPosPair> selectProjectablePositions() {
        Item item;
        if (this.projectedBlocks.isEmpty() && (item = this.getModeStack().m_41720_()) instanceof ObjectCache) {
            ObjectCache cache = (ObjectCache)item;
            cache.clearCache();
        }
        ArrayList<TargetPosPair> fieldToBeProjected = new ArrayList<TargetPosPair>(this.getCalculatedFieldPositions());
        Set<Module> modules = this.getModuleInstances();
        for (Module module : modules) {
            module.beforeSelect(this, fieldToBeProjected);
        }
        int constructionSpeed = Math.min(this.getProjectionSpeed(), (Integer)MFFSConfig.COMMON.maxFFGenPerTick.get());
        ArrayList<TargetPosPair> projectable = new ArrayList<TargetPosPair>();
        int constructionCount = 0;
        block1: for (int i = 0; i < fieldToBeProjected.size() && constructionCount < constructionSpeed && !this.m_58901_() && this.semaphore.isInStage(ProjectionStage.SELECTING); ++i) {
            TargetPosPair pair = (TargetPosPair)fieldToBeProjected.get(i);
            BlockPos pos = pair.pos();
            for (Module module : modules) {
                Module.ProjectAction action = module.onSelect(this, pos);
                if (action == Module.ProjectAction.SKIP) continue block1;
                if (action != Module.ProjectAction.INTERRUPT) continue;
                break block1;
            }
            if (!((Boolean)((Pair)this.projectionCache.getUnchecked((Object)pos)).getSecond()).booleanValue() || !this.f_58857_.m_46749_(pos)) continue;
            projectable.add(pair);
            ++constructionCount;
        }
        return projectable;
    }

    public static Optional<Block> getFilterBlock(ItemStack stack) {
        BlockItem blockItem;
        Block block;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()).m_49966_().m_60799_() != RenderShape.INVISIBLE) {
            return Optional.of(block);
        }
        return Optional.empty();
    }

    private static class Semaphore {
        private ProjectionStage stage = ProjectionStage.STANDBY;
        private final Map<ProjectionStage, CompletableFuture<Object>> tasks = new HashMap<ProjectionStage, CompletableFuture<Object>>();

        private Semaphore() {
        }

        public synchronized <T> CompletableFuture<T> beginStage(ProjectionStage stage) {
            if (this.isReady()) {
                this.stage = stage;
                CompletableFuture task = new CompletableFuture();
                this.tasks.put(stage, task);
                return task;
            }
            throw new RuntimeException("Attempted to switch stage before it was completed");
        }

        public synchronized boolean isComplete(ProjectionStage stage) {
            return this.tasks.containsKey((Object)stage) && this.tasks.get((Object)stage).isDone();
        }

        public synchronized boolean isInStage(ProjectionStage stage) {
            return this.stage == stage;
        }

        public synchronized boolean isReady() {
            return this.stage == ProjectionStage.STANDBY || this.isComplete(this.stage);
        }

        public synchronized <T> T getResult(ProjectionStage stage) {
            CompletableFuture<Object> task = this.tasks.get((Object)stage);
            if (!task.isDone()) {
                throw new RuntimeException("Stage " + String.valueOf((Object)stage) + " hasn't completed yet!");
            }
            return (T)task.join();
        }

        public synchronized <T> T getOrDefault(ProjectionStage stage, T defaultValue) {
            return (T)(this.tasks.containsKey((Object)stage) ? this.tasks.get((Object)stage).getNow(defaultValue) : defaultValue);
        }

        public synchronized void reset() {
            this.stage = ProjectionStage.STANDBY;
            this.tasks.clear();
        }
    }

    private static enum ProjectionStage {
        STANDBY,
        CALCULATING,
        SELECTING,
        PROJECTING;

    }

    private static class ScheduledEvent {
        public final Runnable runnable;
        public int ticks;

        public ScheduledEvent(int ticks, Runnable runnable) {
            this.ticks = ticks;
            this.runnable = runnable;
        }

        public boolean countDown() {
            return --this.ticks <= 0;
        }
    }
}

