/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import dev.su5ed.mffs.setup.ModClientSetup;
import dev.su5ed.mffs.util.ModUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BaseItem
extends Item {
    private final Lazy<Component> description;

    public BaseItem(ExtendedItemProperties properties) {
        super(properties.properties);
        this.description = properties.description != null ? Lazy.of(() -> properties.description.apply(this)) : null;
    }

    protected void appendHoverTextPre(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        this.appendHoverTextPre(stack, level, tooltipComponents, isAdvanced);
        if (this.description != null) {
            if (ModClientSetup.hasShiftDown()) {
                tooltipComponents.add((Component)this.description.get());
            } else {
                tooltipComponents.add((Component)ModUtil.translate("info", "show_details", ModUtil.translate("info", "key.shift", new Object[0]).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public static class ExtendedItemProperties {
        private final Item.Properties properties;
        private Function<Item, Component> description;

        public ExtendedItemProperties(Item.Properties properties) {
            this.properties = properties;
        }

        public ExtendedItemProperties description() {
            this.description = item -> {
                String name = ForgeRegistries.ITEMS.getKey(item).m_135815_();
                return ModUtil.translate("item", name + ".description", new Object[0]).m_130940_(ChatFormatting.GRAY);
            };
            return this;
        }
    }
}

