/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.resources.data.analysis;

import fabric.net.mca.resources.data.SerializablePair;
import fabric.net.mca.resources.data.analysis.Analysis;

public class ChanceAnalysis
extends Analysis<Integer> {
    private static final long serialVersionUID = -2685774468194171791L;

    @Override
    public boolean isPositive(Integer v) {
        return v >= 0;
    }

    @Override
    public String asString(Integer v) {
        return String.valueOf(v);
    }

    @Override
    public String getTotalAsString() {
        float positive = this.getSummands().stream().mapToInt(SerializablePair::getRight).filter(v -> v > 0).sum();
        float negative = -this.getSummands().stream().mapToInt(SerializablePair::getRight).filter(v -> v < 0).sum();
        int chance = (int)(positive / (positive + negative) * 100.0f);
        return chance + "% chance";
    }

    @Override
    public Integer getTotal() {
        return this.getSummands().stream().mapToInt(SerializablePair::getRight).sum();
    }
}

