/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.maid;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.modulargolems.compat.maid.GolemSummonUtils;
import dev.xkmc.modulargolems.compat.maid.MaidManageGolemBehavior;
import dev.xkmc.modulargolems.compat.maid.MaidSummonerStrafingBehavior;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;

public class MaidSummonerTask
implements IRangedAttackTask {
    public static final ResourceLocation UID = ModularGolems.loc("summon_golems");
    private static final int STOP_MOVING_DIST = 24;
    private static final int STOP_ATTACK_DIST = 35;

    public ResourceLocation getUid() {
        return UID;
    }

    public ItemStack getIcon() {
        return GolemItems.HOLDER_GOLEM.asStack();
    }

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return (SoundEvent)InitSounds.MAID_FIND_TARGET.get();
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, this.createStartAttack()), Pair.of((Object)5, this.createStopAttack(maid)), Pair.of((Object)5, this.createMoveToTarget(0.6f)), Pair.of((Object)5, (Object)((Object)new MaidSummonerStrafingBehavior(20, 24))), Pair.of((Object)5, (Object)((Object)new MaidManageGolemBehavior()))});
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, this.createStartAttack()), Pair.of((Object)5, this.createStopAttack(maid)), Pair.of((Object)5, (Object)((Object)new MaidManageGolemBehavior()))});
    }

    private void stopAttack(EntityMaid self, LivingEntity target) {
        GolemSummonUtils.collectAll(self);
    }

    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_golem_wand", MaidSummonerTask::hasGolemWand));
    }

    public void performRangedAttack(EntityMaid maid, LivingEntity target, float v) {
    }

    public float searchRadius(EntityMaid maid) {
        return 35.0f;
    }

    public static boolean hasGolemWand(EntityMaid maid) {
        return maid.m_21205_().m_204117_(MGTagGen.GOLEM_OMNI_WAND);
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > 35.0f;
    }

    private BehaviorControl<EntityMaid> createStartAttack() {
        return StartAttacking.m_257741_(MaidSummonerTask::hasGolemWand, IAttackTask::findFirstValidAttackTarget);
    }

    private BehaviorControl<EntityMaid> createStopAttack(EntityMaid maid) {
        return StopAttackingIfTargetInvalid.m_257811_(target -> !MaidSummonerTask.hasGolemWand(maid) || this.farAway((LivingEntity)target, maid), this::stopAttack, (boolean)true);
    }

    private BehaviorControl<EntityMaid> createMoveToTarget(float speed) {
        return BehaviorBuilder.m_258034_(ins -> ins.group((App)ins.m_257492_(MemoryModuleType.f_26370_), (App)ins.m_257492_(MemoryModuleType.f_26371_), (App)ins.m_257492_(MemoryModuleType.f_26374_), (App)ins.m_257495_(MemoryModuleType.f_26372_), (App)ins.m_257492_(MemoryModuleType.f_148205_)).apply((Applicative)ins, (toNavigate, toLook, interactTarget, attackTarget, targetList) -> (level, self, time) -> {
            Optional fix = ins.m_257828_(interactTarget);
            if (fix.isPresent()) {
                toLook.m_257512_((Object)new EntityTracker((Entity)fix.get(), true));
                if (self.m_19950_((Entity)fix.get(), 1.5)) {
                    toNavigate.m_257971_();
                } else {
                    toNavigate.m_257512_((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)fix.get(), false), speed, 0));
                }
            } else {
                LivingEntity atk = (LivingEntity)ins.m_258051_(attackTarget);
                Optional optList = ins.m_257828_(targetList);
                if (optList.isPresent() && ((NearestVisibleLivingEntities)optList.get()).m_186107_(atk) && self.m_19950_((Entity)atk, 24.0)) {
                    toNavigate.m_257971_();
                } else {
                    toLook.m_257512_((Object)new EntityTracker((Entity)atk, true));
                    toNavigate.m_257512_((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)atk, false), speed, 0));
                }
            }
            return true;
        }));
    }
}

