/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.l2hostility;

import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2hostility.content.item.traits.EnchantmentDisabler;
import dev.xkmc.l2hostility.content.traits.legendary.DispellTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DispellModifier
extends GolemModifier {
    public DispellModifier() {
        super(StatFilterType.ATTACK, 4);
    }

    @Override
    public void modifySource(AbstractGolemEntity<?, ?> golem, CreateSourceEvent event, int value) {
        if (event.getResult() == null) {
            return;
        }
        if (!event.getResult().validState((DamageState)DefaultDamageState.BYPASS_MAGIC)) {
            return;
        }
        event.enable((DamageState)DefaultDamageState.BYPASS_MAGIC);
    }

    @Override
    public void onHurtTarget(AbstractGolemEntity<?, ?> entity, LivingHurtEvent event, int level) {
        LivingEntity target = event.getEntity();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = target.m_6844_(slot);
            if (!stack.m_41793_() || stack.m_41784_().m_128441_("l2hostility_enchantment")) continue;
            list.add(stack);
        }
        if (!list.isEmpty()) {
            int time = (Integer)LHConfig.COMMON.dispellTime.get() * level;
            int count = Math.min(level, list.size());
            for (int i = 0; i < count; ++i) {
                int index = entity.m_217043_().m_188503_(list.size());
                EnchantmentDisabler.disableEnchantment((Level)entity.m_9236_(), (ItemStack)((ItemStack)list.remove(index)), (int)time);
            }
        }
    }

    @Override
    public void onAttacked(AbstractGolemEntity<?, ?> entity, LivingAttackEvent event, int level) {
        if (level > 0 && !event.getSource().m_269533_(DamageTypeTags.f_268738_) && !event.getSource().m_269533_(DamageTypeTags.f_268437_) && event.getSource().m_269533_(L2DamageTypes.MAGIC)) {
            event.setCanceled(true);
        }
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        ArrayList<MutableComponent> ans = new ArrayList<MutableComponent>();
        ans.add(Component.m_237110_((String)(((DispellTrait)LHTraits.DISPELL.get()).getDescriptionId() + ".desc"), (Object[])new Object[]{Component.m_237113_((String)("" + v)).m_130940_(ChatFormatting.AQUA), Component.m_237113_((String)("" + (Integer)LHConfig.COMMON.dispellTime.get() * v / 20)).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GREEN));
        return ans;
    }
}

