/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.base;

import dev.xkmc.l2library.base.effects.EffectUtil;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class PotionAttackModifier
extends GolemModifier {
    private final Function<Integer, MobEffectInstance> func;

    public PotionAttackModifier(StatFilterType type, int maxLevel, Function<Integer, MobEffectInstance> func) {
        super(type, maxLevel);
        this.func = func;
    }

    @Override
    public void onHurtTarget(AbstractGolemEntity<?, ?> entity, LivingHurtEvent event, int level) {
        this.applyPotion(entity, event.getEntity(), level);
    }

    @Override
    public void onHurt(AbstractGolemEntity<?, ?> entity, LivingHurtEvent event, int level) {
        Entity entity2 = event.getSource().m_7640_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            this.applyPotion(entity, attacker, level);
        }
    }

    private void applyPotion(AbstractGolemEntity<?, ?> self, LivingEntity target, int level) {
        if (!target.m_9236_().m_5776_()) {
            EffectUtil.addEffect((LivingEntity)target, (MobEffectInstance)this.func.apply(level), (EffectUtil.AddReason)EffectUtil.AddReason.NONE, self);
        }
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        MobEffectInstance ins = this.func.apply(v);
        MutableComponent lang = Component.m_237115_((String)ins.m_19576_());
        MobEffect mobeffect = ins.m_19544_();
        if (ins.m_19564_() > 0) {
            lang = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{lang, Component.m_237115_((String)("potion.potency." + ins.m_19564_()))});
        }
        if (ins.m_19557_() >= 20) {
            lang = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{lang, MobEffectUtil.m_267641_((MobEffectInstance)ins, (float)1.0f)});
        }
        lang = lang.m_130940_(mobeffect.m_19483_().m_19497_());
        return List.of(MGLangData.POTION_ATTACK.get(lang).m_130940_(ChatFormatting.GREEN));
    }
}

