/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.special;

import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.entity.mode.GolemModes;
import dev.xkmc.modulargolems.events.event.GolemHandleExpEvent;
import dev.xkmc.modulargolems.events.event.GolemHandleItemEvent;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.mixin.ExperienceOrbAccessor;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PickupGoal
extends Goal {
    private static final int INTERVAL = 10;
    private static final int DELAY = 80;
    private static final String KEY = "modulargolems:pickup_delay";
    private final AbstractGolemEntity<?, ?> golem;
    private final int lv;
    private int delay = 0;
    private int destroyItemCount = 0;
    private int destroyExpCount = 0;
    private BlockEntity target;

    public PickupGoal(AbstractGolemEntity<?, ?> golem, int lv) {
        this.golem = golem;
        this.lv = lv;
    }

    public boolean m_8036_() {
        return true;
    }

    public void m_8037_() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.delay = 10;
        AABB box = this.golem.m_20191_().m_82400_((double)(this.lv * (Integer)MGConfig.COMMON.basePickupRange.get()));
        this.tryHandleItem(box);
        this.tryHandleExp(box);
    }

    private void tryHandleItem(AABB box) {
        Player player = this.golem.getOwner();
        List items = this.golem.m_9236_().m_142425_(EntityTypeTest.m_156916_(ItemEntity.class), box, e -> true);
        this.validateTarget();
        GolemConfigEntry config = this.golem.getConfigEntry(null);
        for (ItemEntity item : items) {
            if (config != null && !config.pickupFilter.allowPickup(item.m_32055_())) continue;
            this.handleLeftoverItem(item, player);
        }
        if (this.destroyItemCount > 0 && player != null) {
            ModularGolems.LOGGER.info(MGLangData.DESTROY_ITEM.get(new Object[]{this.golem, this.destroyItemCount}).getString());
            player.m_213846_((Component)MGLangData.DESTROY_ITEM.get(new Object[]{this.golem, this.destroyItemCount}));
            this.destroyItemCount = 0;
        }
    }

    private void tryHandleExp(AABB box) {
        Player player = this.golem.getOwner();
        List exps = this.golem.m_9236_().m_142425_(EntityTypeTest.m_156916_(ExperienceOrb.class), box, e -> true);
        ExperienceOrb first = null;
        for (ExperienceOrb exp : exps) {
            exp.f_20770_ *= ((ExperienceOrbAccessor)exp).getCount();
            ((ExperienceOrbAccessor)exp).setCount(1);
            if (first == null) {
                first = exp;
                continue;
            }
            first.f_20770_ += exp.f_20770_;
            exp.m_146870_();
        }
        if (first != null) {
            this.handleLeftoverExp(first, player);
        }
        if (this.destroyExpCount > 0 && player != null) {
            player.m_213846_((Component)MGLangData.DESTROY_EXP.get(new Object[]{this.golem, this.destroyExpCount}));
            this.destroyExpCount = 0;
        }
    }

    private int repairGolemAndItems(int exp) {
        Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)Enchantments.f_44962_, this.golem, ItemStack::m_41768_);
        if (entry != null) {
            ItemStack itemstack = (ItemStack)entry.getValue();
            float ratio = itemstack.getXpRepairRatio();
            int recovered = Math.min((int)((float)exp * ratio), itemstack.m_41773_());
            itemstack.m_41721_(itemstack.m_41773_() - recovered);
            int remain = ratio <= 0.0f ? 0 : (int)Math.max(0.0f, (float)exp - (float)recovered / ratio);
            return remain > 0 ? this.repairGolemAndItems(remain) : 0;
        }
        if (!this.golem.hasFlag(GolemFlags.MENDING)) {
            return exp;
        }
        float lost = this.golem.m_21233_() - this.golem.m_21223_();
        float ratio = ((Integer)MGConfig.COMMON.mendingXpCost.get()).intValue();
        float heal = Math.min(lost, (float)exp / ratio);
        int cost = (int)(heal * ratio);
        this.golem.m_5634_(heal);
        return exp - cost;
    }

    private void handleLeftoverItem(ItemEntity item, @Nullable Player player) {
        LazyOptional opt;
        if (item.getPersistentData().m_128425_(KEY, 4) && item.getPersistentData().m_128454_(KEY) > item.m_9236_().m_46467_()) {
            return;
        }
        GolemHandleItemEvent event = new GolemHandleItemEvent(this.golem, item);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (item.m_32055_().m_41619_()) {
            item.m_146870_();
        }
        if (item.m_213877_()) {
            return;
        }
        if (this.target != null && this.golem.getMode() == GolemModes.STAND && (opt = this.target.getCapability(ForgeCapabilities.ITEM_HANDLER)).resolve().isPresent()) {
            IItemHandler handler = (IItemHandler)opt.resolve().get();
            ItemStack remain = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)item.m_32055_(), (boolean)false);
            if (remain.m_41619_()) {
                item.m_146870_();
                return;
            }
            item.m_32045_(remain);
        }
        if (player != null && player.m_6084_()) {
            item.m_6123_(player);
            if (!item.m_213877_()) {
                item.m_20219_(player.m_20182_());
                item.getPersistentData().m_128356_(KEY, item.m_9236_().m_46467_() + 80L);
                return;
            }
        }
        if (item.m_213877_()) {
            return;
        }
        if (this.golem.hasFlag(GolemFlags.NO_DESTROY) || item.m_32063_()) {
            return;
        }
        this.destroyItemCount += item.m_32055_().m_41613_();
        item.m_146870_();
    }

    private void handleLeftoverExp(ExperienceOrb exp, @Nullable Player player) {
        exp.f_20770_ = this.repairGolemAndItems(exp.f_20770_);
        GolemHandleExpEvent event = new GolemHandleExpEvent(this.golem, exp);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (exp.f_20770_ <= 0) {
            exp.m_146870_();
        }
        if (exp.m_213877_()) {
            return;
        }
        if (player != null) {
            player.f_36101_ = 0;
            exp.m_6123_(player);
        }
        if (exp.m_213877_()) {
            return;
        }
        this.destroyExpCount += exp.f_20770_;
        exp.m_146870_();
    }

    private void validateTarget() {
        if (this.target != null && !this.target.m_58901_() && this.target.m_58904_() == this.golem.m_9236_() && this.target.m_58899_().m_123331_((Vec3i)this.golem.m_20183_()) <= 9.0) {
            return;
        }
        this.target = null;
        BlockPos origin = this.golem.m_20183_();
        BlockPos.MutableBlockPos pos = origin.m_122032_();
        int r = 1;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    double d;
                    BlockEntity be;
                    pos.m_122154_((Vec3i)origin, i, j, k);
                    if (!this.golem.m_9236_().m_8055_((BlockPos)pos).m_204336_(MGTagGen.POTENTIAL_DST) || (be = this.golem.m_9236_().m_7702_((BlockPos)pos)) == null || !be.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().isPresent() || !((d = pos.m_203193_((Position)this.golem.m_20182_())) < dist)) continue;
                    this.target = be;
                    dist = d;
                }
            }
        }
    }
}

