/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.common.entity.movement;

import com.nyfaria.nyfsspiders.common.entity.mob.IClimberEntity;
import com.nyfaria.nyfsspiders.common.entity.mob.Orientation;
import com.nyfaria.nyfsspiders.common.entity.movement.ClimberJumpController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ClimberMoveController<T extends Mob>
extends MoveControl {
    protected final IClimberEntity climber;
    @Nullable
    protected BlockPos block;
    @Nullable
    protected Direction side;

    public ClimberMoveController(T entity) {
        super(entity);
        this.climber = (IClimberEntity)entity;
    }

    public void m_6849_(double x, double y, double z, double speedIn) {
        this.setMoveTo(x, y, z, null, null, speedIn);
    }

    public void setMoveTo(double x, double y, double z, BlockPos block, Direction side, double speedIn) {
        super.m_6849_(x, y, z, speedIn);
        this.block = block;
        this.side = side;
    }

    public void m_8126_() {
        double speed = (double)this.climber.getMovementSpeed() * this.f_24978_;
        if (this.f_24981_ == MoveControl.Operation.STRAFE) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            float forward = this.f_24979_;
            float strafe = this.f_24980_;
            float moveSpeed = Mth.m_14116_((float)(forward * forward + strafe * strafe));
            if (moveSpeed < 1.0f) {
                moveSpeed = 1.0f;
            }
            moveSpeed = (float)speed / moveSpeed;
            Orientation orientation = this.climber.getOrientation();
            Vec3 forwardVector = orientation.getGlobal(this.f_24974_.f_19857_, 0.0f);
            Vec3 strafeVector = orientation.getGlobal(this.f_24974_.f_19857_ + 90.0f, 0.0f);
            if (!this.isWalkableAtOffset(forwardVector.f_82479_ * (double)(forward *= moveSpeed) + strafeVector.f_82479_ * (double)(strafe *= moveSpeed), forwardVector.f_82480_ * (double)forward + strafeVector.f_82480_ * (double)strafe, forwardVector.f_82481_ * (double)forward + strafeVector.f_82481_ * (double)strafe)) {
                this.f_24979_ = 1.0f;
                this.f_24980_ = 0.0f;
            }
            this.f_24974_.m_7910_((float)speed);
            this.f_24974_.m_21564_(this.f_24979_);
            this.f_24974_.m_21570_(this.f_24980_);
        } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            double hdz;
            double hdy;
            double hdx;
            double hdsq;
            this.f_24981_ = MoveControl.Operation.WAIT;
            double dx = this.f_24975_ - this.f_24974_.m_20185_();
            double dy = this.f_24976_ - this.f_24974_.m_20186_();
            double dz = this.f_24977_ - this.f_24974_.m_20189_();
            if (this.side != null && this.block != null) {
                VoxelShape shape = this.f_24974_.m_9236_().m_8055_(this.block).m_60812_((BlockGetter)this.f_24974_.m_9236_(), this.block);
                AABB aabb = this.f_24974_.m_20191_();
                double ox = 0.0;
                double oy = 0.0;
                double oz = 0.0;
                switch (this.side) {
                    case DOWN: {
                        if (!(aabb.f_82289_ >= (double)this.block.m_123342_() + shape.m_83297_(Direction.Axis.Y) - 0.01)) break;
                        ox -= 0.1;
                        break;
                    }
                    case UP: {
                        if (!(aabb.f_82292_ <= (double)this.block.m_123342_() + shape.m_83288_(Direction.Axis.Y) + 0.01)) break;
                        oy += 0.1;
                        break;
                    }
                    case WEST: {
                        if (!(aabb.f_82288_ >= (double)this.block.m_123341_() + shape.m_83297_(Direction.Axis.X) - 0.01)) break;
                        ox -= 0.1;
                        break;
                    }
                    case EAST: {
                        if (!(aabb.f_82291_ <= (double)this.block.m_123341_() + shape.m_83288_(Direction.Axis.X) + 0.01)) break;
                        ox += 0.1;
                        break;
                    }
                    case NORTH: {
                        if (!(aabb.f_82290_ >= (double)this.block.m_123343_() + shape.m_83297_(Direction.Axis.Z) - 0.01)) break;
                        oz -= 0.1;
                        break;
                    }
                    case SOUTH: {
                        if (!(aabb.f_82293_ <= (double)this.block.m_123343_() + shape.m_83288_(Direction.Axis.Z) + 0.01)) break;
                        oz += 0.1;
                    }
                }
                AABB blockAabb = new AABB(this.block.m_121945_(this.side.m_122424_()));
                if (aabb.m_82381_(blockAabb)) {
                    Direction.Axis offsetAxis = this.side.m_122434_();
                    double allowedOffset = shape.m_83259_(offsetAxis, aabb.m_82386_((double)(-this.block.m_123341_()), (double)(-this.block.m_123342_()), (double)(-this.block.m_123343_())), switch (offsetAxis) {
                        default -> (float)this.side.m_122429_() * 0.5f;
                        case Direction.Axis.Y -> (float)this.side.m_122430_() * 0.5f;
                        case Direction.Axis.Z -> (float)this.side.m_122431_() * 0.5f;
                    });
                    switch (this.side) {
                        case DOWN: {
                            if (!(aabb.f_82289_ + allowedOffset < (double)this.block.m_123342_() + shape.m_83297_(Direction.Axis.Y) - 0.01)) break;
                            oy = 0.0;
                            break;
                        }
                        case UP: {
                            if (!(aabb.f_82292_ + allowedOffset > (double)this.block.m_123342_() + shape.m_83288_(Direction.Axis.Y) + 0.01)) break;
                            oy = 0.0;
                            break;
                        }
                        case WEST: {
                            if (!(aabb.f_82288_ + allowedOffset < (double)this.block.m_123341_() + shape.m_83297_(Direction.Axis.X) - 0.01)) break;
                            ox = 0.0;
                            break;
                        }
                        case EAST: {
                            if (!(aabb.f_82291_ + allowedOffset > (double)this.block.m_123341_() + shape.m_83288_(Direction.Axis.X) + 0.01)) break;
                            ox = 0.0;
                            break;
                        }
                        case NORTH: {
                            if (!(aabb.f_82290_ + allowedOffset < (double)this.block.m_123343_() + shape.m_83297_(Direction.Axis.Z) - 0.01)) break;
                            oz = 0.0;
                            break;
                        }
                        case SOUTH: {
                            if (!(aabb.f_82293_ + allowedOffset > (double)this.block.m_123343_() + shape.m_83288_(Direction.Axis.Z) + 0.01)) break;
                            oz = 0.0;
                        }
                    }
                }
                dx += ox;
                dy += oy;
                dz += oz;
            }
            Direction mainOffsetDir = Direction.m_122366_((double)dx, (double)dy, (double)dz);
            float reach = switch (mainOffsetDir) {
                case Direction.DOWN -> 0.0f;
                case Direction.UP -> this.f_24974_.m_20206_();
                default -> this.f_24974_.m_20205_() * 0.5f;
            };
            double verticalOffset = Math.abs((double)mainOffsetDir.m_122429_() * dx) + Math.abs((double)mainOffsetDir.m_122430_() * dy) + Math.abs((double)mainOffsetDir.m_122431_() * dz);
            Direction groundDir = (Direction)this.climber.getGroundDirection().getLeft();
            Vec3 jumpDir = null;
            if (this.side != null && verticalOffset > (double)(reach - 0.05f) && groundDir != this.side && groundDir.m_122434_() != this.side.m_122434_() && (hdsq = (hdx = (double)(1 - Math.abs(mainOffsetDir.m_122429_())) * dx) * hdx + (hdy = (double)(1 - Math.abs(mainOffsetDir.m_122430_())) * dy) * hdy + (hdz = (double)(1 - Math.abs(mainOffsetDir.m_122431_())) * dz) * hdz) < (double)0.707f) {
                dx -= (double)((float)this.side.m_122429_() * 0.2f);
                dy -= (double)((float)this.side.m_122430_() * 0.2f);
                dz -= (double)((float)this.side.m_122431_() * 0.2f);
                if (hdsq < (double)0.1f) {
                    jumpDir = new Vec3((double)mainOffsetDir.m_122429_(), (double)mainOffsetDir.m_122430_(), (double)mainOffsetDir.m_122431_());
                }
            }
            Orientation orientation = this.climber.getOrientation();
            Vec3 up = orientation.getGlobal(this.f_24974_.f_19857_, -90.0f);
            Vec3 offset = new Vec3(dx, dy, dz);
            Vec3 targetDir = offset.m_82546_(up.m_82490_(offset.m_82526_(up)));
            double targetDist = targetDir.m_82553_();
            targetDir = targetDir.m_82541_();
            if (targetDist < 1.0E-4) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                float rx = (float)orientation.localZ.m_82526_(targetDir);
                float ry = (float)orientation.localX.m_82526_(targetDir);
                this.f_24974_.f_19857_ = this.m_24991_(this.f_24974_.f_19857_, 270.0f - (float)Math.toDegrees(Mth.m_14136_((double)rx, (double)ry)), 90.0f);
                if (jumpDir == null && this.side != null && targetDist < 0.1 && groundDir == this.side.m_122424_()) {
                    jumpDir = new Vec3((double)this.side.m_122429_(), (double)this.side.m_122430_(), (double)this.side.m_122431_());
                }
                if (jumpDir != null) {
                    this.f_24974_.m_7910_((float)speed * 0.5f);
                    JumpControl jumpController = this.f_24974_.m_21569_();
                    if (jumpController instanceof ClimberJumpController) {
                        ((ClimberJumpController)jumpController).setJumping(jumpDir);
                    }
                } else {
                    this.f_24974_.m_7910_((float)speed);
                }
            }
        } else if (this.f_24981_ == MoveControl.Operation.JUMPING) {
            this.f_24974_.m_7910_((float)speed);
            if (this.f_24974_.m_20096_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
        } else {
            this.f_24974_.m_21564_(0.0f);
        }
    }

    private boolean isWalkableAtOffset(double x, double y, double z) {
        NodeEvaluator processor;
        PathNavigation navigator = this.f_24974_.m_21573_();
        return navigator == null || (processor = navigator.m_26575_()) == null || processor.m_8086_((BlockGetter)this.f_24974_.m_9236_(), Mth.m_14107_((double)(this.f_24974_.m_20185_() + x)), Mth.m_14107_((double)(this.f_24974_.m_20186_() + (double)(this.f_24974_.m_20206_() * 0.5f) + y)), Mth.m_14107_((double)(this.f_24974_.m_20189_() + z))) == BlockPathTypes.WALKABLE;
    }
}

