/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.blocks.BlockStructureScanner;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.HashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;

public class StructureRenderHandler {
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static boolean showedMessage;
    private static int dimension;

    public static void setStructure(Structure structure, StructureConfiguration configuration) {
        currentStructure = structure;
        currentConfiguration = configuration;
        showedMessage = false;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            dimension = mc.f_91073_.m_6042_().f_63865_();
        }
    }

    public static void renderClickedBlock(PoseStack matrixStack, MultiBufferSource multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        if (currentStructure != null && dimension == Minecraft.m_91087_().f_91074_.m_9236_().m_6042_().f_63865_() && currentConfiguration != null && CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            BlockPos originalPos = StructureRenderHandler.currentConfiguration.pos.m_7494_();
            float blockXOffset = originalPos.m_123341_();
            float blockZOffset = originalPos.m_123343_();
            float blockStartYOffset = originalPos.m_123342_();
            StructureRenderHandler.drawBox(matrixStack, multiBufferSource, blockXOffset, blockZOffset, blockStartYOffset, (float)cameraX, (float)cameraY, (float)cameraZ, 1, 1, 1);
        }
    }

    private static void drawBox(PoseStack matrixStack, MultiBufferSource multiBufferSource, float blockXOffset, float blockZOffset, float blockStartYOffset, float cameraX, float cameraY, float cameraZ, int xLength, int zLength, int height) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        float translatedX = blockXOffset - cameraX;
        float translatedY = (float)((double)(blockStartYOffset - cameraY) + 0.02);
        float translatedYEnd = (float)((double)(translatedY + (float)height) - 0.02);
        float translatedZ = blockZOffset - cameraZ;
        VertexConsumer bufferBuilder = multiBufferSource.m_6299_(RenderType.m_269399_((double)2.0));
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder = multiBufferSource.m_6299_(RenderType.m_269399_((double)2.0));
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder = multiBufferSource.m_6299_(RenderType.m_269399_((double)2.0));
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedY, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedYEnd, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder = multiBufferSource.m_6299_(RenderType.m_269399_((double)2.0));
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedY, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder = multiBufferSource.m_6299_(RenderType.m_269399_((double)2.0));
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedY, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedY, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedY, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedY, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder = multiBufferSource.m_6299_(RenderType.m_269399_((double)2.0));
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedYEnd, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX + (float)xLength, translatedYEnd, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, translatedX, translatedYEnd, translatedZ + (float)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void renderScanningBoxes(PoseStack matrixStack, MultiBufferSource multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        if (Prefab.proxy.structureScanners.isEmpty()) {
            return;
        }
        for (int i = 0; i < Prefab.proxy.structureScanners.size(); ++i) {
            StructureScannerConfig config = Prefab.proxy.structureScanners.get(i);
            BlockPos pos = config.blockPos;
            boolean removeConfig = false;
            boolean bl = removeConfig = pos == null;
            if (pos != null) {
                boolean bl2 = removeConfig = !(Minecraft.m_91087_().f_91073_.m_8055_(pos).m_60734_() instanceof BlockStructureScanner);
            }
            if (removeConfig) {
                Prefab.proxy.structureScanners.remove(i);
                --i;
                continue;
            }
            Direction leftDirection = config.direction.m_122428_();
            BlockPos startingPosition = config.blockPos.m_5484_(leftDirection, config.blocksToTheLeft).m_5484_(Direction.DOWN, config.blocksDown).m_5484_(config.direction, config.blocksParallel);
            int xLength = config.blocksWide;
            int zLength = config.blocksLong;
            switch (config.direction) {
                case NORTH: {
                    zLength = -zLength;
                    startingPosition = startingPosition.m_121945_(config.direction.m_122424_());
                    break;
                }
                case EAST: {
                    int tempWidth = xLength;
                    xLength = zLength;
                    zLength = tempWidth;
                    break;
                }
                case SOUTH: {
                    xLength = -xLength;
                    startingPosition = startingPosition.m_121945_(config.direction.m_122428_());
                    break;
                }
                case WEST: {
                    int tempLength = zLength;
                    zLength = -xLength;
                    xLength = -tempLength;
                    startingPosition = startingPosition.m_121945_(config.direction.m_122424_());
                    startingPosition = startingPosition.m_121945_(config.direction.m_122428_());
                    break;
                }
            }
            StructureRenderHandler.drawBox(matrixStack, multiBufferSource, startingPosition.m_123341_(), startingPosition.m_123343_(), startingPosition.m_123342_(), (float)cameraX, (float)cameraY, (float)cameraZ, xLength, zLength, config.blocksTall);
        }
    }

    public static void newRenderPlayerLook(Player player, PoseStack ms, VertexConsumer buffer, double cameraX, double cameraY, double cameraZ) {
        if (currentStructure != null && dimension == player.m_9236_().m_6042_().f_63865_() && currentConfiguration != null && CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            Level world = player.m_9236_();
            Vec3 cameraPosition = new Vec3(cameraX, cameraY, cameraZ);
            Direction playerViewDirection = player.m_6350_();
            Vec3 playerViewVector = player.m_20252_(1.0f);
            HashMap<Integer, BakedModel> modelMap = new HashMap<Integer, BakedModel>();
            HashMap<Integer, Integer> stateColor = new HashMap<Integer, Integer>();
            for (BuildBlock buildBlock : currentStructure.getBlocks()) {
                Block foundSubBlock;
                double result;
                double lineBetweenPlayerViewBlock;
                boolean boolCheck;
                BlockPos buildBlockPos;
                BlockState targetBlock;
                Block foundBlock = buildBlock.getBlockState() != null ? buildBlock.getBlockState().m_60734_() : (Block)BuiltInRegistries.f_256975_.m_7745_(buildBlock.getResourceLocation());
                if (foundBlock == null) continue;
                if (buildBlock.blockPos == null) {
                    buildBlock.blockPos = buildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
                }
                if ((targetBlock = world.m_8055_(buildBlockPos = buildBlock.blockPos)).m_60734_() != Blocks.f_50016_ && targetBlock.m_60734_() != Blocks.f_49990_) continue;
                if (buildBlock.centerOfBlock == null) {
                    buildBlock.centerOfBlock = Vec3.m_82512_((Vec3i)buildBlockPos);
                }
                Vec3 vectorBetweenPlayerAndBlock = new Vec3((double)buildBlockPos.m_123341_() - player.m_20185_(), (double)buildBlockPos.m_123342_() - player.m_20188_(), (double)buildBlockPos.m_123343_() - player.m_20189_());
                vectorBetweenPlayerAndBlock.m_82541_();
                BlockHitResult hitResult = Shapes.m_83144_().m_83220_(cameraPosition, buildBlock.centerOfBlock, buildBlockPos);
                if (hitResult == null || hitResult.m_82434_() != Direction.UP && hitResult.m_82434_() != Direction.DOWN && hitResult.m_82434_() == playerViewDirection || !(boolCheck = (lineBetweenPlayerViewBlock = playerViewVector.m_82541_().m_82526_(vectorBetweenPlayerAndBlock)) > (result = 1.0 - 0.025 / vectorBetweenPlayerAndBlock.m_82553_()))) continue;
                if (buildBlock.getBlockState() == null) {
                    BlockState blockState = foundBlock.m_49966_();
                    buildBlock = BuildBlock.SetBlockState(currentConfiguration, StructureRenderHandler.currentConfiguration.pos, buildBlock, foundBlock, blockState, currentStructure.getClearSpace().getShape().getDirection());
                }
                StructureRenderHandler.renderBlockAt(ms, buffer, buildBlock.getBlockState(), buildBlockPos, buildBlock.hashCode(), modelMap, stateColor);
                if (buildBlock.getSubBlock() == null) continue;
                BuildBlock subBuildBlock = buildBlock.getSubBlock();
                Block block = foundSubBlock = subBuildBlock.getBlockState() != null ? subBuildBlock.getBlockState().m_60734_() : (Block)BuiltInRegistries.f_256975_.m_7745_(subBuildBlock.getResourceLocation());
                if (subBuildBlock.getBlockState() == null) {
                    BlockState subBlockState = foundSubBlock.m_49966_();
                    subBuildBlock = BuildBlock.SetBlockState(currentConfiguration, StructureRenderHandler.currentConfiguration.pos, buildBlock.getSubBlock(), foundSubBlock, subBlockState, currentStructure.getClearSpace().getShape().getDirection());
                }
                if (subBuildBlock.blockPos == null) {
                    subBuildBlock.blockPos = subBuildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
                }
                StructureRenderHandler.renderBlockAt(ms, buffer, subBuildBlock.getBlockState(), subBuildBlock.blockPos, subBuildBlock.hashCode(), modelMap, stateColor);
            }
        }
    }

    private static void renderBlockAt(PoseStack ms, VertexConsumer buffer, BlockState state, BlockPos pos, int buildBlockHash, HashMap<Integer, BakedModel> modelMap, HashMap<Integer, Integer> colorMap) {
        if (state.m_60799_() != RenderShape.INVISIBLE && state.m_60799_() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.m_91087_();
            Camera camera = minecraft.m_91290_().f_114358_;
            double renderPosX = camera.m_90583_().m_7096_();
            double renderPosY = camera.m_90583_().m_7098_();
            double renderPosZ = camera.m_90583_().m_7094_();
            ms.m_85836_();
            ms.m_85837_(-renderPosX, -renderPosY, -renderPosZ);
            BlockRenderDispatcher brd = minecraft.m_91289_();
            ms.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            BakedModel model = modelMap.computeIfAbsent(buildBlockHash, x -> brd.m_110910_(state));
            int color = colorMap.computeIfAbsent(state.hashCode(), x -> minecraft.m_91298_().m_92577_(state, null, null, 0));
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            brd.m_110937_().renderModel(ms.m_85850_(), buffer, state, model, r, g, b, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, (RenderType)null);
            ms.m_85849_();
        }
    }

    static {
        showedMessage = false;
    }
}

