/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.progressivebosses.event.DragonPhaseEvent;
import insane96mcp.progressivebosses.event.PBEventFactory;
import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonValue;
import insane96mcp.progressivebosses.module.dragon.data.PhaseChanger;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonChargePlayerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;

@JsonAdapter(value=Serializer.class)
public class ChargePlayerComponent
implements DragonComponent,
PhaseChanger {
    public DragonValue chance;
    private static final int RANGE = 96;
    static final String FORCE_CHARGE_TAG = "progressivebosses:force_charge";

    public static boolean isForcedToCharge(EnderDragon dragon) {
        return ChargePlayerComponent.getForcedToCharge(dragon) > 0;
    }

    public static int getForcedToCharge(EnderDragon dragon) {
        return dragon.getPersistentData().m_128451_(FORCE_CHARGE_TAG);
    }

    public static void setForcedToCharge(EnderDragon dragon, int forcedToCharge) {
        dragon.getPersistentData().m_128405_(FORCE_CHARGE_TAG, forcedToCharge);
    }

    @Override
    public void onPhaseBegin(DragonPhaseEvent.Begin event, EnderDragon dragon) {
        if (event.getPhaseInstance().m_7309_() != EnderDragonPhase.f_31385_) {
            return;
        }
        Player player = DragonFeature.getRandomPlayer(dragon, dragon.m_9236_(), 96);
        if (player == null) {
            return;
        }
        ((DragonChargePlayerPhase)dragon.m_31157_().m_31418_(EnderDragonPhase.f_31385_)).m_31207_(player.m_20182_());
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public EnderDragonPhase<?> getPhase() {
        return EnderDragonPhase.f_31385_;
    }

    @Override
    public boolean shouldExecute(EnderDragon dragon) {
        if (DragonFeature.getRandomPlayer(dragon, dragon.m_9236_(), 96) == null) {
            return false;
        }
        if (ChargePlayerComponent.isForcedToCharge(dragon)) {
            return true;
        }
        double chance = this.chance.getValue(dragon);
        if (chance == 0.0) {
            return false;
        }
        return dragon.m_217043_().m_188500_() < chance;
    }

    @Override
    public void execute(EnderDragon dragon, boolean forceBegin) {
        dragon.m_31157_().m_31416_(EnderDragonPhase.f_31385_);
        if (ChargePlayerComponent.isForcedToCharge(dragon)) {
            ChargePlayerComponent.setForcedToCharge(dragon, ChargePlayerComponent.getForcedToCharge(dragon) - 1);
        }
        if (forceBegin) {
            DragonPhaseInstance phase = dragon.m_31157_().m_31418_(EnderDragonPhase.f_31385_);
            phase.m_7083_();
            PBEventFactory.onDragonPhaseBegin(dragon, phase);
        }
    }

    public static class Serializer
    implements JsonDeserializer<ChargePlayerComponent> {
        public ChargePlayerComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ChargePlayerComponent component = new ChargePlayerComponent();
            JsonObject jObject = json.getAsJsonObject();
            component.chance = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"chance", (JsonDeserializationContext)context, DragonValue.class);
            return component;
        }
    }
}

