/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.progressivebosses.module.dragon.data.AngerComponent;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;

@JsonAdapter(value=Serializer.class)
public class DragonValue {
    public float base;
    public float angered;

    public DragonValue(float value) {
        this.base = value;
        this.angered = value;
    }

    public DragonValue(float base, float angered) {
        this.base = base;
        this.angered = angered;
    }

    public float getValue(EnderDragon dragon) {
        if (this.base == this.angered) {
            return this.base;
        }
        return AngerComponent.isAngered(dragon) ? this.angered : this.base;
    }

    public int getIntValue(EnderDragon dragon) {
        return (int)this.getValue(dragon);
    }

    public static class Serializer
    implements JsonSerializer<DragonValue>,
    JsonDeserializer<DragonValue> {
        public DragonValue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return new DragonValue(json.getAsFloat(), json.getAsFloat());
            }
            JsonObject jsonObject = json.getAsJsonObject();
            float base = GsonHelper.m_13915_((JsonObject)jsonObject, (String)"base");
            float withNoCrystalsLeft = GsonHelper.m_13915_((JsonObject)jsonObject, (String)"angered");
            return new DragonValue(base, withNoCrystalsLeft);
        }

        public JsonElement serialize(DragonValue src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.base == src.angered) {
                return new JsonPrimitive((Number)Float.valueOf(src.base));
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("base", (Number)Float.valueOf(src.base));
            jsonObject.addProperty("angered", (Number)Float.valueOf(src.angered));
            return jsonObject;
        }
    }
}

