/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.module.wither.data.PoweredValue;
import insane96mcp.progressivebosses.module.wither.entity.PBWither;
import insane96mcp.progressivebosses.module.wither.entity.minion.WitherMinion;
import insane96mcp.progressivebosses.setup.PBEntities;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@JsonAdapter(value=Serializer.class)
public class WitherMinionStats {
    public PoweredValue minionsSpawned;
    public PoweredValue maxAround;
    public PoweredValue minCooldown;
    public PoweredValue maxCooldown;
    public PoweredValue health;
    public PoweredValue bonusMovementSpeed;
    public PoweredValue bowChance;
    public float sharpnessChance;
    public float knockbackChance;
    public float powerChance;
    public float punchChance;

    public WitherMinionStats(PoweredValue minionsSpawned, PoweredValue maxAround, PoweredValue minCooldown, PoweredValue maxCooldown, PoweredValue health, PoweredValue bonusMovementSpeed, PoweredValue bowChance, float sharpnessChance, float knockbackChance, float powerChance, float punchChance) {
        this.minionsSpawned = minionsSpawned;
        this.maxAround = maxAround;
        this.minCooldown = minCooldown;
        this.maxCooldown = maxCooldown;
        this.health = health;
        this.bonusMovementSpeed = bonusMovementSpeed;
        this.bowChance = bowChance;
        this.sharpnessChance = sharpnessChance;
        this.knockbackChance = knockbackChance;
        this.powerChance = powerChance;
        this.punchChance = punchChance;
    }

    public void setCooldown(PBWither wither) {
        this.setCooldown(wither, 1.0f);
    }

    public void setCooldown(PBWither wither, float divider) {
        wither.minionCooldown = (int)((float)Mth.m_216271_((RandomSource)wither.m_217043_(), (int)this.minCooldown.getIntValue(wither), (int)this.maxCooldown.getIntValue(wither)) / divider);
    }

    public void trySpawnMinion(PBWither wither, boolean force) {
        if (wither.m_21224_() || wither.getInvulnerableTicks() > 0) {
            return;
        }
        int radius = 48;
        BlockPos pos1 = wither.m_20183_().m_7918_(-radius, -radius, -radius);
        BlockPos pos2 = wither.m_20183_().m_7918_(radius, radius, radius);
        AABB bb = new AABB(pos1, pos2);
        List players = wither.m_9236_().m_45976_(ServerPlayer.class, bb);
        if (!force && players.isEmpty()) {
            return;
        }
        int minionsCountInAABB = wither.m_9236_().m_45976_(WitherMinion.class, wither.m_20191_().m_82400_(24.0)).size();
        if (!force && minionsCountInAABB >= this.maxAround.getIntValue(wither)) {
            return;
        }
        this.setCooldown(wither);
        for (int i = 0; i < this.minionsSpawned.getIntValue(wither); ++i) {
            int x = 0;
            int y = 0;
            int z = 0;
            for (int t = 0; t < 5; ++t) {
                x = (int)(wither.m_20185_() + (double)wither.m_217043_().m_216339_(-3, 4));
                y = (int)(wither.m_20186_() + 3.0);
                z = (int)(wither.m_20189_() + (double)wither.m_217043_().m_216339_(-3, 4));
                y = MCUtils.getFittingY((EntityType)((EntityType)PBEntities.WITHER_MINION.get()), (BlockPos)new BlockPos(x, y, z), (Level)wither.m_9236_(), (int)8);
                if (y != -1) break;
            }
            if (y <= wither.m_9236_().m_141937_()) continue;
            WitherMinion.create(new Vec3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), wither);
            if (++minionsCountInAABB >= this.maxAround.getIntValue(wither)) break;
        }
    }

    public static class Serializer
    implements JsonSerializer<WitherMinionStats>,
    JsonDeserializer<WitherMinionStats> {
        public WitherMinionStats deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new WitherMinionStats((PoweredValue)context.deserialize(json.getAsJsonObject().get("minions_spawned"), PoweredValue.class), (PoweredValue)context.deserialize(json.getAsJsonObject().get("max_minion_around"), PoweredValue.class), (PoweredValue)context.deserialize(json.getAsJsonObject().get("min_cooldown"), PoweredValue.class), (PoweredValue)context.deserialize(json.getAsJsonObject().get("max_cooldown"), PoweredValue.class), (PoweredValue)context.deserialize(json.getAsJsonObject().get("health"), PoweredValue.class), (PoweredValue)context.deserialize(json.getAsJsonObject().get("bonus_movement_speed"), PoweredValue.class), (PoweredValue)context.deserialize(json.getAsJsonObject().get("bow_chance"), PoweredValue.class), GsonHelper.m_13915_((JsonObject)json.getAsJsonObject(), (String)"sharpness_chance"), GsonHelper.m_13915_((JsonObject)json.getAsJsonObject(), (String)"knockback_chance"), GsonHelper.m_13915_((JsonObject)json.getAsJsonObject(), (String)"power_chance"), GsonHelper.m_13915_((JsonObject)json.getAsJsonObject(), (String)"punch_chance"));
        }

        public JsonElement serialize(WitherMinionStats src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("minions_spawned", context.serialize((Object)src.minionsSpawned));
            jsonObject.add("max_minion_around", context.serialize((Object)src.maxAround));
            jsonObject.add("min_cooldown", context.serialize((Object)src.minCooldown));
            jsonObject.add("max_cooldown", context.serialize((Object)src.maxCooldown));
            jsonObject.add("health", context.serialize((Object)src.health));
            jsonObject.add("bonus_movement_speed", context.serialize((Object)src.bonusMovementSpeed));
            jsonObject.add("bow_chance", context.serialize((Object)src.bowChance));
            jsonObject.add("sharpness_chance", context.serialize((Object)Float.valueOf(src.sharpnessChance)));
            jsonObject.add("knockback_chance", context.serialize((Object)Float.valueOf(src.knockbackChance)));
            jsonObject.add("power_chance", context.serialize((Object)Float.valueOf(src.powerChance)));
            jsonObject.add("punch_chance", context.serialize((Object)Float.valueOf(src.punchChance)));
            return jsonObject;
        }
    }
}

