/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.EmptyPart;
import com.mojang.datafixers.util.Unit;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.permutated.pylons.item.MobFilterCard;
import net.permutated.pylons.item.PlayerFilterCard;
import net.permutated.pylons.item.PotionFilterCard;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.machines.expulsion.ExpulsionPylonBlock;
import net.permutated.pylons.machines.expulsion.ExpulsionPylonContainer;
import net.permutated.pylons.machines.expulsion.ExpulsionPylonTile;
import net.permutated.pylons.machines.harvester.HarvesterPylonBlock;
import net.permutated.pylons.machines.harvester.HarvesterPylonContainer;
import net.permutated.pylons.machines.harvester.HarvesterPylonTile;
import net.permutated.pylons.machines.infusion.InfusionPylonBlock;
import net.permutated.pylons.machines.infusion.InfusionPylonContainer;
import net.permutated.pylons.machines.infusion.InfusionPylonTile;
import net.permutated.pylons.machines.interdiction.InterdictionPylonBlock;
import net.permutated.pylons.machines.interdiction.InterdictionPylonContainer;
import net.permutated.pylons.machines.interdiction.InterdictionPylonTile;
import net.permutated.pylons.util.TranslationKey;

public class ModRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pylons");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"pylons");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"pylons");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"pylons");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"pylons");
    public static final RegistryObject<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("creative_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)TranslationKey.tab())).m_257737_(() -> ((Item)PLAYER_FILTER.get()).m_7968_()).m_257501_((parameters, output) -> ITEMS.getEntries().stream().map(RegistryObject::get).map(Item::m_7968_).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0))).m_257652_());
    public static final RegistryObject<Item> PLAYER_FILTER = ITEMS.register("player_filter", PlayerFilterCard::new);
    public static final RegistryObject<Item> POTION_FILTER = ITEMS.register("potion_filter", PotionFilterCard::new);
    public static final RegistryObject<Item> MOB_FILTER = ITEMS.register("mob_filter", MobFilterCard::new);
    public static final RegistryObject<Block> EXPULSION_PYLON = BLOCKS.register("expulsion_pylon", ExpulsionPylonBlock::new);
    public static final RegistryObject<Block> INFUSION_PYLON = BLOCKS.register("infusion_pylon", InfusionPylonBlock::new);
    public static final RegistryObject<Block> HARVESTER_PYLON = BLOCKS.register("harvester_pylon", HarvesterPylonBlock::new);
    public static final RegistryObject<Block> INTERDICTION_PYLON = BLOCKS.register("interdiction_pylon", InterdictionPylonBlock::new);
    public static final RegistryObject<BlockItem> EXPULSION_PYLON_ITEM = ModRegistry.blockItem(EXPULSION_PYLON);
    public static final RegistryObject<BlockItem> INFUSION_PYLON_ITEM = ModRegistry.blockItem(INFUSION_PYLON);
    public static final RegistryObject<BlockItem> HARVESTER_PYLON_ITEM = ModRegistry.blockItem(HARVESTER_PYLON);
    public static final RegistryObject<BlockItem> INTERDICTION_PYLON_ITEM = ModRegistry.blockItem(INTERDICTION_PYLON);
    public static final RegistryObject<BlockEntityType<ExpulsionPylonTile>> EXPULSION_PYLON_TILE = ModRegistry.blockEntity(EXPULSION_PYLON, ExpulsionPylonTile::new);
    public static final RegistryObject<BlockEntityType<InfusionPylonTile>> INFUSION_PYLON_TILE = ModRegistry.blockEntity(INFUSION_PYLON, InfusionPylonTile::new);
    public static final RegistryObject<BlockEntityType<HarvesterPylonTile>> HARVESTER_PYLON_TILE = ModRegistry.blockEntity(HARVESTER_PYLON, HarvesterPylonTile::new);
    public static final RegistryObject<BlockEntityType<InterdictionPylonTile>> INTERDICTION_PYLON_TILE = ModRegistry.blockEntity(INTERDICTION_PYLON, InterdictionPylonTile::new);
    public static final RegistryObject<MenuType<ExpulsionPylonContainer>> EXPULSION_PYLON_CONTAINER = ModRegistry.container("expulsion_pylon", ExpulsionPylonContainer::new);
    public static final RegistryObject<MenuType<InfusionPylonContainer>> INFUSION_PYLON_CONTAINER = ModRegistry.container("infusion_pylon", InfusionPylonContainer::new);
    public static final RegistryObject<MenuType<HarvesterPylonContainer>> HARVESTER_PYLON_CONTAINER = ModRegistry.container("harvester_pylon", HarvesterPylonContainer::new);
    public static final RegistryObject<MenuType<InterdictionPylonContainer>> INTERDICTION_PYLON_CONTAINER = ModRegistry.container("interdiction_pylon", InterdictionPylonContainer::new);
    private static final Type<Unit> EMPTY_PART = new EmptyPart();

    private ModRegistry() {
    }

    private static RegistryObject<BlockItem> blockItem(RegistryObject<Block> registryObject) {
        return ITEMS.register(registryObject.getId().m_135815_(), () -> new BlockItem((Block)registryObject.get(), new Item.Properties()));
    }

    private static RegistryObject<Item> material(String path) {
        return ITEMS.register(path, () -> new Item(new Item.Properties()));
    }

    private static <T extends AbstractPylonTile> RegistryObject<BlockEntityType<T>> blockEntity(RegistryObject<Block> registryObject, BlockEntityType.BlockEntitySupplier<T> supplier) {
        return TILES.register(registryObject.getId().m_135815_(), () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{(Block)registryObject.get()}).m_58966_(EMPTY_PART));
    }

    private static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> container(String path, IContainerFactory<T> supplier) {
        return CONTAINERS.register(path, () -> IForgeMenuType.create((IContainerFactory)supplier));
    }

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        BLOCKS.register(bus);
        TILES.register(bus);
        CONTAINERS.register(bus);
        CREATIVE_TABS.register(bus);
    }
}

