/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.inventory.PatrolLeaderContainer;
import com.talhanation.recruits.network.MessageAssignGroupToCompanion;
import com.talhanation.recruits.network.MessagePatrolLeaderAddWayPoint;
import com.talhanation.recruits.network.MessagePatrolLeaderRemoveWayPoint;
import com.talhanation.recruits.network.MessagePatrolLeaderSetCycle;
import com.talhanation.recruits.network.MessagePatrolLeaderSetInfoMode;
import com.talhanation.recruits.network.MessagePatrolLeaderSetPatrolState;
import com.talhanation.recruits.network.MessagePatrolLeaderSetPatrollingSpeed;
import com.talhanation.recruits.network.MessageRemoveAssignedGroupFromCompanion;
import de.maxhenkel.recruits.corelib.inventory.ScreenBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class PatrolLeaderScreen
extends ScreenBase<PatrolLeaderContainer> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/professions/waypoint_list_gui.png");
    public static int recruitsSize;
    private EditBox textBoxX;
    private EditBox textBoxY;
    private EditBox textBoxZ;
    private final Player player;
    private final AbstractLeaderEntity recruit;
    private int page = 1;
    public static List<BlockPos> waypoints;
    public static List<ItemStack> waypointItems;
    private int leftPos;
    private int topPos;
    private boolean cycle;
    private boolean fastPatrolling;
    private AbstractLeaderEntity.State state;
    private AbstractLeaderEntity.InfoMode infoMode;
    private static final MutableComponent TOOLTIP_START;
    private static final MutableComponent TOOLTIP_DISABLED_START;
    private static final MutableComponent TOOLTIP_STOP;
    private static final MutableComponent TOOLTIP_PAUSE;
    private static final MutableComponent TOOLTIP_RESUME;
    private static final MutableComponent BUTTON_START;
    private static final MutableComponent BUTTON_STOP;
    private static final MutableComponent BUTTON_PAUSE;
    private static final MutableComponent BUTTON_RESUME;
    private static final MutableComponent TOOLTIP_CYCLE;
    private static final MutableComponent TOOLTIP_LINE;
    private static final MutableComponent TOOLTIP_FAST_PATROLLING;
    private static final MutableComponent BUTTON_CYCLE;
    private static final MutableComponent BUTTON_LINE;
    private static final MutableComponent BUTTON_FAST;
    private static final MutableComponent BUTTON_NORMAL;
    private static final MutableComponent INFO_MODE_ALL;
    private static final MutableComponent INFO_MODE_HOSTILE;
    private static final MutableComponent INFO_MODE_ENEMY;
    private static final MutableComponent INFO_MODE_NONE;
    private static final MutableComponent TOOLTIP_ADD;
    private static final MutableComponent TOOLTIP_REMOVE;
    private static final MutableComponent TOOLTIP_INFO_MODE;
    private static final MutableComponent BUTTON_ASSIGN_RECRUITS;
    private static final MutableComponent BUTTON_REMOVE_ASSIGNED_RECRUITS;
    private static final MutableComponent TOOLTIP_ASSIGN_RECRUITS;
    private static final MutableComponent TOOLTIP_REMOVE_ASSIGNED_RECRUITS;
    private static final MutableComponent TOOLTIP_CHEST;
    private static final int fontColor = 0x404040;
    private ForgeSlider waitSlider;
    private final int offset = 88;

    public PatrolLeaderScreen(PatrolLeaderContainer container, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, container, playerInventory, (Component)Component.m_237113_((String)""));
        this.f_97726_ = 384;
        this.f_97727_ = 256;
        this.player = container.getPlayerEntity();
        this.recruit = container.getRecruit();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = this.offset + (this.f_96543_ - this.f_97726_) / 2;
        this.topPos = (this.f_96544_ - this.f_97727_) / 2;
        this.cycle = this.recruit.getCycle();
        this.fastPatrolling = this.recruit.getFastPatrolling();
        this.state = AbstractLeaderEntity.State.fromIndex(this.recruit.getPatrollingState());
        this.infoMode = AbstractLeaderEntity.InfoMode.fromIndex(this.recruit.getInfoMode());
        this.setButtons();
        this.setHoverAreas();
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        guiGraphics.m_280163_(this.texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        this.drawHoverAreas(guiGraphics, mouseX, mouseY);
    }

    private void setHoverAreas() {
        this.hoverAreas = new ArrayList();
        Supplier<List<FormattedCharSequence>> supplier = () -> new ArrayList<FormattedCharSequence>(List.of(FormattedCharSequence.m_13714_((String)TOOLTIP_CHEST.getString(), (Style)Style.f_131099_)));
        ScreenBase.HoverArea hoverAreaChest = new ScreenBase.HoverArea(this.leftPos + 150, this.topPos + 57, 25, 25, supplier);
        this.hoverAreas.add(hoverAreaChest);
    }

    private void setButtons() {
        MutableComponent stopToolTip;
        MutableComponent stopString;
        MutableComponent startToolTip;
        MutableComponent startString;
        this.m_169413_();
        this.setPageButtons();
        this.setWaypointButtons();
        this.setCoordinatesBoxes();
        this.setAssignButton();
        if (this.state != AbstractLeaderEntity.State.PAUSED) {
            startString = BUTTON_START;
            startToolTip = TOOLTIP_START;
        } else {
            startString = BUTTON_RESUME;
            startToolTip = TOOLTIP_RESUME;
        }
        if (this.state != AbstractLeaderEntity.State.PATROLLING) {
            stopString = BUTTON_STOP;
            stopToolTip = TOOLTIP_STOP;
        } else {
            stopString = BUTTON_PAUSE;
            stopToolTip = TOOLTIP_PAUSE;
        }
        MutableComponent cycleString = this.cycle ? BUTTON_CYCLE : BUTTON_LINE;
        MutableComponent cycleToolTip = this.cycle ? TOOLTIP_CYCLE : TOOLTIP_LINE;
        this.setCycleButton((Component)cycleString, (Component)cycleToolTip);
        this.setStartButtons((Component)startString, (Component)startToolTip);
        this.setStopButtons(this.state, (Component)stopString, (Component)stopToolTip);
        MutableComponent infoModeString = null;
        switch (this.infoMode) {
            case ALL: {
                infoModeString = INFO_MODE_ALL;
                break;
            }
            case HOSTILE: {
                infoModeString = INFO_MODE_HOSTILE;
                break;
            }
            case ENEMY: {
                infoModeString = INFO_MODE_ENEMY;
                break;
            }
            case NONE: {
                infoModeString = INFO_MODE_NONE;
            }
        }
        this.setNotificationButton((Component)infoModeString);
        MutableComponent fastPatrollingString = this.fastPatrolling ? BUTTON_FAST : BUTTON_NORMAL;
        this.setFastPatrollingButton((Component)fastPatrollingString);
        this.setInfoButton();
    }

    private void setNotificationButton(Component infoModeString) {
        Button infoButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 216, this.topPos + 62, 50, 20, infoModeString, button -> {
            this.infoMode = this.infoMode.getNext();
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePatrolLeaderSetInfoMode(this.recruit.m_20148_(), this.infoMode.getIndex()));
            this.setButtons();
        }));
        infoButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_INFO_MODE));
    }

    private void setInfoButton() {
        Button infoButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 216, this.topPos + 11, 20, 20, (Component)Component.m_237113_((String)"i"), button -> {
            this.player.m_213846_((Component)Component.m_237115_((String)"chat.recruits.info.patrol_leader_info"));
            this.m_7379_();
        }));
    }

    private void setAssignButton() {
        Button assignButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 216, this.topPos + 140, 107, 20, (Component)BUTTON_ASSIGN_RECRUITS, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAssignGroupToCompanion(this.player.m_20148_(), this.recruit.m_20148_()))));
        assignButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_ASSIGN_RECRUITS));
        Button removeButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 216, this.topPos + 165, 107, 20, (Component)BUTTON_REMOVE_ASSIGNED_RECRUITS, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRemoveAssignedGroupFromCompanion(this.player.m_20148_(), this.recruit.m_20148_()))));
        removeButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_REMOVE));
    }

    private void setCoordinatesBoxes() {
        int posX = this.recruit.m_20097_().m_123341_();
        int posY = this.recruit.m_20097_().m_123342_();
        int posZ = this.recruit.m_20097_().m_123343_();
        this.textBoxX = new EditBox(this.f_96547_, this.leftPos + 16 + 15, this.topPos + 37, 43, 18, (Component)Component.m_237113_((String)String.valueOf(posX)));
        this.textBoxX.m_94144_(String.valueOf(posX));
        this.textBoxX.m_94202_(-1);
        this.textBoxX.m_94205_(-1);
        this.textBoxX.m_94182_(true);
        this.textBoxX.m_94199_(13);
        this.textBoxY = new EditBox(this.f_96547_, this.leftPos + 16 + 75, this.topPos + 37, 43, 18, (Component)Component.m_237113_((String)String.valueOf(posY)));
        this.textBoxY.m_94144_(String.valueOf(posY));
        this.textBoxY.m_94202_(-1);
        this.textBoxY.m_94205_(-1);
        this.textBoxY.m_94182_(true);
        this.textBoxY.m_94199_(13);
        this.textBoxZ = new EditBox(this.f_96547_, this.leftPos + 16 + 135, this.topPos + 37, 43, 18, (Component)Component.m_237113_((String)String.valueOf(posZ)));
        this.textBoxZ.m_94144_(String.valueOf(posZ));
        this.textBoxZ.m_94202_(-1);
        this.textBoxZ.m_94205_(-1);
        this.textBoxZ.m_94182_(true);
        this.textBoxZ.m_94199_(13);
        this.m_142416_((GuiEventListener)this.textBoxX);
        this.m_142416_((GuiEventListener)this.textBoxY);
        this.m_142416_((GuiEventListener)this.textBoxZ);
    }

    private void setWaitTimeSlider() {
        boolean minValue = false;
        int maxValue = 30;
        boolean step = false;
        MutableComponent prefix = Component.m_237113_((String)"");
        MutableComponent suffix = Component.m_237113_((String)" min");
        this.waitSlider = new ForgeSlider(this.leftPos + 16, this.topPos + 36, 179, 20, (Component)prefix, (Component)suffix, (double)minValue, (double)maxValue, (double)this.recruit.getWaitTimeInMin(), (double)step, 0, true);
        this.m_142416_((GuiEventListener)this.waitSlider);
    }

    public void setCycleButton(Component cycle, Component tooltip) {
        Button cycleButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 105, this.topPos + 11, 40, 20, cycle, button -> {
            this.cycle = !this.cycle;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePatrolLeaderSetCycle(this.recruit.m_20148_(), this.cycle));
            this.setButtons();
        }));
        cycleButton.m_257544_(Tooltip.m_257550_((Component)tooltip));
        cycleButton.f_93623_ = this.recruit instanceof CaptainEntity && !(this.recruit.m_20202_() instanceof Boat) ? false : this.state == AbstractLeaderEntity.State.STOPPED || this.state == AbstractLeaderEntity.State.IDLE;
    }

    public void setFastPatrollingButton(Component cycle) {
        Button buttonFastPatrolling = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 216, this.topPos + 92, 50, 20, cycle, button -> {
            this.fastPatrolling = !this.fastPatrolling;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePatrolLeaderSetPatrollingSpeed(this.recruit.m_20148_(), this.fastPatrolling));
            this.setButtons();
        }));
        buttonFastPatrolling.f_93623_ = false;
        buttonFastPatrolling.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_FAST_PATROLLING));
    }

    public void setStartButtons(Component start, Component tooltip) {
        Button startButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 19, this.topPos + 11, 40, 20, start, button -> {
            this.state = AbstractLeaderEntity.State.PATROLLING;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePatrolLeaderSetPatrolState(this.recruit.m_20148_(), 1));
            this.setButtons();
        }));
        startButton.f_93623_ = this.recruit instanceof CaptainEntity && !(this.recruit.m_20202_() instanceof Boat) ? false : this.state != AbstractLeaderEntity.State.PATROLLING;
        startButton.m_257544_(Tooltip.m_257550_((Component)(this.recruit instanceof CaptainEntity && !(this.recruit.m_20202_() instanceof Boat) ? TOOLTIP_DISABLED_START : tooltip)));
    }

    public void setStopButtons(AbstractLeaderEntity.State currentState, Component stop, Component tooltip) {
        Button startButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 62, this.topPos + 11, 40, 20, stop, button -> {
            this.state = currentState != AbstractLeaderEntity.State.PATROLLING ? AbstractLeaderEntity.State.STOPPED : AbstractLeaderEntity.State.PAUSED;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePatrolLeaderSetPatrolState(this.recruit.m_20148_(), this.state.getIndex()));
            this.setButtons();
        }));
        startButton.m_257544_(Tooltip.m_257550_((Component)tooltip));
        startButton.f_93623_ = this.state != AbstractLeaderEntity.State.STOPPED && this.state != AbstractLeaderEntity.State.IDLE;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.textBoxX.m_94120_();
        this.textBoxY.m_94120_();
        this.textBoxZ.m_94120_();
    }

    public boolean m_6375_(double p_100753_, double p_100754_, int p_100755_) {
        if (this.textBoxX.m_93696_()) {
            this.textBoxX.m_6375_(p_100753_, p_100754_, p_100755_);
        }
        if (this.textBoxY.m_93696_()) {
            this.textBoxY.m_6375_(p_100753_, p_100754_, p_100755_);
        }
        if (this.textBoxZ.m_93696_()) {
            this.textBoxZ.m_6375_(p_100753_, p_100754_, p_100755_);
        }
        return super.m_6375_(p_100753_, p_100754_, p_100755_);
    }

    public boolean m_6348_(double p_97812_, double p_97813_, int p_97814_) {
        return super.m_6348_(p_97812_, p_97813_, p_97814_);
    }

    public boolean m_7979_(double p_97752_, double p_97753_, int p_97754_, double p_97755_, double p_97756_) {
        return super.m_7979_(p_97752_, p_97753_, p_97754_, p_97755_, p_97756_);
    }

    public void setPageButtons() {
        Button pageForwardButton = this.createPageForwardButton();
        pageForwardButton.f_93623_ = waypoints.size() > 9;
        Button pageBackButton = this.createPageBackButton();
        pageBackButton.f_93623_ = this.page != 1;
    }

    public void setWaypointButtons() {
        Button addButton = this.createAddWaypointButton(this.leftPos + 171, this.topPos + 11);
        Button removeButton = this.createRemoveWaypointButton(this.leftPos + 148, this.topPos + 11);
        addButton.f_93623_ = this.state == AbstractLeaderEntity.State.STOPPED || this.state == AbstractLeaderEntity.State.IDLE || this.state == AbstractLeaderEntity.State.PAUSED;
        removeButton.f_93623_ = this.state == AbstractLeaderEntity.State.STOPPED || this.state == AbstractLeaderEntity.State.IDLE;
    }

    private void renderItemAt(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        if (itemStack != null) {
            guiGraphics.m_280203_(itemStack, x, y);
        }
    }

    public Button createPageBackButton() {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 15, this.topPos + 230, 12, 12, (Component)Component.m_237113_((String)"<"), button -> {
            if (this.page > 1) {
                --this.page;
            }
            this.setButtons();
        }));
    }

    public Button createPageForwardButton() {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 184, this.topPos + 230, 12, 12, (Component)Component.m_237113_((String)">"), button -> {
            ++this.page;
            this.setButtons();
        }));
    }

    private Button createAddWaypointButton(int x, int y) {
        Button add = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x, y, 20, 20, (Component)Component.m_237113_((String)"+"), button -> {
            int posX = Integer.parseInt(this.textBoxX.m_94155_());
            int posY = Integer.parseInt(this.textBoxY.m_94155_());
            int posZ = Integer.parseInt(this.textBoxZ.m_94155_());
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePatrolLeaderAddWayPoint(this.recruit.m_20148_(), posX, posY, posZ));
            this.setButtons();
        }));
        add.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_ADD));
        return add;
    }

    private Button createRemoveWaypointButton(int x, int y) {
        Button remove = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x, y, 20, 20, (Component)Component.m_237113_((String)"-"), button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePatrolLeaderRemoveWayPoint(this.recruit.m_20148_()));
            this.setButtons();
        }));
        remove.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_REMOVE));
        return remove;
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280056_(this.f_96547_, "Recruit in Oder: " + recruitsSize, 308, 122, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "x: ", 108, 42, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "y: ", 168, 42, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "z: ", 228, 42, 0x404040, false);
        int fontColor = 0x404040;
        int waypointsPerPage = 10;
        int startIndex = (this.page - 1) * waypointsPerPage;
        int endIndex = Math.min(startIndex + waypointsPerPage, waypoints.size());
        if (!waypoints.isEmpty()) {
            for (int i = startIndex; i < endIndex; ++i) {
                BlockPos pos = waypoints.get(i);
                int x = pos.m_123341_();
                int y = pos.m_123342_();
                int z = pos.m_123343_();
                String coordinates = String.format("%d:  (%d,  %d,  %d)", i + 1, x, y, z);
                if (!waypointItems.isEmpty() && waypointItems.get(i) != null) {
                    ItemStack chest = new ItemStack((ItemLike)Blocks.f_50087_.m_5456_());
                    if (i == 0 && this.page == 1) {
                        this.renderItemAt(guiGraphics, chest, 263, 57);
                    }
                    this.renderItemAt(guiGraphics, waypointItems.get(i), 103, 57 + (i - startIndex) * 17);
                } else {
                    BlockPos pos1 = waypoints.get(i);
                    ItemStack itemStack = this.recruit.getItemStackToRender(pos1);
                    this.renderItemAt(guiGraphics, itemStack, 103, 57 + (i - startIndex) * 17);
                }
                guiGraphics.m_280056_(this.f_96547_, coordinates, 123, 60 + (i - startIndex) * 17, fontColor, false);
            }
            if (waypoints.size() > waypointsPerPage) {
                guiGraphics.m_280056_(this.f_96547_, "Page: " + this.page, 178, 230, fontColor, false);
            }
        }
    }

    static {
        waypoints = new ArrayList<BlockPos>();
        waypointItems = new ArrayList<ItemStack>();
        TOOLTIP_START = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_start");
        TOOLTIP_DISABLED_START = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_start_disabled");
        TOOLTIP_STOP = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_stop");
        TOOLTIP_PAUSE = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_pause");
        TOOLTIP_RESUME = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_resume");
        BUTTON_START = Component.m_237115_((String)"gui.recruits.inv.text.start");
        BUTTON_STOP = Component.m_237115_((String)"gui.recruits.inv.text.stop");
        BUTTON_PAUSE = Component.m_237115_((String)"gui.recruits.inv.text.pause");
        BUTTON_RESUME = Component.m_237115_((String)"gui.recruits.inv.text.resume");
        TOOLTIP_CYCLE = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_cycle");
        TOOLTIP_LINE = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_line");
        TOOLTIP_FAST_PATROLLING = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_fast");
        BUTTON_CYCLE = Component.m_237115_((String)"gui.recruits.inv.text.cycle");
        BUTTON_LINE = Component.m_237115_((String)"gui.recruits.inv.text.line");
        BUTTON_FAST = Component.m_237115_((String)"gui.recruits.inv.text.fast");
        BUTTON_NORMAL = Component.m_237115_((String)"gui.recruits.inv.text.normal");
        INFO_MODE_ALL = Component.m_237115_((String)"gui.recruits.inv.text.infomode.all");
        INFO_MODE_HOSTILE = Component.m_237115_((String)"gui.recruits.inv.text.infomode.hostiles");
        INFO_MODE_ENEMY = Component.m_237115_((String)"gui.recruits.inv.text.infomode.enemies");
        INFO_MODE_NONE = Component.m_237115_((String)"gui.recruits.inv.text.infomode.none");
        TOOLTIP_ADD = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_add");
        TOOLTIP_REMOVE = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_remove");
        TOOLTIP_INFO_MODE = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader_info_mode");
        BUTTON_ASSIGN_RECRUITS = Component.m_237115_((String)"gui.recruits.inv.text.assign_recruits");
        BUTTON_REMOVE_ASSIGNED_RECRUITS = Component.m_237115_((String)"gui.recruits.inv.text.remove_assigned_recruits");
        TOOLTIP_ASSIGN_RECRUITS = Component.m_237115_((String)"gui.recruits.inv.tooltip.assign_recruits");
        TOOLTIP_REMOVE_ASSIGNED_RECRUITS = Component.m_237115_((String)"gui.recruits.inv.tooltip.assign_recruits");
        TOOLTIP_CHEST = Component.m_237115_((String)"gui.recruits.inv.tooltip.chest");
    }
}

