/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.inventory.PromoteContainer;
import com.talhanation.recruits.network.MessagePromoteRecruit;
import de.maxhenkel.recruits.corelib.inventory.ScreenBase;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class PromoteScreen
extends ScreenBase<PromoteContainer> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/professions/professions_main_gui.png");
    private final Player player;
    private final AbstractRecruitEntity recruit;
    private EditBox textField;
    private int leftPos;
    private int topPos;
    private static final MutableComponent BUTTON_MESSENGER = Component.m_237115_((String)"gui.recruits.inv.text.messenger");
    private static final MutableComponent TOOLTIP_MESSENGER = Component.m_237115_((String)"gui.recruits.inv.tooltip.messenger");
    private static final MutableComponent BUTTON_PATROL_LEADER = Component.m_237115_((String)"gui.recruits.inv.text.patrol_leader");
    private static final MutableComponent TOOLTIP_PATROL_LEADER = Component.m_237115_((String)"gui.recruits.inv.tooltip.patrol_leader");
    private static final MutableComponent BUTTON_CAPTAIN = Component.m_237115_((String)"gui.recruits.inv.text.captain");
    private static final MutableComponent TOOLTIP_CAPTAIN = Component.m_237115_((String)"gui.recruits.inv.tooltip.captain");
    private static final MutableComponent TOOLTIP_CAPTAIN_DISABLED = Component.m_237115_((String)"gui.recruits.inv.tooltip.captain_disabled");
    private static final MutableComponent BUTTON_SCOUT = Component.m_237115_((String)"gui.recruits.inv.text.scout");
    private static final MutableComponent TOOLTIP_SCOUT = Component.m_237115_((String)"gui.recruits.inv.tooltip.scout");
    private static final MutableComponent BUTTON_GOVERNOR = Component.m_237115_((String)"gui.recruits.inv.text.governor");
    private static final MutableComponent TOOLTIP_GOVERNOR = Component.m_237115_((String)"gui.recruits.inv.tooltip.governor");
    private static final MutableComponent BUTTON_ASSASSIN = Component.m_237115_((String)"gui.recruits.inv.text.assassin");
    private static final MutableComponent TOOLTIP_ASSASSIN = Component.m_237115_((String)"gui.recruits.inv.tooltip.assassin");
    private static final MutableComponent BUTTON_SPY = Component.m_237115_((String)"gui.recruits.inv.text.spy");
    private static final MutableComponent TOOLTIP_SPY = Component.m_237115_((String)"gui.recruits.inv.tooltip.spy");
    private static final MutableComponent BUTTON_SIEGE_ENGINEER = Component.m_237115_((String)"gui.recruits.inv.text.siege_engineer");
    private static final MutableComponent TOOLTIP_SIEGE_ENGINEER = Component.m_237115_((String)"gui.recruits.inv.tooltip.siege_engineer");
    private static final MutableComponent BUTTON_ROGUE = Component.m_237115_((String)"gui.recruits.inv.text.rogue");
    private static final MutableComponent TOOLTIP_ROGUE = Component.m_237115_((String)"gui.recruits.inv.tooltip.rogue");

    public PromoteScreen(PromoteContainer container, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, container, playerInventory, (Component)Component.m_237113_((String)""));
        this.f_97726_ = 197;
        this.f_97727_ = 250;
        this.player = container.getPlayerEntity();
        this.recruit = container.getRecruit();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.f_97726_) / 2;
        this.topPos = (this.f_96544_ - this.f_97727_) / 2;
        this.setWidgets();
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.textField != null) {
            this.textField.m_94120_();
        }
    }

    private void setEditBox() {
        MutableComponent name = Component.m_237113_((String)"Name");
        if (this.recruit.m_7770_() != null) {
            name = this.recruit.m_7770_();
        }
        this.textField = new EditBox(this.f_96547_, this.leftPos + 16, this.topPos + 8, 170, 20, (Component)name);
        this.textField.m_94144_(name.getString());
        this.textField.m_94202_(-1);
        this.textField.m_94205_(-1);
        this.textField.m_94182_(true);
        this.textField.m_93692_(true);
        this.textField.m_94199_(13);
        this.m_142416_((GuiEventListener)this.textField);
        this.m_264313_((GuiEventListener)this.textField);
    }

    public boolean m_6375_(double p_97748_, double p_97749_, int p_97750_) {
        this.textField.m_93692_(true);
        return super.m_6375_(p_97748_, p_97749_, p_97750_);
    }

    private void setWidgets() {
        this.m_169413_();
        this.setEditBox();
        this.createProfessionButtons((Component)BUTTON_MESSENGER, (Component)TOOLTIP_MESSENGER, 0, this.recruit.getXpLevel() >= 3);
        this.createProfessionButtons((Component)BUTTON_SCOUT, (Component)TOOLTIP_SCOUT, 1, this.recruit.getXpLevel() >= 3);
        this.createProfessionButtons((Component)BUTTON_PATROL_LEADER, (Component)TOOLTIP_PATROL_LEADER, 2, this.recruit.getXpLevel() >= 5);
        this.createProfessionButtons((Component)BUTTON_CAPTAIN, (Component)(Main.isSmallShipsCompatible ? TOOLTIP_CAPTAIN : TOOLTIP_CAPTAIN_DISABLED), 3, this.recruit.getXpLevel() >= 5 && Main.isSmallShipsLoaded && Main.isSmallShipsCompatible);
        this.createProfessionButtons((Component)BUTTON_ASSASSIN, (Component)TOOLTIP_ASSASSIN, 4, false);
        this.createProfessionButtons((Component)BUTTON_SIEGE_ENGINEER, (Component)TOOLTIP_SIEGE_ENGINEER, 5, false);
        this.createProfessionButtons((Component)BUTTON_GOVERNOR, (Component)TOOLTIP_GOVERNOR, 6, false);
        this.createProfessionButtons((Component)BUTTON_SPY, (Component)TOOLTIP_SPY, 7, false);
        this.createProfessionButtons((Component)BUTTON_ROGUE, (Component)TOOLTIP_ROGUE, 8, false);
    }

    private Button createProfessionButtons(Component buttonText, Component buttonTooltip, int professionID, boolean active) {
        Button professionButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 59, 31 + this.topPos + 23 * professionID, 80, 20, buttonText, btn -> {
            if (this.recruit != null) {
                String name = this.textField.m_94155_();
                if (name.isEmpty() || name.isBlank()) {
                    name = this.recruit.m_7755_().getString();
                }
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePromoteRecruit(this.recruit.m_20148_(), professionID, name));
                this.m_7379_();
            }
        }));
        professionButton.m_257544_(Tooltip.m_257550_((Component)buttonTooltip));
        professionButton.f_93623_ = active;
        return professionButton;
    }

    public boolean m_7933_(int key, int a, int b) {
        if (key == 256) {
            this.m_7379_();
            return true;
        }
        this.m_7522_((GuiEventListener)this.textField);
        return this.textField.m_7933_(key, a, b) || this.textField.m_94204_() || super.m_7933_(key, a, b);
    }
}

