/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.component;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.talhanation.recruits.client.gui.component.AbstractScrollWidget;
import com.talhanation.recruits.client.gui.component.MultilineTextField;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MultiLineEditBox
extends AbstractScrollWidget {
    private static final int CURSOR_INSERT_WIDTH = 1;
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    private static final int TEXT_COLOR = -2039584;
    private static final int PLACEHOLDER_TEXT_COLOR = -857677600;
    private final Font font;
    private final Component placeholder;
    private final MultilineTextField textField;
    private int frame;

    public MultiLineEditBox(Font p_239008_, int p_239009_, int p_239010_, int p_239011_, int p_239012_, Component p_239013_, Component p_239014_) {
        super(p_239009_, p_239010_, p_239011_, p_239012_, p_239014_);
        this.font = p_239008_;
        this.placeholder = p_239013_;
        this.textField = new MultilineTextField(p_239008_, p_239011_ - this.totalInnerPadding());
        this.textField.setCursorListener(this::scrollToCursor);
    }

    public void setCharacterLimit(int p_239314_) {
        this.textField.setCharacterLimit(p_239314_);
    }

    public void setValueListener(Consumer<String> p_239274_) {
        this.textField.setValueListener(p_239274_);
    }

    public void setValue(String p_240160_) {
        this.textField.setValue(p_240160_);
    }

    public String getValue() {
        return this.textField.value();
    }

    public void tick() {
        ++this.frame;
    }

    public void m_142291_(NarrationElementOutput p_240122_) {
        p_240122_.m_169146_(NarratedElementType.TITLE, (Component)new TranslatableComponent("narration.edit_box", new Object[]{this.getValue()}));
    }

    @Override
    public boolean m_6375_(double p_239101_, double p_239102_, int p_239103_) {
        if (super.m_6375_(p_239101_, p_239102_, p_239103_)) {
            return true;
        }
        if (this.withinContentAreaPoint(p_239101_, p_239102_) && p_239103_ == 0) {
            this.textField.setSelecting(Screen.m_96638_());
            this.seekCursorScreen(p_239101_, p_239102_);
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7979_(double p_238978_, double p_238979_, int p_238980_, double p_238981_, double p_238982_) {
        if (super.m_7979_(p_238978_, p_238979_, p_238980_, p_238981_, p_238982_)) {
            return true;
        }
        if (this.withinContentAreaPoint(p_238978_, p_238979_) && p_238980_ == 0) {
            this.textField.setSelecting(true);
            this.seekCursorScreen(p_238978_, p_238979_);
            this.textField.setSelecting(Screen.m_96638_());
            return true;
        }
        return false;
    }

    public boolean m_7933_(int p_239433_, int p_239434_, int p_239435_) {
        return this.textField.keyPressed(p_239433_);
    }

    public boolean m_5534_(char p_239387_, int p_239388_) {
        if (this.f_93624_ && this.m_93696_() && SharedConstants.m_136188_((char)p_239387_)) {
            this.textField.insertText(Character.toString(p_239387_));
            return true;
        }
        return false;
    }

    @Override
    protected void renderContents(PoseStack p_239001_, int p_239002_, int p_239003_, float p_239004_) {
        String s = this.textField.value();
        if (s.isEmpty() && !this.m_93696_()) {
            this.font.drawWordWrap((FormattedText)this.placeholder, this.f_93620_ + this.innerPadding(), this.f_93621_ + this.innerPadding(), this.f_93618_ - this.totalInnerPadding(), -857677600);
        } else {
            int i = this.textField.cursor();
            boolean flag = this.m_93696_() && this.frame / 6 % 2 == 0;
            boolean flag1 = i < s.length();
            int j = 0;
            int k = 0;
            int l = this.f_93621_ + this.innerPadding();
            for (MultilineTextField.StringView multilinetextfield$stringview : this.textField.iterateLines()) {
                boolean flag2 = this.withinContentAreaTopBottom(l, l + 9);
                if (flag && flag1 && i >= multilinetextfield$stringview.beginIndex() && i <= multilinetextfield$stringview.endIndex()) {
                    if (flag2) {
                        j = this.font.drawShadow(p_239001_, s.substring(multilinetextfield$stringview.beginIndex(), i), (float)(this.f_93620_ + this.innerPadding()), (float)l, -2039584) - 1;
                        GuiComponent.fill((PoseStack)p_239001_, (int)j, (int)(l - 1), (int)(j + 1), (int)(l + 1 + 9), (int)-3092272);
                        this.font.drawShadow(p_239001_, s.substring(i, multilinetextfield$stringview.endIndex()), (float)j, (float)l, -2039584);
                    }
                } else {
                    if (flag2) {
                        j = this.font.drawShadow(p_239001_, s.substring(multilinetextfield$stringview.beginIndex(), multilinetextfield$stringview.endIndex()), (float)(this.f_93620_ + this.innerPadding()), (float)l, -2039584) - 1;
                    }
                    k = l;
                }
                l += 9;
            }
            if (flag && !flag1 && this.withinContentAreaTopBottom(k, k + 9)) {
                this.font.drawShadow(p_239001_, CURSOR_APPEND_CHARACTER, (float)j, (float)k, -3092272);
            }
            if (this.textField.hasSelection()) {
                MultilineTextField.StringView multilinetextfield$stringview2 = this.textField.getSelected();
                int k1 = this.f_93620_ + this.innerPadding();
                l = this.f_93621_ + this.innerPadding();
                for (MultilineTextField.StringView multilinetextfield$stringview1 : this.textField.iterateLines()) {
                    if (multilinetextfield$stringview2.beginIndex() > multilinetextfield$stringview1.endIndex()) {
                        l += 9;
                        continue;
                    }
                    if (multilinetextfield$stringview1.beginIndex() > multilinetextfield$stringview2.endIndex()) break;
                    if (this.withinContentAreaTopBottom(l, l + 9)) {
                        int i1 = this.font.m_92895_(s.substring(multilinetextfield$stringview1.beginIndex(), Math.max(multilinetextfield$stringview2.beginIndex(), multilinetextfield$stringview1.beginIndex())));
                        int j1 = multilinetextfield$stringview2.endIndex() > multilinetextfield$stringview1.endIndex() ? this.f_93618_ - this.innerPadding() : this.font.m_92895_(s.substring(multilinetextfield$stringview1.beginIndex(), multilinetextfield$stringview2.endIndex()));
                        this.renderHighlight(p_239001_, k1 + i1, l, k1 + j1, l + 9);
                    }
                    l += 9;
                }
            }
        }
    }

    @Override
    protected void renderDecorations(PoseStack p_239517_) {
        super.renderDecorations(p_239517_);
        if (this.textField.hasCharacterLimit()) {
            int i = this.textField.characterLimit();
            TranslatableComponent component = new TranslatableComponent("gui.multiLineEditBox.character_limit", new Object[]{this.textField.value().length(), i});
            MultiLineEditBox.drawString((PoseStack)p_239517_, (Font)this.font, (Component)component, (int)(this.f_93620_ + this.f_93618_ - this.font.m_92852_((FormattedText)component)), (int)(this.f_93621_ + this.f_93619_ + 4), (int)0xA0A0A0);
        }
    }

    @Override
    public int getInnerHeight() {
        return 9 * this.textField.getLineCount();
    }

    @Override
    protected boolean scrollbarVisible() {
        return (double)this.textField.getLineCount() > this.getDisplayableLineCount();
    }

    @Override
    protected double scrollRate() {
        return 4.5;
    }

    private void renderHighlight(PoseStack p_239487_, int p_239488_, int p_239489_, int p_239490_, int p_239491_) {
        Matrix4f matrix4f = p_239487_.m_85850_().pose();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.vertex(matrix4f, (float)p_239488_, (float)p_239491_, 0.0f).m_5752_();
        bufferbuilder.vertex(matrix4f, (float)p_239490_, (float)p_239491_, 0.0f).m_5752_();
        bufferbuilder.vertex(matrix4f, (float)p_239490_, (float)p_239489_, 0.0f).m_5752_();
        bufferbuilder.vertex(matrix4f, (float)p_239488_, (float)p_239489_, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    private void scrollToCursor() {
        double d0 = this.scrollAmount();
        MultilineTextField.StringView multilinetextfield$stringview = this.textField.getLineView((int)(d0 / 9.0));
        if (this.textField.cursor() <= multilinetextfield$stringview.beginIndex()) {
            d0 = this.textField.getLineAtCursor() * 9;
        } else {
            MultilineTextField.StringView multilinetextfield$stringview1 = this.textField.getLineView((int)((d0 + (double)this.f_93619_) / 9.0) - 1);
            if (this.textField.cursor() > multilinetextfield$stringview1.endIndex()) {
                d0 = this.textField.getLineAtCursor() * 9 - this.f_93619_ + 9 + this.totalInnerPadding();
            }
        }
        this.setScrollAmount(d0);
    }

    private double getDisplayableLineCount() {
        return (double)(this.f_93619_ - this.totalInnerPadding()) / 9.0;
    }

    private void seekCursorScreen(double p_239276_, double p_239277_) {
        double d0 = p_239276_ - (double)this.f_93620_ - (double)this.innerPadding();
        double d1 = p_239277_ - (double)this.f_93621_ - (double)this.innerPadding() + this.scrollAmount();
        this.textField.seekCursorToPoint(d0, d1);
    }
}

