/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.team;

import com.google.common.collect.Lists;
import com.talhanation.recruits.client.gui.team.RecruitsTeamEntry;
import com.talhanation.recruits.client.gui.team.RecruitsTeamListScreen;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.world.RecruitsTeam;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RecruitsTeamList
extends ListScreenListBase<RecruitsTeamEntry> {
    protected RecruitsTeamListScreen screen;
    protected final List<RecruitsTeamEntry> entries;
    protected String filter;
    public static List<RecruitsTeam> teams;
    boolean hasUpdated;

    public RecruitsTeamList(int width, int height, int x, int y, int size, RecruitsTeamListScreen screen) {
        super(width, height, x, y, size);
        this.screen = screen;
        this.entries = Lists.newArrayList();
        this.filter = "";
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93471_(true);
    }

    public void tick() {
        if (!this.hasUpdated && teams != null) {
            this.updateEntryList();
            this.hasUpdated = true;
        }
    }

    public void updateEntryList() {
        this.entries.clear();
        for (RecruitsTeam team : teams) {
            this.entries.add(new RecruitsTeamEntry(this.screen, team));
        }
        this.updateFilter();
    }

    public void updateFilter() {
        this.m_93516_();
        ArrayList<RecruitsTeamEntry> filteredEntries = new ArrayList<RecruitsTeamEntry>(this.entries);
        if (!this.filter.isEmpty()) {
            filteredEntries.removeIf(teamEntry -> teamEntry.getTeamInfo() == null || !teamEntry.getTeamInfo().getTeamDisplayName().toLowerCase(Locale.ROOT).contains(this.filter));
        }
        filteredEntries.sort((e1, e2) -> {
            if (!((Object)e1).getClass().equals(((Object)e2).getClass())) {
                if (e1 instanceof RecruitsTeamEntry) {
                    return 1;
                }
                return -1;
            }
            return this.volumeEntryToString((RecruitsTeamEntry)((Object)e1)).compareToIgnoreCase(this.volumeEntryToString((RecruitsTeamEntry)((Object)e2)));
        });
        this.m_5988_(filteredEntries);
    }

    private String volumeEntryToString(RecruitsTeamEntry entry) {
        return entry.getTeamInfo() == null ? "" : entry.getTeamInfo().getStringID();
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateFilter();
    }

    public boolean isEmpty() {
        return this.m_6702_().isEmpty();
    }
}

