/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.recruits.client.events.ClientEvent;
import com.talhanation.recruits.client.models.RecruitVillagerModel;
import com.talhanation.recruits.client.render.layer.RecruitVillagerBiomeLayer;
import com.talhanation.recruits.client.render.layer.RecruitVillagerCompanionLayer;
import com.talhanation.recruits.client.render.layer.RecruitVillagerTeamColorLayer;
import com.talhanation.recruits.client.render.layer.VillagerRecruitCustomHeadLayer;
import com.talhanation.recruits.compat.IWeapon;
import com.talhanation.recruits.entities.AbstractInventoryEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;

public class RecruitVillagerRenderer
extends MobRenderer<AbstractRecruitEntity, HumanoidModel<AbstractRecruitEntity>> {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[]{new ResourceLocation("recruits", "textures/entity/villager/villager_1.png")};

    public ResourceLocation getTextureLocation(AbstractRecruitEntity recruit) {
        return TEXTURE[0];
    }

    public RecruitVillagerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new RecruitVillagerModel(context.m_174023_(ClientEvent.RECRUIT)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ClientEvent.RECRUIT_INNER_ARMOR)), new HumanoidModel(context.m_174023_(ClientEvent.RECRUIT_OUTER_ARMOR)), context.m_266367_()));
        this.m_115326_(new RecruitVillagerTeamColorLayer((LivingEntityRenderer<AbstractRecruitEntity, HumanoidModel<AbstractRecruitEntity>>)this));
        this.m_115326_(new RecruitVillagerBiomeLayer((LivingEntityRenderer<AbstractRecruitEntity, HumanoidModel<AbstractRecruitEntity>>)this));
        this.m_115326_(new RecruitVillagerCompanionLayer((LivingEntityRenderer<AbstractRecruitEntity, HumanoidModel<AbstractRecruitEntity>>)this));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_(new VillagerRecruitCustomHeadLayer(this, context.m_174027_(), context.m_234598_()));
    }

    public void render(AbstractRecruitEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.setModelVisibilities(entityIn);
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void setModelVisibilities(AbstractInventoryEntity recruitEntity) {
        HumanoidModel model = (HumanoidModel)this.m_7200_();
        model.m_8009_(true);
        model.f_102817_ = recruitEntity.m_6047_();
        model.m_8009_(true);
        model.f_102809_.f_104207_ = true;
        HumanoidModel.ArmPose humanoidmodel$armpose = RecruitVillagerRenderer.getArmPose(recruitEntity, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose humanoidmodel$armpose1 = RecruitVillagerRenderer.getArmPose(recruitEntity, InteractionHand.OFF_HAND);
        if (humanoidmodel$armpose.m_102897_()) {
            HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = recruitEntity.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (recruitEntity.m_5737_() == HumanoidArm.RIGHT) {
            model.f_102816_ = humanoidmodel$armpose;
            model.f_102815_ = humanoidmodel$armpose1;
        } else {
            model.f_102816_ = humanoidmodel$armpose1;
            model.f_102815_ = humanoidmodel$armpose;
        }
    }

    protected void scale(AbstractRecruitEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    private static HumanoidModel.ArmPose getArmPose(AbstractInventoryEntity recruit, InteractionHand hand) {
        CrossBowmanEntity crossBowman;
        boolean isMusket;
        ItemStack itemstack = recruit.m_21120_(hand);
        boolean bl = isMusket = IWeapon.isMusketModWeapon(itemstack) && recruit instanceof CrossBowmanEntity && (crossBowman = (CrossBowmanEntity)recruit).m_5912_();
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (recruit.m_7655_() == hand && recruit.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && hand == recruit.m_7655_() || isMusket) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!recruit.f_20911_ && itemstack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemstack) || isMusket) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }
}

