/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai.controller;

import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.entities.ai.controller.PatrolLeaderAttackController;
import com.talhanation.recruits.util.WaterObstacleScanner;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

public class CaptainPrepareShipAttackController
extends PatrolLeaderAttackController {
    private final CaptainEntity captain;
    private int range;
    public boolean isTargetInRange;

    public CaptainPrepareShipAttackController(CaptainEntity recruit) {
        super(recruit);
        this.captain = recruit;
    }

    @Override
    public void start() {
        if (!this.captain.m_20193_().m_5776_() && this.captain.enemyArmy != null && this.captain.army != null && this.captain.smallShipsController.ship != null && !this.captain.retreating) {
            Container container;
            boolean shipContainer;
            this.captain.army.updateArmy();
            this.captain.enemyArmy.updateArmy();
            this.captain.enemyArmy.getAllUnits().removeIf(Entity::m_5842_);
            boolean captainBalls = this.captain.getCannonBallCount((Container)this.captain.getInventory()) > 0;
            Entity entity = this.captain.m_20202_();
            boolean bl = shipContainer = entity instanceof Container && this.captain.getCannonBallCount(container = (Container)entity) < 128;
            if (captainBalls && shipContainer) {
                this.captain.refillCannonBalls();
            }
            if (this.captain.canRepair() && this.captain.smallShipsController.ship.getDamage() > 10.0f) {
                for (int i = 0; i < this.captain.m_217043_().m_188503_(3); ++i) {
                    this.captain.smallShipsController.ship.repairShip(this.captain);
                }
            }
            if (this.captain.enemyArmy.getPosition().m_82557_(this.captain.m_20182_()) < 500.0) {
                this.setRecruitsTargets();
            }
            if (!this.captain.smallShipsController.checkForNextTarget()) {
                return;
            }
            if (!this.hasEnoughSpaceInWater()) {
                this.captain.smallShipsController.ship.setSailState(0);
                return;
            }
            if (this.captain.smallShipsController.shouldGetInRange()) {
                this.captain.setSailPos(this.captain.smallShipsController.target.m_20097_());
            }
        }
    }

    private boolean hasEnoughSpaceInWater() {
        Boat ship = this.captain.smallShipsController.ship.getBoat();
        Vec3 forward = ship.m_20156_();
        for (int i = 0; i < 4; ++i) {
            if (!WaterObstacleScanner.hasObstacle(forward.m_82524_((float)(90 * i)), (Entity)ship, 30.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTargetInRange() {
        return this.isTargetInRange;
    }

    @Override
    public void tick() {
        super.tick();
    }
}

