/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.CommandEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageRangedFire
implements Message<MessageRangedFire> {
    private UUID player;
    private int group;
    private boolean should;

    public MessageRangedFire() {
    }

    public MessageRangedFire(UUID player, int group, boolean shields) {
        this.player = player;
        this.group = group;
        this.should = shields;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        List list = Objects.requireNonNull(context.getSender()).m_20193_().m_45976_(AbstractRecruitEntity.class, context.getSender().m_20191_().m_82400_(100.0));
        for (AbstractRecruitEntity recruits : list) {
            CommandEvents.onRangedFireCommand(serverPlayer, this.player, recruits, this.group, this.should);
        }
    }

    @Override
    public MessageRangedFire fromBytes(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        this.group = buf.readInt();
        this.should = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.writeInt(this.group);
        buf.writeBoolean(this.should);
    }
}

