/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class RecruitsDiplomacySaveData
extends SavedData {
    public static final Map<String, Map<String, RecruitsDiplomacyManager.DiplomacyStatus>> diplomacyMap = new HashMap<String, Map<String, RecruitsDiplomacyManager.DiplomacyStatus>>();
    private static final String DATA_NAME = "diplomacy_data";

    public RecruitsDiplomacySaveData() {
        diplomacyMap.clear();
        this.m_77762_();
    }

    public static RecruitsDiplomacySaveData get(ServerLevel level) {
        return (RecruitsDiplomacySaveData)level.m_8895_().m_164861_(RecruitsDiplomacySaveData::load, RecruitsDiplomacySaveData::new, DATA_NAME);
    }

    public static RecruitsDiplomacySaveData load(CompoundTag nbt) {
        RecruitsDiplomacySaveData data = new RecruitsDiplomacySaveData();
        CompoundTag teamsTag = nbt.m_128469_("teams");
        for (String teamKey : teamsTag.m_128431_()) {
            CompoundTag relationsTag = teamsTag.m_128469_(teamKey);
            HashMap<String, RecruitsDiplomacyManager.DiplomacyStatus> relations = new HashMap<String, RecruitsDiplomacyManager.DiplomacyStatus>();
            for (String relationKey : relationsTag.m_128431_()) {
                byte relationStatusByte = relationsTag.m_128445_(relationKey);
                RecruitsDiplomacyManager.DiplomacyStatus relationStatus = RecruitsDiplomacyManager.DiplomacyStatus.fromByte(relationStatusByte);
                relations.put(relationKey, relationStatus);
            }
            diplomacyMap.put(teamKey, relations);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag teamsTag = new CompoundTag();
        for (Map.Entry<String, Map<String, RecruitsDiplomacyManager.DiplomacyStatus>> teamEntry : diplomacyMap.entrySet()) {
            CompoundTag relationsTag = new CompoundTag();
            for (Map.Entry<String, RecruitsDiplomacyManager.DiplomacyStatus> relationEntry : teamEntry.getValue().entrySet()) {
                relationsTag.m_128344_(relationEntry.getKey(), relationEntry.getValue().getByteValue());
            }
            teamsTag.m_128365_(teamEntry.getKey(), (Tag)relationsTag);
        }
        nbt.m_128365_("teams", (Tag)teamsTag);
        return nbt;
    }

    public void setRelation(String team, String otherTeam, byte relationByte) {
        RecruitsDiplomacyManager.DiplomacyStatus relation = RecruitsDiplomacyManager.DiplomacyStatus.fromByte(relationByte);
        diplomacyMap.computeIfAbsent(team, k -> new HashMap()).put(otherTeam, relation);
        this.m_77762_();
    }

    public Map<String, Map<String, RecruitsDiplomacyManager.DiplomacyStatus>> getDiplomacyMap() {
        return diplomacyMap;
    }
}

