/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.item.sandwich;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.item.sandwich.SandwichItemHandler;
import someassemblyrequired.registry.ModTags;

public class SandwichItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ItemStack BARRIER = new ItemStack((ItemLike)Items.f_42127_);
    private static final Random random = new Random();

    public SandwichItemRenderer() {
        super(null, null);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int overlay) {
        SandwichItemHandler.get((ICapabilityProvider)stack).ifPresent(sandwich -> {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.53125, 0.5);
            int height = sandwich.getTotalHeight();
            if (itemDisplayContext == ItemDisplayContext.GUI && height > 16) {
                float scale = 24.0f / ((float)height + 8.0f);
                poseStack.m_85841_(scale, scale, scale);
            }
            if (itemDisplayContext.m_269069_() || itemDisplayContext == ItemDisplayContext.GUI) {
                poseStack.m_85837_(0.0, (double)(-height) / 32.0, 0.0);
            }
            if (sandwich.getItemCount() == 0) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                Minecraft.m_91087_().m_91291_().m_269128_(BARRIER, ItemDisplayContext.FIXED, packedLight, overlay, poseStack, buffer, null, 0);
            } else {
                SandwichItemRenderer.renderSandwich(sandwich, poseStack, buffer, packedLight, overlay, 0L);
            }
            poseStack.m_85849_();
        });
    }

    public static void renderSandwich(SandwichItemHandler sandwich, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int overlay, long seed) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        random.setSeed(seed);
        for (int slot = 0; slot < sandwich.getItemCount(); ++slot) {
            poseStack.m_85836_();
            ItemStack stack = sandwich.getStackInSlot(slot);
            if (!stack.m_204117_(ModTags.SANDWICH_BREAD)) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 40.0f - 20.0f));
            }
            ItemStack displayStack = Ingredients.getDisplayItem(stack);
            boolean isGui3d = Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, (int)seed + slot).m_7539_();
            if (!Ingredients.shouldRenderAsItem(stack) || isGui3d) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_85837_(0.0, 0.46875, 0.0);
                if (isGui3d) {
                    poseStack.m_85837_(0.0, -0.25, 0.0);
                }
            }
            poseStack.m_85841_(1.0f, 1.0f, 0.99f);
            Minecraft.m_91087_().m_91291_().m_269128_(displayStack, ItemDisplayContext.FIXED, packedLight, overlay, poseStack, buffer, null, (int)seed + slot);
            poseStack.m_85849_();
            int height = Ingredients.getHeight(stack);
            poseStack.m_85837_(0.0, 0.0, (double)(-height) / 16.0);
        }
        poseStack.m_85849_();
    }
}

