/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IFilterSlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.SetGhostSlotMessage;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeTab;

public class JeiStorageGhostIngredientHandler<S extends StorageScreenBase<?>>
implements IGhostIngredientHandler<S> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(S gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList targets = new ArrayList();
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            StorageContainerMenuBase container = (StorageContainerMenuBase)gui.m_6262_();
            ingredient.getItemStack().ifPresent(ghostStack -> {
                FluidStack fluidStack = ghostStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).filter(fluidHandler -> fluidHandler.getTanks() > 0).map(fluidHandler -> fluidHandler.getFluidInTank(0)).orElse(FluidStack.EMPTY);
                if (!fluidStack.isEmpty()) {
                    gui.getUpgradeSettingsControl().getOpenTab().filter(tab -> tab instanceof PumpUpgradeTab.Advanced).map(PumpUpgradeTab.Advanced.class::cast).ifPresent(pumpUpgradeTab -> this.addFluidTargets((PumpUpgradeTab.Advanced)pumpUpgradeTab, fluidStack, targets));
                    return;
                }
                container.getOpenContainer().ifPresent(c -> c.getSlots().forEach(s -> {
                    if (s instanceof IFilterSlot && s.m_5857_(ghostStack)) {
                        targets.add(new IGhostIngredientHandler.Target<I>((StorageScreenBase)gui, (Slot)s, (ItemStack)ghostStack){
                            final /* synthetic */ StorageScreenBase val$gui;
                            final /* synthetic */ Slot val$s;
                            final /* synthetic */ ItemStack val$ghostStack;
                            {
                                this.val$gui = storageScreenBase;
                                this.val$s = slot;
                                this.val$ghostStack = itemStack;
                            }

                            public Rect2i getArea() {
                                return new Rect2i(this.val$gui.getGuiLeft() + this.val$s.f_40220_, this.val$gui.getGuiTop() + this.val$s.f_40221_, 17, 17);
                            }

                            public void accept(I i) {
                                PacketHandler.INSTANCE.sendToServer(new SetGhostSlotMessage(this.val$ghostStack, this.val$s.f_40219_));
                            }
                        });
                    }
                }));
            });
        } else if (ingredient.getType() == ForgeTypes.FLUID_STACK) {
            ((StorageScreenBase)gui).getUpgradeSettingsControl().getOpenTab().filter(tab -> tab instanceof PumpUpgradeTab.Advanced).map(PumpUpgradeTab.Advanced.class::cast).ifPresent(pumpUpgradeTab -> ForgeTypes.FLUID_STACK.castIngredient(ingredient.getIngredient()).ifPresent(ghostFluid -> this.addFluidTargets((PumpUpgradeTab.Advanced)pumpUpgradeTab, (FluidStack)ghostFluid, targets)));
        }
        return targets;
    }

    private <I> void addFluidTargets(final PumpUpgradeTab.Advanced pumpUpgradeTab, final FluidStack ghostFluid, List<IGhostIngredientHandler.Target<I>> targets) {
        List<Position> slotTopLeftPositions = pumpUpgradeTab.getFluidFilterControl().getSlotTopLeftPositions();
        final AtomicInteger slot = new AtomicInteger();
        slot.set(0);
        while (slot.get() < slotTopLeftPositions.size()) {
            final Position position = slotTopLeftPositions.get(slot.get());
            targets.add(new IGhostIngredientHandler.Target<I>(){
                private final int slotIndex;
                {
                    this.slotIndex = slot.get();
                }

                public Rect2i getArea() {
                    return new Rect2i(position.x(), position.y(), 17, 17);
                }

                public void accept(I i) {
                    pumpUpgradeTab.getFluidFilterControl().setFluid(this.slotIndex, ghostFluid);
                }
            });
            slot.incrementAndGet();
        }
    }

    public void onComplete() {
    }
}

