/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromChestRecipe;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;

public class ShulkerBoxFromChestRecipesMaker {
    private ShulkerBoxFromChestRecipesMaker() {
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<CraftingRecipe> getShapedRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return ShulkerBoxFromChestRecipesMaker.getShapedRecipes(getSubtypeInterpreter, r -> r);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapedRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, Function<CraftingRecipe, R> transformRecipe) {
        return ClientRecipeHelper.transformAllRecipesOfTypeIntoMultiple((RecipeType)RecipeType.f_44107_, ShulkerBoxFromChestRecipe.class, originalRecipe -> {
            ArrayList recipes = new ArrayList();
            ShulkerBoxFromChestRecipesMaker.getChestItems(originalRecipe).forEach(chestItem -> {
                TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                    public ItemStack m_7648_(Player player, int index) {
                        return ItemStack.f_41583_;
                    }

                    public boolean m_6875_(Player playerIn) {
                        return false;
                    }
                }, 3, 3);
                NonNullList ingredients = originalRecipe.m_7527_();
                NonNullList ingredientsCopy = NonNullList.m_182647_((int)ingredients.size());
                int i = 0;
                for (Ingredient ingredient : ingredients) {
                    ItemStack[] ingredientItems = ingredient.m_43908_();
                    boolean isChestIngredient = false;
                    for (ItemStack ingredientItem : ingredientItems) {
                        if (!(ingredientItem.m_41720_() instanceof ChestBlockItem)) continue;
                        isChestIngredient = true;
                        break;
                    }
                    if (isChestIngredient) {
                        ingredientsCopy.add(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{chestItem}));
                        craftinginventory.m_6836_(i, chestItem.m_41777_());
                    } else {
                        ingredientsCopy.add(i, (Object)ingredient);
                        craftinginventory.m_6836_(i, ingredientItems[0]);
                    }
                    ++i;
                }
                ItemStack result = ClientRecipeHelper.assemble((Recipe)originalRecipe, (Container)craftinginventory);
                ResourceLocation newId = new ResourceLocation("sophisticatedstorage", "shulker_from_" + ((Optional)getSubtypeInterpreter.apply((ItemStack)chestItem)).map(interpreter -> interpreter.getRegistrySanitizedItemString(chestItem)).orElse(""));
                recipes.add(transformRecipe.apply((CraftingRecipe)new ShapedRecipe(newId, "", CraftingBookCategory.MISC, originalRecipe.getRecipeWidth(), originalRecipe.getRecipeHeight(), ingredientsCopy, result)));
            });
            return recipes;
        });
    }

    private static List<ItemStack> getChestItems(ShapedRecipe recipe) {
        NonNullList chestItems = NonNullList.m_122779_();
        for (Ingredient ingredient : recipe.m_7527_()) {
            ItemStack[] ingredientItems;
            for (ItemStack ingredientItem : ingredientItems = ingredient.m_43908_()) {
                Item item = ingredientItem.m_41720_();
                if (!(item instanceof ChestBlockItem)) continue;
                ChestBlockItem chestBlockItem = (ChestBlockItem)item;
                chestBlockItem.addCreativeTabItems(arg_0 -> chestItems.add(arg_0));
            }
        }
        return chestItems;
    }
}

