/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.CustomArmorLayer;
import com.Harbinger.Spore.Client.Models.InfectedPlayerModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedPlayer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InfectedPlayerRenderer
extends BaseInfectedRenderer<InfectedPlayer, HumanoidModel<InfectedPlayer>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/inf_player.png");
    private static final ResourceLocation TECHNO = new ResourceLocation("spore", "textures/entity/techno_skin.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/inf_player.png");
    private static final ResourceLocation DEFAULT_SKIN = new ResourceLocation("minecraft:textures/entity/player/wide/steve.png");
    private final HumanoidModel<InfectedPlayer> mainModel = (HumanoidModel)this.m_7200_();
    private final HumanoidModel<InfectedPlayer> madnessModel;

    public InfectedPlayerRenderer(EntityRendererProvider.Context context) {
        super(context, new InfectedPlayerModel(context.m_174023_(InfectedPlayerModel.LAYER_LOCATION)), 0.5f);
        this.madnessModel = new HumanoidModel(context.m_174023_(ModelLayers.f_171162_));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_(new CustomArmorLayer(this));
    }

    public ResourceLocation getTextureLocation(InfectedPlayer infectedPlayer) {
        if (this.isTheViewerMad(infectedPlayer)) {
            return DEFAULT_SKIN;
        }
        if (Objects.equals(infectedPlayer.m_7770_(), Component.m_237113_((String)"Technoblade"))) {
            return TECHNO;
        }
        return TEXTURE;
    }

    public boolean isTheViewerMad(InfectedPlayer infectedPlayer) {
        Entity entity = Minecraft.m_91087_().f_91075_;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MobEffectInstance instance = player.m_21124_((MobEffect)Seffects.MADNESS.get());
            return instance != null && instance.m_19564_() > 0 && player.m_20270_((Entity)infectedPlayer) > 30.0f;
        }
        return false;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    public void render(InfectedPlayer type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.f_115290_ = this.isTheViewerMad(type) ? this.madnessModel : this.mainModel;
        super.m_7392_(type, value1, value2, stack, bufferSource, light);
    }
}

