/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.SBlockEntities.AnimatedEntity;
import com.Harbinger.Spore.SBlockEntities.LivingStructureBlocks;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OvergrownSpawnerEntity
extends BlockEntity
implements AnimatedEntity {
    public int ticks;
    private int time;
    public final int maxTime = 1200;

    public OvergrownSpawnerEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SblockEntities.OVERGROWN_SPAWNER.get(), pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("time", this.getTime());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setTime(tag.m_128451_("time"));
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void addTime() {
        this.setTime(this.getTime() + 1);
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public static <E extends OvergrownSpawnerEntity> void serverTick(Level level, BlockPos pos, BlockState state, E e) {
        OvergrownSpawnerEntity.tick(level, pos, state, e);
    }

    public static <E extends OvergrownSpawnerEntity> void clientTick(Level level, BlockPos pos, BlockState state, E e) {
        OvergrownSpawnerEntity.tick(level, pos, state, e);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, OvergrownSpawnerEntity entity) {
        entity.ticks = entity.ticks <= 360 ? ++entity.ticks : 0;
        if (entity.getTime() <= entity.maxTime) {
            entity.addTime();
        } else {
            entity.setTime(0);
            entity.feed(level, pos);
        }
    }

    private void feed(Level level1, BlockPos blockPos) {
        int range = 2 * (Integer)SConfig.DATAGEN.spawner_range.get();
        AABB aabb = AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)range, (double)range, (double)range);
        List entities = level1.m_45976_(LivingEntity.class, aabb);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockEntity blockEntity = level1.m_7702_(blockpos);
            if (!(blockEntity instanceof LivingStructureBlocks)) continue;
            LivingStructureBlocks structureBlocks = (LivingStructureBlocks)blockEntity;
            structureBlocks.addKills();
        }
        for (Entity entity : entities) {
            if (entity instanceof Infected) {
                Infected infected = (Infected)entity;
                infected.setKills(infected.getKills() + 1);
                infected.setEvolution(infected.getEvoPoints() + 1);
            }
            if (!(entity instanceof Calamity)) continue;
            Calamity calamity = (Calamity)entity;
            calamity.setKills(calamity.getKills() + 1);
        }
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }
}

