/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BasicInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Inebriator;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.HazmatVariant;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import java.util.Collection;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InfectedHazmat
extends Infected
implements VariantKeeper,
EvolvingInfected {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(InfectedHazmat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BLOW_TIME = SynchedEntityData.m_135353_(InfectedHazmat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public InfectedHazmat(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.SCIENTIST_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.inf_hazmat_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.inf_hazmat_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.inf_hazmat_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22282_, 0.3);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(BLOW_TIME, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @javax.annotation.Nullable SpawnGroupData p_146749_, @javax.annotation.Nullable CompoundTag p_146750_) {
        HazmatVariant variant = (HazmatVariant)((Object)Util.m_214670_((Object[])HazmatVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public void setBlowTime(int i) {
        this.f_19804_.m_135381_(BLOW_TIME, (Object)i);
    }

    public int getBlowTime() {
        return (Integer)this.f_19804_.m_135370_(BLOW_TIME);
    }

    private void tickExplosion() {
        this.setBlowTime(this.getBlowTime() + 1);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getVariant() == HazmatVariant.TANK && Math.random() < 0.5) {
            this.tickExplosion();
        }
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getVariant() == HazmatVariant.TANK) {
            if (this.getBlowTime() == 1) {
                this.m_216990_(SoundEvents.f_12512_);
            }
            if (this.getBlowTime() > 0) {
                this.tickExplosion();
            }
            if (this.getBlowTime() >= 60) {
                this.explodeTank();
            }
        }
        if (this.getVariant() == HazmatVariant.COAT) {
            this.tickEvolution(this, null, ScamperVariants.DEFAULT);
        }
    }

    @Override
    public void Evolve(Infected livingEntity, List<? extends String> value, ScamperVariants variants) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (this.getVariant() == HazmatVariant.COAT) {
                Inebriator inebriator = new Inebriator((EntityType<? extends Monster>)((EntityType)Sentities.INEBRIATER.get()), (Level)world);
                Collection collection = livingEntity.m_21220_();
                for (MobEffectInstance mobeffectinstance : collection) {
                    inebriator.m_7292_(new MobEffectInstance(mobeffectinstance));
                }
                inebriator.setKills(livingEntity.getKills());
                inebriator.setEvoPoints(livingEntity.getEvoPoints());
                inebriator.setSearchPos(livingEntity.getSearchPos());
                inebriator.setLinked(livingEntity.getLinked());
                inebriator.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_() + 0.5, livingEntity.m_20189_());
                inebriator.m_6593_(livingEntity.m_7770_());
                inebriator.m_6518_((ServerLevelAccessor)world, livingEntity.m_9236_().m_6436_(new BlockPos((int)livingEntity.m_20185_(), (int)livingEntity.m_20186_(), (int)livingEntity.m_20189_())), MobSpawnType.NATURAL, null, null);
                world.m_7967_((Entity)inebriator);
                livingEntity.m_146870_();
            }
            double x0 = livingEntity.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            double y0 = livingEntity.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.25) * 0.15 * 5.0;
            double z0 = livingEntity.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
        }
    }

    private void explodeTank() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)((Integer)SConfig.SERVER.gastank_explosion.get()).intValue(), Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    public HazmatVariant getVariant() {
        return HazmatVariant.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > HazmatVariant.values().length || i < 0) {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return HazmatVariant.values().length;
    }

    private void setVariant(HazmatVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (effectInstance.m_19544_().m_19486_() || this.getTypeVariant() == 2) {
            return super.m_147207_(effectInstance, entity);
        }
        return false;
    }
}

