/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.TransportInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.Carrier;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Hyper.Ogre;
import com.Harbinger.Spore.Sentities.Projectile.ThrownBlockProjectile;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Brute
extends EvolvedInfected
implements Carrier,
RangedAttackMob,
EvolvingInfected {
    private static final EntityDataAccessor<Optional<BlockState>> DATA_CARRY_STATE = SynchedEntityData.m_135353_(Brute.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);

    public Brute(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_brute_loot.get();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, new TransportInfected<Mob>((Mob)this, Mob.class, 1.1, entity -> ((List)SConfig.SERVER.ranged.get()).contains(entity.m_20078_())));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal(this, 1.3, 80, 48.0f){

            public boolean m_8036_() {
                return super.m_8036_() && Brute.this.getCarriedBlock() != null && Brute.this.m_5448_() != null && Brute.this.m_20280_((Entity)Brute.this.m_5448_()) > 200.0;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.3, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    public void setCarriedBlock(@Nullable BlockState state) {
        this.f_19804_.m_135381_(DATA_CARRY_STATE, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState getCarriedBlock() {
        return ((Optional)this.f_19804_.m_135370_(DATA_CARRY_STATE)).orElse(null);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        BlockState blockstate = this.getCarriedBlock();
        if (blockstate != null) {
            tag.m_128365_("carriedBlockState", (Tag)NbtUtils.m_129202_((BlockState)blockstate));
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        BlockState blockstate = null;
        if (tag.m_128425_("carriedBlockState", 10) && (blockstate = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("carriedBlockState"))).m_60795_()) {
            blockstate = null;
        }
        this.setCarriedBlock(blockstate);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CARRY_STATE, Optional.empty());
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_CARRY_STATE.equals(dataAccessor)) {
            if (this.getCarriedBlock() != null) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)this.getCarriedBlock().m_60734_().m_5456_()));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
        super.m_7350_(dataAccessor);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.brute_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.brute_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.brute_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        if (this.m_6084_() && this.m_5448_() != null && this.m_217043_().m_216339_(0, 6) == 3 && this.checkForInfected((Entity)this) && this.switchy()) {
            this.performRangedAttack((LivingEntity)this);
        }
        super.m_8119_();
        if (this.getCarriedBlock() == null && this.f_19796_.m_188503_(250) == 0) {
            this.setCarriedBlock(this.blocky());
        }
        this.tickHyperEvolution(this);
    }

    private boolean switchy() {
        if (this.m_5448_() != null) {
            double ze = this.m_20280_((Entity)this.m_5448_());
            return ze > 60.0 && ze < 400.0;
        }
        return false;
    }

    boolean checkForInfected(Entity entity) {
        AABB boundingBox = entity.m_20191_().m_82400_(1.2);
        List entities = entity.m_9236_().m_45933_(entity, boundingBox);
        for (Entity en : entities) {
            if (!((List)SConfig.SERVER.can_be_carried.get()).contains(en.m_20078_())) continue;
            return true;
        }
        return false;
    }

    public void performRangedAttack(LivingEntity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = entity.m_20185_() + vec3.f_82479_ - this.m_5448_().m_20185_();
        double d1 = entity.m_20188_() - (double)1.1f - this.m_20186_();
        double d2 = entity.m_20189_() + vec3.f_82481_ - this.m_5448_().m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        AABB boundingBox = entity.m_20191_().m_82400_(1.2);
        List entities = entity.m_9236_().m_45933_((Entity)entity, boundingBox);
        for (Entity en : entities) {
            if (!(en instanceof Mob) || !((List)SConfig.SERVER.can_be_carried.get()).contains(en.m_20078_())) continue;
            en.m_20334_(d0 * -0.2, (d1 + d3) * 0.02, d2 * -0.2);
            ((Mob)en).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0));
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.INF_PILLAGER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_VILLAGER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public void m_6504_(LivingEntity livingEntity, float p_33318_) {
        if (!this.m_9236_().f_46443_ && this.getCarriedBlock() != null) {
            ThrownBlockProjectile thrownBlockProjectile = new ThrownBlockProjectile(this.m_9236_(), (LivingEntity)this, Float.valueOf(10.0f), this.getCarriedBlock(), this.TARGET_SELECTOR);
            double dx = livingEntity.m_20185_() - this.m_20185_();
            double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_() - 1.0;
            double dz = livingEntity.m_20189_() - this.m_20189_();
            thrownBlockProjectile.m_6027_(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
            thrownBlockProjectile.m_6686_(dx, dy - thrownBlockProjectile.m_20186_() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
            this.m_9236_().m_7967_((Entity)thrownBlockProjectile);
            this.setCarriedBlock(null);
        }
    }

    public BlockState blocky() {
        AABB aabb = this.m_20191_().m_82400_(0.2);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) < 5.0f) || !(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) >= 0.0f)) continue;
            this.m_9236_().m_46961_(blockpos, false);
            return blockstate;
        }
        return null;
    }

    @Override
    public void HyperEvolve(LivingEntity living) {
        Ogre ogre = new Ogre((EntityType<? extends Monster>)((EntityType)Sentities.OGRE.get()), this.m_9236_());
        Collection collection = this.m_21220_();
        for (MobEffectInstance mobeffectinstance : collection) {
            ogre.m_7292_(new MobEffectInstance(mobeffectinstance));
        }
        ogre.setKills(this.getKills());
        ogre.setEvoPoints(this.getEvoPoints() - (Integer)SConfig.SERVER.min_kills_hyper.get());
        ogre.m_6593_(this.m_7770_());
        ogre.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ogre.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20097_()), MobSpawnType.CONVERSION, null, null);
        }
        this.m_9236_().m_7967_((Entity)ogre);
        this.m_146870_();
        EvolvingInfected.super.HyperEvolve(living);
    }
}

