/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

public interface EvolvingInfected {
    default public void tickEvolution(Infected infected, List<? extends String> value, ScamperVariants variants) {
        if (infected.f_19797_ % 20 == 0 && infected.getEvoPoints() >= (Integer)SConfig.SERVER.min_kills.get()) {
            if (infected.getEvolutionCoolDown() >= (Integer)SConfig.SERVER.evolution_age_human.get()) {
                this.Evolve(infected, value, variants);
            } else if (!infected.m_21023_(MobEffects.f_19613_)) {
                infected.setEvolution(infected.getEvolutionCoolDown() + 1);
            }
        }
    }

    default public void tickHyperEvolution(EvolvedInfected infected) {
        if (infected.f_19797_ % 20 == 0 && infected.getEvoPoints() >= (Integer)SConfig.SERVER.min_kills_hyper.get()) {
            if (infected.getEvolutionCoolDown() >= (Integer)SConfig.SERVER.evolution_age_human.get()) {
                this.HyperEvolve((LivingEntity)infected);
            } else if (!infected.m_21023_(MobEffects.f_19613_)) {
                infected.setEvolution(infected.getEvolutionCoolDown() + 1);
            }
        }
    }

    default public void HyperEvolve(LivingEntity living) {
        Level level = living.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x0 = living.m_20185_() - ((double)living.m_217043_().m_188501_() - 0.1) * 0.1;
            double y0 = living.m_20186_() + ((double)living.m_217043_().m_188501_() - 0.25) * 0.15 * 5.0;
            double z0 = living.m_20189_() + ((double)living.m_217043_().m_188501_() - 0.1) * 0.1;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            this.ringPlayers(living);
        }
    }

    default public void ringPlayers(LivingEntity living) {
        List entities = living.m_9236_().m_6249_((Entity)living, living.m_20191_().m_82400_(64.0), entity -> entity instanceof Player);
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof Player)) continue;
            Player player = (Player)entity2;
            player.m_6330_((SoundEvent)Ssounds.HYPER_EVOLVE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    default public void Evolve(Infected livingEntity, List<? extends String> value, ScamperVariants variants) {
        Level level;
        if (livingEntity != null && value != null && (level = livingEntity.m_9236_()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            Level level2 = livingEntity.m_9236_();
            RandomSource random = RandomSource.m_216327_();
            if (Math.random() < 0.9) {
                Random rand = new Random();
                for (int i = 0; i < 1; ++i) {
                    int randomIndex = rand.nextInt(value.size());
                    ResourceLocation randomElement1 = new ResourceLocation(value.get(randomIndex));
                    EntityType randomElement = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(randomElement1);
                    Entity waveentity = randomElement.m_20615_(level2);
                    waveentity.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_() + 0.5, livingEntity.m_20189_());
                    waveentity.m_6593_(livingEntity.m_7770_());
                    if (waveentity instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)waveentity;
                        Collection collection = livingEntity.m_21220_();
                        for (MobEffectInstance mobeffectinstance : collection) {
                            entity.m_7292_(new MobEffectInstance(mobeffectinstance));
                        }
                    }
                    if (waveentity instanceof Infected) {
                        Infected infected = (Infected)waveentity;
                        infected.setKills(livingEntity.getKills());
                        infected.setEvoPoints(livingEntity.getEvoPoints());
                        infected.setSearchPos(livingEntity.getSearchPos());
                        infected.setLinked(livingEntity.getLinked());
                        infected.m_6518_((ServerLevelAccessor)world, livingEntity.m_9236_().m_6436_(new BlockPos((int)livingEntity.m_20185_(), (int)livingEntity.m_20186_(), (int)livingEntity.m_20189_())), MobSpawnType.CONVERSION, null, null);
                    }
                    level2.m_7967_(waveentity);
                    livingEntity.m_146870_();
                }
            } else {
                Scamper scamper = new Scamper((EntityType<? extends Monster>)((EntityType)Sentities.SCAMPER.get()), level2);
                scamper.setVariant(variants);
                scamper.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_() + 0.5, livingEntity.m_20189_());
                scamper.m_6593_(livingEntity.m_7770_());
                scamper.setKills(livingEntity.getKills());
                scamper.setEvoPoints(livingEntity.getEvoPoints());
                scamper.setLinked(livingEntity.getLinked());
                scamper.setSearchPos(livingEntity.getSearchPos());
                Collection collection = livingEntity.m_21220_();
                for (MobEffectInstance mobeffectinstance : collection) {
                    scamper.m_7292_(new MobEffectInstance(mobeffectinstance));
                }
                level2.m_7967_((Entity)scamper);
                livingEntity.m_146870_();
            }
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                double x0 = livingEntity.m_20185_() - ((double)random.m_188501_() - 0.1) * 0.1;
                double y0 = livingEntity.m_20186_() + ((double)random.m_188501_() - 0.25) * 0.15 * 5.0;
                double z0 = livingEntity.m_20189_() + ((double)random.m_188501_() - 0.1) * 0.1;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }
}

