/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Experiments;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Experiment;
import com.Harbinger.Spore.Sentities.Projectile.AcidBall;
import com.Harbinger.Spore.Sentities.Projectile.BileProjectile;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Biobloob
extends Experiment
implements RangedAttackMob {
    public static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(Biobloob.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final float maxScale = 2.0f;
    private final float minScale = 0.5f;
    private static double health = (Double)SConfig.SERVER.biobloob_hp.get() * (Double)SConfig.SERVER.global_health.get();
    private static double damage = (Double)SConfig.SERVER.biobloob_damage.get() * (Double)SConfig.SERVER.global_damage.get();
    private static double armor = (Double)SConfig.SERVER.biobloob_armor.get() * (Double)SConfig.SERVER.global_armor.get();

    public Biobloob(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("scale", ((Float)this.f_19804_.m_135370_(SCALE)).floatValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(tag.m_128457_("scale")));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
    }

    public float m_6134_() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public void setScale(float value) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(value));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (result) {
            this.shrink(amount);
        }
        return result;
    }

    @Override
    public void m_5993_(Entity entity, int i, DamageSource damageSource) {
        super.m_5993_(entity, i, damageSource);
        this.grow();
    }

    private void grow() {
        if (this.m_6134_() < 2.0f) {
            this.setScale(this.m_6134_() + 0.1f);
            this.applyScaleEffects();
        }
    }

    private void shrink(float damageTaken) {
        this.setScale(this.m_6134_() - damageTaken * 0.01f);
        if (this.m_6134_() < 0.5f) {
            this.setScale(0.5f);
        }
        this.applyScaleEffects();
    }

    private void applyScaleEffects() {
        Vec3 position = this.m_20182_();
        this.m_146884_(position);
        this.computeAttribute(Attributes.f_22276_, health * (double)this.m_6134_());
        this.computeAttribute(Attributes.f_22281_, damage * (double)this.m_6134_());
        this.computeAttribute(Attributes.f_22284_, armor * (double)this.m_6134_());
        this.computeAttribute(Attributes.f_22279_, 0.3 * (double)(1.0f / this.m_6134_()));
        if (this.m_21223_() > this.m_21233_()) {
            this.m_21153_(this.m_21233_());
        }
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.m_6134_() == 1.0f ? 1.0f : this.m_6134_() * 0.8f);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (SCALE.equals(accessor)) {
            this.m_6210_();
        }
    }

    private void computeAttribute(Attribute attributes, double value) {
        AttributeInstance instance = this.m_21051_(attributes);
        if (instance != null) {
            instance.m_22100_(value);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, health).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22280_, 0.3).m_22268_(Attributes.f_22281_, damage).m_22268_(Attributes.f_22284_, armor).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.bioblob_loot.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.BIOBLOB.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(3, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity livingEntity) {
                return livingEntity.m_20205_() + 13.0f * Biobloob.this.m_6134_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        if (!this.m_9236_().f_46443_) {
            if (Math.random() <= 0.5) {
                BileProjectile bileProjectile = new BileProjectile(this.m_9236_(), (LivingEntity)this, this.TARGET_SELECTOR);
                double dx = livingEntity.m_20185_() - this.m_20185_();
                double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_() - 1.0;
                double dz = livingEntity.m_20189_() - this.m_20189_();
                bileProjectile.setDamage((float)((Double)SConfig.SERVER.biobloob__ranged_damage.get() * (Double)SConfig.SERVER.global_damage.get()));
                bileProjectile.m_6027_(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
                bileProjectile.m_6686_(dx, dy - bileProjectile.m_20186_() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
                this.m_9236_().m_7967_((Entity)bileProjectile);
            } else {
                AcidBall.shoot((LivingEntity)this, livingEntity, (float)((Double)SConfig.SERVER.biobloob__ranged_damage.get() * (Double)SConfig.SERVER.global_damage.get()));
                this.m_5496_(SoundEvents.f_12387_, 1.0f, 0.5f);
            }
        }
    }

    @Override
    public void m_8119_() {
        LivingEntity living;
        super.m_8119_();
        if (this.f_19797_ % 60 == 0 && (living = this.m_5448_()) != null) {
            this.m_6504_(living, 0.0f);
        }
    }
}

