/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.ChunkLoaderHelper;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sblocks.CDUBlock;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.NeuralProcessing.ProtoAIs.ProtoTargeting;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.CasingGenerator;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.FoliageSpread;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.Sentities.Organoids.Verwa;
import com.Harbinger.Spore.Sentities.Organoids.Vigil;
import com.Harbinger.Spore.Sentities.Organoids.Womb;
import com.Harbinger.Spore.Sentities.Signal;
import com.Harbinger.Spore.Sentities.Utility.GastGeber;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class Proto
extends Organoid
implements CasingGenerator,
FoliageSpread {
    private static final EntityDataAccessor<Integer> HOSTS = SynchedEntityData.m_135353_(Proto.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BIOMASS = SynchedEntityData.m_135353_(Proto.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<BlockPos> NODE = SynchedEntityData.m_135353_(Proto.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private final List<String> hypers = new ArrayList<String>(){
        {
            this.add("spore:inquisitor");
            this.add("spore:wendigo");
            this.add("spore:hvindicator");
            this.add("spore:brot");
            this.add("spore:ogre");
            this.add("spore:hevoker");
        }
    };
    private int summonDefense = 0;
    private static final int INPUT_SIZE = 4;
    private static final int OUTPUT_SIZE = 4;
    private double[] weights;
    public List<String> team_1 = new ArrayList<String>();
    public List<String> team_2 = new ArrayList<String>();
    public List<String> team_3 = new ArrayList<String>();
    public List<String> team_4 = new ArrayList<String>();
    public List<String> team_5 = new ArrayList<String>();
    private final Random random = new Random();
    @Nullable
    public Signal signal;

    public Proto(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_21530_();
        this.initializeValues();
    }

    private void fillDefaultTeams(List<String> team, List<? extends String> CONFIG) {
        if (CONFIG.size() < 4) {
            throw new IllegalArgumentException("CONFIG must have at least 4 unique entries");
        }
        ArrayList<? extends String> shuffledConfig = new ArrayList<String>(CONFIG);
        Collections.shuffle(shuffledConfig, this.random);
        for (int i = 0; i < 4; ++i) {
            String config = (String)shuffledConfig.get(i);
            int add = this.isVariantKeeper(config);
            team.add(config + "_" + add);
        }
    }

    protected void initializeValues() {
        this.weights = new double[16];
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = this.m_217043_().m_188500_();
        }
        this.fillDefaultTeams(this.team_1, (List)SConfig.SERVER.proto_summonable_troops.get());
        this.fillDefaultTeams(this.team_2, (List)SConfig.SERVER.proto_summonable_troops.get());
        this.fillDefaultTeams(this.team_3, (List)SConfig.SERVER.proto_summonable_troops.get());
        this.fillDefaultTeams(this.team_4, (List)SConfig.SERVER.proto_summonable_troops.get());
    }

    private int isVariantKeeper(String s) {
        int n;
        ResourceLocation location = new ResourceLocation(s);
        Entity entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location)).m_20615_(this.m_9236_());
        if (entity instanceof VariantKeeper) {
            VariantKeeper keeper = (VariantKeeper)entity;
            n = this.m_217043_().m_188503_(keeper.amountOfMutations() - 1);
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.proto_loot.get();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public double getWeightsValue(int i) {
        return this.weights[i];
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.proto_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.proto_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.proto_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22278_, 2.0);
    }

    protected void m_8099_() {
        this.addTargettingGoals();
        this.f_21345_.m_25352_(3, (Goal)new ProtoTargeting(this));
        this.f_21345_.m_25352_(4, (Goal)new AOEMeleeAttackGoal(this, 0.0, false, 2.5, 8.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    public boolean isNunny() {
        return Objects.equals(this.m_7770_(), Component.m_237113_((String)"Nunny"));
    }

    private void generateCasing() {
        if (this.m_20275_(((BlockPos)this.f_19804_.m_135370_(NODE)).m_123341_(), ((BlockPos)this.f_19804_.m_135370_(NODE)).m_123342_(), ((BlockPos)this.f_19804_.m_135370_(NODE)).m_123343_()) > 100.0) {
            if (Math.random() < 0.1) {
                this.f_19804_.m_135381_(NODE, (Object)this.m_20097_());
            }
        } else if (this.getBiomass() > 40) {
            this.generateChasing((BlockPos)this.f_19804_.m_135370_(NODE), (Entity)this, 32, 2);
            this.generateChasing((BlockPos)this.f_19804_.m_135370_(NODE), (Entity)this, 16);
            this.eatBiomass(5);
        }
    }

    private void scanForHosts() {
        List entities = this.m_9236_().m_6249_((Entity)this, this.seachbox(), EntitySelector.f_20406_);
        this.f_19804_.m_135381_(HOSTS, (Object)0);
        for (Entity en : entities) {
            if (en instanceof Infected) {
                Infected infected = (Infected)en;
                if (!infected.getLinked()) {
                    infected.setLinked(true);
                }
                if (infected.m_5448_() == null || infected.m_20186_() < 0.0 || infected.m_21223_() < infected.m_21233_() / 2.0f) {
                    if (!this.m_9236_().f_46443_ && this.harvestBiomassByDespawning(infected)) {
                        this.setHosts(this.getHosts() + 1);
                    }
                } else {
                    this.setHosts(this.getHosts() + 1);
                }
            }
            if (en instanceof Mound) {
                Mound mound = (Mound)en;
                if (!mound.getLinked()) {
                    mound.setLinked(true);
                }
                this.setHosts(this.getHosts() + 1);
            }
            if (!((Boolean)SConfig.SERVER.proto_raid.get()).booleanValue() || !(Math.random() < (Double)SConfig.SERVER.proto_raid_chance.get() / 100.0) || !(en instanceof Player) && !((List)SConfig.SERVER.proto_sapient_target.get()).contains(en.m_20078_())) continue;
            int x = this.random.nextInt(-30, 30);
            int z = this.random.nextInt(-30, 30);
            Vigil vigil = new Vigil((EntityType<? extends UtilityEntity>)((EntityType)Sentities.VIGIL.get()), this.m_9236_());
            vigil.m_20984_(en.m_20185_() + (double)x, en.m_20186_(), en.m_20189_() + (double)z, false);
            vigil.setProto((Mob)this);
            vigil.setVariant(2);
            vigil.tickEmerging();
            this.m_9236_().m_7967_((Entity)vigil);
            break;
        }
    }

    public boolean harvestBiomassByDespawning(Infected living) {
        if (living instanceof GastGeber || living instanceof Scamper) {
            return true;
        }
        if (living.getKills() > 0) {
            this.addBiomass(living.getKills());
            living.setKills(0);
            return true;
        }
        if (living instanceof Hyper && Math.random() < 1.0E-4) {
            this.addBiomass(30);
            living.m_146870_();
            return false;
        }
        if (living instanceof EvolvedInfected && Math.random() < 0.01) {
            this.addBiomass(15);
            living.m_146870_();
            return false;
        }
        if (Math.random() < 0.2) {
            this.addBiomass(5);
            living.m_146870_();
            return false;
        }
        return true;
    }

    private void griefBlocks() {
        if (this.m_21225_() == this.m_269291_().m_269318_() && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            AABB aabb = this.m_20191_().m_82377_(0.2, 0.0, 0.2);
            boolean flag = false;
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                if (!(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) < 10.0f) || !(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) > 0.0f)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    private boolean checkForScent() {
        AABB hitbox = this.m_20191_().m_82400_(3.0);
        List entities = this.m_9236_().m_45976_(ScentEntity.class, hitbox);
        return entities.isEmpty();
    }

    private void SummonScent() {
        ScentEntity scent = new ScentEntity((EntityType<? extends PathfinderMob>)((EntityType)Sentities.SCENT.get()), this.m_9236_());
        scent.setOvercharged(true);
        scent.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_9236_().m_7967_((Entity)scent);
    }

    public void addBiomass(int e) {
        this.f_19804_.m_135381_(BIOMASS, (Object)((Integer)this.f_19804_.m_135370_(BIOMASS) + e));
    }

    public void eatBiomass(int e) {
        this.f_19804_.m_135381_(BIOMASS, (Object)((Integer)this.f_19804_.m_135370_(BIOMASS) - e));
    }

    public int getBiomass() {
        return (Integer)this.f_19804_.m_135370_(BIOMASS);
    }

    public AABB seachbox() {
        return this.m_20191_().m_82400_((double)((Integer)SConfig.SERVER.proto_range.get()).intValue());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            LivingEntity target;
            if (this.f_19797_ % 6000 == 0 && ((Boolean)SConfig.SERVER.mound_foliage.get()).booleanValue() && this.f_19804_.m_135370_(NODE) != BlockPos.f_121853_) {
                this.SpreadInfection(this.m_9236_(), (Double)SConfig.SERVER.mound_range_age4.get() * 2.0, (BlockPos)this.f_19804_.m_135370_(NODE));
            }
            if (this.f_19797_ % 200 == 0 && ((Boolean)SConfig.SERVER.proto_casing.get()).booleanValue()) {
                this.generateCasing();
            }
            if (this.f_19797_ % 1200 == 0) {
                this.scanForHosts();
                this.moraleBoost();
            }
            if (this.f_19797_ % 40 == 0) {
                this.griefBlocks();
                target = this.m_5448_();
                if (target != null && this.checkForScent()) {
                    this.SummonScent();
                }
            }
            if (this.f_19797_ % 200 == 0) {
                this.addBiomass(1);
            }
            if (this.getSignal() != null && this.getSignal().active().booleanValue() && this.checkForCalamities(this.getSignal().pos())) {
                this.SummonConstructor(this.m_9236_(), (Entity)this, this.getSignal().pos());
            }
            if (this.f_19797_ % 3000 == 0 && ((Boolean)SConfig.SERVER.proto_madness.get()).booleanValue()) {
                this.giveMadness(this);
            }
            if (this.summonDefense > 0) {
                --this.summonDefense;
            }
            target = this.m_5448_();
            if (this.f_19797_ % 200 == 0 && target != null) {
                BlockPos pos = target.m_20097_();
                if (this.checkForOrganoids((Entity)target) && this.getBiomass() > 2 && !this.m_9236_().f_46443_) {
                    int e = this.m_217043_().m_216339_(1, 5);
                    for (int o = 0; o < e; ++o) {
                        this.summonMob(this.decide(this.inputs(target)), pos);
                    }
                }
            }
        }
    }

    public double[] inputs(LivingEntity entity) {
        if (entity == null) {
            return new double[]{1.0, 1.0, 1.0, 1.0};
        }
        double distance = entity.m_20280_((Entity)this) < 200.0 ? 1.0 : 0.0;
        double isOnGround = entity.m_20096_() ? 1.0 : 0.0;
        double hasAllotOfHealth = entity.m_21233_() >= 20.0f ? 1.0 : 0.0;
        double hasAllotOfArmor = entity.m_21230_() >= 20 ? 1.0 : 0.0;
        return new double[]{distance, isOnGround, hasAllotOfHealth, hasAllotOfArmor};
    }

    public Entity entityResourceLocation(int decision, List<String> string) {
        if (string.isEmpty()) {
            return null;
        }
        String[] id = string.get(decision).split("_");
        ResourceLocation location = new ResourceLocation(id[0]);
        int variant = Integer.parseInt(id[1]);
        Entity entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location)).m_20615_(this.m_9236_());
        if (entity instanceof VariantKeeper) {
            VariantKeeper keeper = (VariantKeeper)entity;
            if (variant > 0) {
                keeper.setVariant(variant);
            }
        }
        return entity;
    }

    public List<String> getDecisionList(int decision) {
        return switch (decision) {
            case 0 -> this.team_1;
            case 1 -> this.team_2;
            case 2 -> this.team_3;
            case 3 -> this.team_4;
            default -> null;
        };
    }

    protected boolean checkForOrganoids(Entity entity) {
        AABB aabb = entity.m_20191_().m_82400_(12.0);
        List entities = this.m_9236_().m_6249_((Entity)this, aabb, entity1 -> entity1 instanceof Organoid);
        return entities.size() <= 4;
    }

    private boolean checkTheGround(BlockPos pos, Level level) {
        for (int i = 0; i < 3; ++i) {
            BlockState state = level.m_8055_(pos.m_6625_(i));
            if (!(state.m_60800_((BlockGetter)level, pos.m_6625_(i)) > 4.0f) && !state.m_60795_()) continue;
            return false;
        }
        return true;
    }

    private void summonMob(int decision, BlockPos pos) {
        Organoid organoid;
        if (pos.equals((Object)BlockPos.f_121853_)) {
            return;
        }
        List<String> team = this.getDecisionList(decision);
        int i = this.m_217043_().m_188503_(team.size());
        BlockPos blockPos = pos;
        Entity summoned = this.entityResourceLocation(i, team);
        if (summoned instanceof Organoid) {
            organoid = (Organoid)summoned;
            blockPos = organoid.isCloseCombatant() ? pos : BlockPos.m_274446_((Position)Utilities.generatePositionAway(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), this.random.nextInt(8, 16)));
            organoid.tickEmerging();
        }
        if (summoned instanceof Vigil) {
            organoid = (Vigil)summoned;
            ((Vigil)organoid).setProto((Mob)this);
        }
        if (summoned instanceof Mound) {
            organoid = (Mound)summoned;
            ((Mound)organoid).setMaxAge(1);
        }
        if (summoned instanceof Verwa) {
            organoid = (Verwa)summoned;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ((Verwa)organoid).m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(pos), MobSpawnType.SPAWNER, null, null);
            }
        }
        CompoundTag data = summoned.getPersistentData();
        data.m_128405_("hivemind", this.m_19879_());
        data.m_128405_("decision", decision);
        data.m_128405_("member", decision);
        if (summoned instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)summoned;
            mob.m_20984_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), false);
        } else {
            summoned.m_6021_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        }
        if (this.checkTheGround(pos, summoned.m_9236_()) && summoned.m_20182_().m_82531_(0.0, 0.0, 0.0) > 10.0) {
            this.eatBiomass(2);
            this.m_9236_().m_7967_(summoned);
        }
    }

    public void moraleBoost() {
        int e = 0;
        for (double weight : this.weights) {
            if (!(weight < 0.0)) continue;
            ++e;
        }
        if (e > this.weights.length / 2) {
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = this.weights[i] + this.m_217043_().m_188500_();
            }
        }
    }

    protected void giveMadness(Proto proto) {
        AABB aabb = proto.m_20191_().m_82400_(128.0);
        List entities = this.m_9236_().m_45933_((Entity)this, aabb);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if (!((List)SConfig.SERVER.proto_sapient_target.get()).contains(living.m_20078_()) && !(living instanceof Player)) continue;
            living.m_7292_(new MobEffectInstance((MobEffect)Seffects.MADNESS.get(), 6000, 0, false, false));
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6060_() && !this.m_21023_(MobEffects.f_19607_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
        } else if (this.m_21225_() == this.m_269291_().m_269109_()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 400, 0));
        } else if (this.m_21223_() < this.m_21233_() / 2.0f && !this.m_21023_(MobEffects.f_19613_) && !this.m_21023_(MobEffects.f_19606_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0));
        }
    }

    protected int m_5639_(float p_149389_, float p_149390_) {
        return super.m_5639_(p_149389_, p_149390_) - 60;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("biomass", ((Integer)this.f_19804_.m_135370_(BIOMASS)).intValue());
        tag.m_128405_("hosts", ((Integer)this.f_19804_.m_135370_(HOSTS)).intValue());
        tag.m_128405_("nodeX", ((BlockPos)this.f_19804_.m_135370_(NODE)).m_123341_());
        tag.m_128405_("nodeY", ((BlockPos)this.f_19804_.m_135370_(NODE)).m_123342_());
        tag.m_128405_("nodeZ", ((BlockPos)this.f_19804_.m_135370_(NODE)).m_123343_());
        ListTag weightsList = new ListTag();
        for (double weight : this.weights) {
            weightsList.add((Object)DoubleTag.m_128500_((double)weight));
        }
        tag.m_128365_("weights", (Tag)weightsList);
        List<List<String>> teams = List.of(this.team_1, this.team_2, this.team_3, this.team_4, this.team_5);
        for (int i = 0; i < teams.size(); ++i) {
            ListTag teamTag = new ListTag();
            for (String member : teams.get(i)) {
                teamTag.add((Object)StringTag.m_129297_((String)member));
            }
            tag.m_128365_("team_" + (i + 1), (Tag)teamTag);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(BIOMASS, (Object)tag.m_128451_("biomass"));
        this.f_19804_.m_135381_(HOSTS, (Object)tag.m_128451_("hosts"));
        int x = tag.m_128451_("nodeX");
        int y = tag.m_128451_("nodeY");
        int z = tag.m_128451_("nodeZ");
        this.f_19804_.m_135381_(NODE, (Object)new BlockPos(x, y, z));
        ListTag weightsList = tag.m_128437_("weights", 6);
        this.weights = new double[weightsList.size()];
        for (int i = 0; i < weightsList.size(); ++i) {
            this.weights[i] = weightsList.m_128772_(i);
        }
        this.team_1.clear();
        this.team_2.clear();
        this.team_3.clear();
        this.team_4.clear();
        this.team_5.clear();
        List<List<String>> teams = List.of(this.team_1, this.team_2, this.team_3, this.team_4, this.team_5);
        for (int i = 0; i < teams.size(); ++i) {
            ListTag teamTag = tag.m_128437_("team_" + (i + 1), 8);
            for (int j = 0; j < teamTag.size(); ++j) {
                teams.get(i).add(teamTag.m_128778_(j));
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIOMASS, (Object)100);
        this.f_19804_.m_135372_(HOSTS, (Object)0);
        this.f_19804_.m_135372_(NODE, (Object)this.m_20097_());
    }

    public int getHosts() {
        return (Integer)this.f_19804_.m_135370_(HOSTS);
    }

    public void setHosts(int i) {
        this.f_19804_.m_135381_(HOSTS, (Object)i);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if ((double)amount > (Double)SConfig.SERVER.proto_dpsr.get() && (Double)SConfig.SERVER.proto_dpsr.get() > 0.0) {
            return super.m_6469_(source, (float)((Double)SConfig.SERVER.proto_dpsr.get() * 1.0));
        }
        if (source.m_7639_() != null && Math.random() < (double)0.2f && this.summonDefense <= 0) {
            for (int i = 0; i < this.random.nextInt(1, 4); ++i) {
                this.SummonHelpers();
            }
            this.summonDefense = 160;
        }
        if (source.m_276093_(DamageTypes.f_268444_) && Math.random() < (double)0.2f) {
            this.SpreadInfection(this.m_9236_(), (Double)SConfig.SERVER.mound_range_age4.get() * 2.0, (BlockPos)this.f_19804_.m_135370_(NODE));
        }
        return super.m_6469_(source, amount);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.PROTO_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x0 = this.m_20185_() - ((double)this.random.nextFloat() - 0.1) * 1.2;
            double y0 = this.m_20186_() + ((double)this.random.nextFloat() - 0.25) * 1.25 * 5.0;
            double z0 = this.m_20189_() + ((double)this.random.nextFloat() - 0.1) * 1.2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x0, y0, z0, 4, 0.0, 0.0, 0.0, 1.0);
            if (((Boolean)SConfig.SERVER.proto_chunk.get()).booleanValue()) {
                BlockPos pos = new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
                ChunkLoaderHelper.unloadChunksInRadius(serverLevel, pos, serverLevel.m_46865_((BlockPos)pos).m_7697_().f_45578_, serverLevel.m_46865_((BlockPos)pos).m_7697_().f_45579_, 5);
            }
        }
        AABB aabb = this.m_20191_().m_82400_(2.5);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockState = this.m_9236_().m_8055_(blockpos);
            BlockState above = this.m_9236_().m_8055_(blockpos.m_7494_());
            if (this.m_9236_().m_5776_() || !blockState.m_60804_((BlockGetter)this.m_9236_(), blockpos) || above.m_60804_((BlockGetter)this.m_9236_(), blockpos) || !(Math.random() < 0.9)) continue;
            if (Math.random() < 0.7) {
                this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)Sblocks.MYCELIUM_VEINS.get()).m_49966_(), 2);
            }
            if (Math.random() < 0.3) {
                this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)Sblocks.BIOMASS_BLOCK.get()).m_49966_(), 2);
            }
            if (Math.random() < 0.1) {
                this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)Sblocks.ROOTED_BIOMASS.get()).m_49966_(), 2);
            }
            if (!(Math.random() < 0.15)) continue;
            this.m_9236_().m_7731_(blockpos, ((Block)Sblocks.BRAIN_REMNANTS.get()).m_49966_(), 2);
        }
        this.m_146870_();
        AABB searchbox = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), (double)300.0, (double)200.0, (double)300.0);
        List entities = this.m_9236_().m_6249_((Entity)this, searchbox, EntitySelector.f_20406_);
        this.f_19804_.m_135381_(HOSTS, (Object)0);
        for (Entity en : entities) {
            Infected infected;
            if (en instanceof Infected && (infected = (Infected)en).getLinked()) {
                infected.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 400, 1));
            }
            if (!(en instanceof Calamity)) continue;
            Calamity calamity = (Calamity)en;
            calamity.setSearchArea(this.m_20097_());
        }
    }

    public void setSignal(@Nullable Signal signal) {
        this.signal = signal;
    }

    @Nullable
    public Signal getSignal() {
        return this.signal;
    }

    public void SummonConstructor(Level level, Entity entity, BlockPos pos) {
        ServerLevel serverLevel;
        RandomSource randomSource = RandomSource.m_216327_();
        int a = randomSource.m_216339_(-12, 12);
        int b = randomSource.m_216339_(-12, 12);
        int c = randomSource.m_216339_(-4, 4);
        BlockPos blockPos = new BlockPos((int)entity.m_20185_() + a, (int)entity.m_20186_() + c, (int)entity.m_20189_() + b);
        BlockPos blockPosTop = blockPos.m_7494_();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46859_(blockPos) && (serverLevel.m_46859_(blockPosTop) || serverLevel.m_8055_(blockPosTop).m_278721_()) && pos != null) {
            Womb.TERRAIN terrain = Womb.TERRAIN.GROUND_LEVEL;
            if (pos.m_123342_() > 120) {
                terrain = Womb.TERRAIN.AIR_LEVEL;
            } else if (pos.m_123342_() < 63) {
                terrain = Womb.TERRAIN.UNDERGROUND;
            } else if (this.checkForLiquids(pos)) {
                terrain = Womb.TERRAIN.WATER_LEVEL;
            }
            Womb creature = new Womb((EntityType<? extends PathfinderMob>)((EntityType)Sentities.RECONSTRUCTOR.get()), level, terrain, pos);
            creature.tickEmerging();
            creature.m_246847_(entity.m_20185_() + (double)a, entity.m_20186_() + (double)c, entity.m_20189_() + (double)b);
            level.m_7967_((Entity)creature);
            level.m_7654_();
            for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
                player.m_6330_((SoundEvent)Ssounds.CALAMITY_SPAWN.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                player.m_5661_((Component)Component.m_237115_((String)"calamity_summon_message"), false);
            }
            this.setSignal(null);
        }
    }

    public void SummonHelpers() {
        int a = this.random.nextInt(-12, 12);
        int b = this.random.nextInt(-12, 12);
        int c = this.random.nextInt(4);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int i = this.hypers.size();
            Verwa verwa = new Verwa((EntityType<? extends PathfinderMob>)((EntityType)Sentities.VERVA.get()), (Level)serverLevel);
            verwa.setStoredMob(this.hypers.get(this.random.nextInt(i)));
            verwa.m_246847_(this.m_20185_() + (double)a, this.m_20186_() + (double)c, this.m_20189_() + (double)b);
            verwa.tickEmerging();
            this.m_9236_().m_7967_((Entity)verwa);
        }
    }

    private boolean checkForLiquids(BlockPos blockPos) {
        AABB aabb = AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)14.0, (double)14.0, (double)14.0);
        ArrayList<BlockPos> liquids = new ArrayList<BlockPos>();
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            if (this.m_9236_().m_8055_(blockpos).m_60819_() == Fluids.f_76191_.m_76145_()) continue;
            liquids.add(blockpos);
        }
        return liquids.size() > 6 && blockPos.m_123342_() < 70;
    }

    public boolean checkForCalamities(BlockPos pos) {
        List entities = this.m_9236_().m_6249_((Entity)this, this.seachbox(), EntitySelector.f_20406_);
        for (Entity en : entities) {
            Calamity calamity;
            if (!(en instanceof Calamity) || (calamity = (Calamity)en).getSearchArea() != BlockPos.f_121853_ || !(Math.random() < 0.5)) continue;
            calamity.setSearchArea(pos);
            this.setSignal(null);
            for (ServerPlayer player : this.m_9236_().m_7654_().m_6846_().m_11314_()) {
                player.m_6330_((SoundEvent)Ssounds.CALAMITY_INCOMING.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                player.m_5661_((Component)Component.m_237115_((String)"calamity_coming_message"), false);
            }
            return false;
        }
        return true;
    }

    @Override
    public int getEmerge_tick() {
        return 120;
    }

    @Override
    public int getNumberOfParticles() {
        return 6;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        if (serverLevelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
            if (((Boolean)SConfig.SERVER.teleport_hive.get()).booleanValue()) {
                Proto.teleportToSurface(serverLevel, (Mob)this);
            }
        }
        this.loadChunks();
        this.f_19804_.m_135381_(NODE, (Object)this.m_20097_());
        return super.m_6518_(serverLevelAccessor, p_33283_, p_33284_, p_33285_, p_33286_);
    }

    public void loadChunks() {
        Level level;
        if (((Boolean)SConfig.SERVER.proto_chunk.get()).booleanValue() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
            ChunkLoaderHelper.forceLoadChunk(serverLevel, pos, this.m_9236_().m_46865_((BlockPos)pos).m_7697_().f_45578_, this.m_9236_().m_46865_((BlockPos)pos).m_7697_().f_45579_, true);
        }
    }

    public boolean m_142582_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.m_21023_((MobEffect)Seffects.MARKER.get())) {
                return true;
            }
            if ((livingEntity instanceof Player || ((List)SConfig.SERVER.proto_sapient_target.get()).contains(livingEntity.m_20078_())) && !livingEntity.m_21023_((MobEffect)Seffects.SYMBIOSIS.get())) {
                return true;
            }
            if (livingEntity.m_21233_() > 30.0f) {
                return true;
            }
            return super.m_142582_(entity);
        }
        return super.m_142582_(entity);
    }

    public int decide(double[] inputs) {
        if (this.weights == null || this.weights.length == 0) {
            this.initializeValues();
        }
        if (inputs == null || inputs.length == 0) {
            return 0;
        }
        double[] outputs = new double[4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n = i;
                outputs[n] = outputs[n] + inputs[j] * this.weights[i * 4 + j];
            }
        }
        return this.argmax(outputs);
    }

    private int argmax(double[] arr) {
        if (arr == null || arr.length == 0) {
            return 0;
        }
        int maxIndex = 0;
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] > arr[maxIndex])) continue;
            maxIndex = i;
        }
        return maxIndex;
    }

    public void punishForDecision(int decision, int member) {
        this.adjustWeightsForDecision(decision, -0.1);
        if (Math.random() < 0.05) {
            this.punishMember(this.getDecisionList(decision), member);
        }
    }

    public void praisedForDecision(int decision, int member) {
        this.adjustWeightsForDecision(decision, 0.05);
        if (Math.random() < 0.2) {
            this.awardMember(this.getDecisionList(decision), member);
        }
    }

    public void adjustWeightsForDecision(int decision, double penalty) {
        int startIndex = decision * 4;
        int endIndex = startIndex + 4;
        for (int i = startIndex; i < endIndex; ++i) {
            int n = i;
            this.weights[n] = this.weights[n] + penalty;
            this.weights[i] = Math.max(-1.0, Math.min(1.0, this.weights[i]));
        }
    }

    private void punishMember(List<String> team, int member) {
        if (team == null || team.isEmpty() || member < 0 || member >= team.size()) {
            return;
        }
        String removed = team.remove(member);
        String newMember = this.getUniqueReplacement(team, (List)SConfig.SERVER.proto_summonable_troops.get());
        if (newMember != null) {
            team.add(newMember);
        } else {
            team.add(removed);
        }
    }

    private void awardMember(List<String> team, int member) {
        if (team == null || team.isEmpty() || member < 0 || member >= team.size()) {
            return;
        }
        String s = team.get(member);
        if (!this.team_5.contains(s)) {
            this.team_5.add(team.get(member));
        }
    }

    private String getUniqueReplacement(List<String> team, List<? extends String> CONFIG) {
        List<String> possibleReplacements;
        if (this.team_5.isEmpty()) {
            possibleReplacements = new ArrayList<String>(CONFIG);
        } else {
            possibleReplacements = this.team_5;
            possibleReplacements.removeAll(team);
            if (!possibleReplacements.isEmpty()) {
                String s = possibleReplacements.get(this.random.nextInt(possibleReplacements.size()));
                this.team_5.remove(s);
                return s;
            }
        }
        ArrayList<String> mobsInTeam = new ArrayList<String>();
        for (String s : team) {
            String[] string = s.split("_");
            mobsInTeam.add(string[0]);
        }
        possibleReplacements.removeAll(mobsInTeam);
        if (possibleReplacements.isEmpty()) {
            return null;
        }
        String member = possibleReplacements.get(this.random.nextInt(possibleReplacements.size()));
        int add = this.isVariantKeeper(member);
        return member + "_" + add;
    }

    public static void teleportToSurface(ServerLevel level, Mob entity) {
        BlockPos startPos = entity.m_20183_();
        if (level.m_45527_(startPos)) {
            return;
        }
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startPos.m_123341_(), startPos.m_123343_());
        BlockPos surfacePos = new BlockPos(startPos.m_123341_(), surfaceY, startPos.m_123343_());
        if (level.m_45527_(surfacePos)) {
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(surfacePos.m_123341_(), surfacePos.m_123342_(), surfacePos.m_123343_());
            for (int i = 0; i < 8; ++i) {
                BlockState below = level.m_8055_(checkPos.m_7495_());
                BlockState current = level.m_8055_((BlockPos)checkPos);
                if (below.m_280296_() && current.m_60795_()) {
                    entity.m_6021_((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_(), (double)checkPos.m_123343_() + 0.5);
                    return;
                }
                checkPos.m_122173_(Direction.DOWN);
            }
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_());
        while (pos.m_123342_() < level.m_151558_()) {
            pos.m_122173_(Direction.UP);
            if (!level.m_45527_((BlockPos)pos)) continue;
            entity.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            return;
        }
    }

    @Override
    public void SpreadFoliageAndConvert(Level level, BlockState blockstate, BlockPos blockpos) {
        FoliageSpread.super.SpreadFoliageAndConvert(level, blockstate, blockpos);
        if (blockstate.m_60734_().equals(Sblocks.CDU.get())) {
            CDUBlock.replaceCDU(blockpos, level);
        }
    }
}

