/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.ClientUtils;
import com.Harbinger.Spore.Sitems.BaseWeapons.DeathRewardingWeapon;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeSwordBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class InfectedCleaver
extends SporeSwordBase
implements DeathRewardingWeapon {
    private final List<EnAndItem> heads = this.getHeads();

    public InfectedCleaver() {
        super(((Integer)SConfig.SERVER.cleaver_damage.get()).intValue(), 2.5, 3.0, (Integer)SConfig.SERVER.cleaver_durability.get());
    }

    public int m_8105_(ItemStack stack) {
        return 120;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    private List<EnAndItem> getHeads() {
        ArrayList<EnAndItem> values = new ArrayList<EnAndItem>();
        for (String string : (List)SConfig.SERVER.cleaver_drops.get()) {
            String[] str = string.split("\\|");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(str[1]));
            if (item == null) continue;
            values.add(new EnAndItem(str[0], item));
        }
        return values;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public void computeAfterEffect(LivingEntity victim, LivingEntity source, ItemStack weapon) {
        if (victim.m_9236_().f_46443_) {
            return;
        }
        for (EnAndItem item : this.heads) {
            if (!item.id.equals(victim.m_20078_()) || !(Math.random() < 0.1)) continue;
            this.dropLoot(victim.m_9236_(), victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), new ItemStack((ItemLike)item.item));
            break;
        }
    }

    public void dropLoot(Level level, double x, double y, double z, ItemStack stack) {
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        level.m_7967_((Entity)entity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6330_((SoundEvent)Ssounds.CLEAVER_SPIN.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        player.m_6672_(hand);
        this.hurtTool(player.m_21120_(hand), (LivingEntity)player, 1);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int charge = this.m_8105_(stack) - count;
        if (level.f_46443_) {
            ClientUtils.spinPlayer(player);
        } else if (charge % 5 == 0) {
            double radius = 2.5;
            for (int i = 0; i < 10; ++i) {
                double angle = Math.PI * 2 * (double)i / 10.0;
                double x = player.m_20185_() + radius * Math.cos(angle);
                double z = player.m_20189_() + radius * Math.sin(angle);
                ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.SPORE_SLASH.get()), x, player.m_20186_() + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            AABB area = player.m_20191_().m_82377_(3.5, 1.0, 3.5);
            List targets = player.m_9236_().m_6443_(LivingEntity.class, area, e -> e != player && e.m_6084_());
            for (LivingEntity target : targets) {
                this.m_7579_(stack, target, (LivingEntity)player);
                target.m_6469_(player.m_269291_().m_269075_(player), (float)((Integer)SConfig.SERVER.cleaver_damage.get()).intValue() / 2.0f);
                target.f_20916_ = 10;
                target.f_19802_ = 10;
            }
        }
        if (count <= 2) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 200, 0));
            player.m_36335_().m_41524_((Item)this, 200);
            player.m_5810_();
        }
        if (charge % 20 == 0) {
            player.m_6330_((SoundEvent)Ssounds.CLEAVER_SPIN.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        super.m_5929_(level, entity, stack, count);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int p_41415_) {
        super.m_5551_(stack, level, living, p_41415_);
        if (living instanceof Player) {
            Player player = (Player)living;
            player.m_36335_().m_41524_((Item)this, 60);
        }
    }

    private record EnAndItem(String id, Item item) {
    }
}

