/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataDefinedCatchableMob;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncCapturedMobsPacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class CapturedMobHandler
extends SimpleJsonResourceReloadListener {
    private static final Set<String> COMMAND_MOBS = new HashSet<String>();
    private static final Map<EntityType<?>, DataDefinedCatchableMob> CUSTOM_MOB_PROPERTIES = new IdentityHashMap();
    private static DataDefinedCatchableMob moddedFishProperty;
    protected static final Gson GSON;
    public static final CapturedMobHandler RELOAD_INSTANCE;

    private CapturedMobHandler() {
        super(GSON, "catchable_mobs_properties");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        CUSTOM_MOB_PROPERTIES.clear();
        ArrayList list = new ArrayList();
        jsons.forEach((key, json) -> {
            DataResult v = DataDefinedCatchableMob.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
            DataDefinedCatchableMob data = (DataDefinedCatchableMob)v.getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse captured mob properties: {}", e));
            if (key.m_135815_().equals("generic_fish")) {
                moddedFishProperty = data;
            } else {
                list.add(data);
            }
        });
        for (DataDefinedCatchableMob c : list) {
            for (ResourceLocation o : c.getOwners()) {
                BuiltInRegistries.f_256780_.m_6612_(o).ifPresent(e -> CUSTOM_MOB_PROPERTIES.put((EntityType<?>)e, c));
            }
        }
        if (moddedFishProperty == null) {
            Supplementaries.LOGGER.error("Failed to find json for 'generic_fish'. How? Found jsons were : {}", jsons.keySet());
        }
    }

    public static void sendDataToClient(ServerPlayer player) {
        HashSet<DataDefinedCatchableMob> set = new HashSet<DataDefinedCatchableMob>(CUSTOM_MOB_PROPERTIES.values());
        ModNetwork.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncCapturedMobsPacket(set, moddedFishProperty));
    }

    public static void acceptClientData(Set<DataDefinedCatchableMob> list, @Nullable DataDefinedCatchableMob defaultFish) {
        if (defaultFish != null) {
            moddedFishProperty = defaultFish;
        }
        CUSTOM_MOB_PROPERTIES.clear();
        for (DataDefinedCatchableMob c : list) {
            for (ResourceLocation o : c.getOwners()) {
                BuiltInRegistries.f_256780_.m_6612_(o).ifPresent(e -> CUSTOM_MOB_PROPERTIES.put((EntityType<?>)e, c));
            }
        }
    }

    public static ICatchableMob getDataCap(EntityType<?> type, boolean isFish) {
        DataDefinedCatchableMob c = CUSTOM_MOB_PROPERTIES.get(type);
        if (c == null && isFish) {
            return moddedFishProperty;
        }
        return c;
    }

    public static ICatchableMob getCatchableMobCapOrDefault(Entity entity) {
        if (entity instanceof ICatchableMob) {
            ICatchableMob cap = (ICatchableMob)entity;
            return cap;
        }
        ICatchableMob forgeCap = SuppPlatformStuff.getForgeCap(entity, ICatchableMob.class);
        if (forgeCap != null) {
            return forgeCap;
        }
        ICatchableMob prop = CapturedMobHandler.getDataCap(entity.m_6095_(), BucketHelper.isModdedFish(entity));
        if (prop != null) {
            return prop;
        }
        return ICatchableMob.DEFAULT;
    }

    public static boolean isCommandMob(String entity) {
        return COMMAND_MOBS.contains(entity);
    }

    public static void addCommandMob(String name) {
        COMMAND_MOBS.add(name);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        RELOAD_INSTANCE = new CapturedMobHandler();
    }
}

