/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.forge;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.entity.VillagerAIHooks;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.VillageBoundRandomStroll;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;

public class VillagerScareStuff {
    private static final Supplier<Activity> NOTEBLOCK_SCARE = RegHelper.registerActivity((ResourceLocation)Supplementaries.res("scared_by_noteblock"), () -> new Activity("scared_by_noteblock"));
    private static final Supplier<MemoryModuleType<BlockPos>> NEAREST_NOTEBLOCK = RegHelper.registerMemoryModule((ResourceLocation)Supplementaries.res("scary_noteblock"), () -> new MemoryModuleType(Optional.empty()));
    private static final int DESIRED_DISTANCE = 4;

    public static void init() {
        VillagerAIHooks.addBrainModification(VillagerScareStuff::modifyBrain);
    }

    public static void setup() {
        VillagerAIHooks.registerMemory(NEAREST_NOTEBLOCK.get());
    }

    private static void modifyBrain(IVillagerBrainEvent event) {
        event.addOrReplaceActivity(NOTEBLOCK_SCARE.get(), VillagerScareStuff.getNoteblockPanicPackage(0.5f));
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super Villager>>> getNoteblockPanicPackage(float speedModifier) {
        float f = speedModifier * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, VillagerScareStuff.createCamlDownBehavior()), (Object)Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.m_257620_(NEAREST_NOTEBLOCK.get(), (float)f, (int)4, (boolean)false)), (Object)Pair.of((Object)3, (Object)VillageBoundRandomStroll.m_258010_((float)f, (int)2, (int)2)), VillagerScareStuff.getMinimalLookBehavior());
    }

    public static BehaviorControl<LivingEntity> createCamlDownBehavior() {
        return BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257492_(NEAREST_NOTEBLOCK.get())).apply((Applicative)instance, nearestNoteblock -> (level, livingEntity, time) -> {
            boolean isFarAway = instance.m_257828_(nearestNoteblock).filter(pos -> pos.m_203193_((Position)livingEntity.m_20182_()) <= 16.0).isPresent();
            if (!isFarAway) {
                nearestNoteblock.m_257971_();
                livingEntity.m_6274_().m_21862_(level.m_46468_(), level.m_46467_());
            }
            return true;
        }));
    }

    private static Pair<Integer, BehaviorControl<LivingEntity>> getMinimalLookBehavior() {
        return Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20492_, (float)8.0f), (Object)2), (Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)8.0f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)8))));
    }

    public static void scareVillagers(LevelAccessor level, BlockPos pos) {
        if (CommonConfigs.Tweaks.SCARE_VILLAGERS.get().booleanValue()) {
            List villagers = level.m_45976_(Villager.class, new AABB(pos).m_82400_(8.0));
            for (Villager v : villagers) {
                Brain brain = v.m_6274_();
                if (!brain.m_21954_(Activity.f_37984_) && !brain.m_21954_(NOTEBLOCK_SCARE.get())) {
                    brain.m_21936_(MemoryModuleType.f_26377_);
                    brain.m_21936_(MemoryModuleType.f_26370_);
                    brain.m_21936_(MemoryModuleType.f_26371_);
                    brain.m_21936_(MemoryModuleType.f_26375_);
                    brain.m_21936_(MemoryModuleType.f_26374_);
                    brain.m_21879_(NEAREST_NOTEBLOCK.get(), (Object)pos);
                }
                brain.m_21889_(NOTEBLOCK_SCARE.get());
            }
        }
    }
}

