/*
 * Decompiled with CFR 0.152.
 */
package com.armatyrich.taczxgunlightsaddon;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BulletLightPerLevel {
    private final Map<UUID, BlockPos> lastPosByBullet = new HashMap<UUID, BlockPos>();
    private final Map<BlockPos, Integer> refCounts = new HashMap<BlockPos, Integer>();
    private final ServerLevel level;
    public int lightLevel = 12;
    public int tickInterval = 1;

    public BulletLightPerLevel(ServerLevel level) {
        this.level = level;
    }

    public void untrackBullet(UUID id) {
        BlockPos prev = this.lastPosByBullet.remove(id);
        if (prev != null) {
            this.decAndMaybeClear(prev);
        }
    }

    public void updateBullet(UUID id, BlockPos newPos) {
        BlockPos prev = this.lastPosByBullet.get(id);
        if (Objects.equals(prev, newPos)) {
            return;
        }
        if (this.tryPlaceLight(newPos, this.lightLevel)) {
            this.inc(newPos);
            this.lastPosByBullet.put(id, newPos);
            if (prev != null) {
                this.decAndMaybeClear(prev);
            }
        }
    }

    public void cleanupAll() {
        for (BlockPos pos : this.refCounts.keySet()) {
            this.clearLight(pos);
        }
        this.refCounts.clear();
        this.lastPosByBullet.clear();
    }

    private boolean tryPlaceLight(BlockPos pos, int lvl) {
        boolean canPlace;
        if (!this.level.m_46805_(pos)) {
            return false;
        }
        BlockState stateAt = this.level.m_8055_(pos);
        boolean bl = canPlace = stateAt.m_60795_() || stateAt.m_60713_(Blocks.f_152480_);
        if (!canPlace) {
            return false;
        }
        BlockState light = (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)LightBlock.f_153657_, (Comparable)Integer.valueOf(Math.max(0, Math.min(15, lvl))));
        return this.level.m_7731_(pos, light, 2);
    }

    private void clearLight(BlockPos pos) {
        if (!this.level.m_46805_(pos)) {
            return;
        }
        if (this.level.m_8055_(pos).m_60713_(Blocks.f_152480_)) {
            this.level.m_7471_(pos, false);
        }
    }

    private void inc(BlockPos pos) {
        this.refCounts.merge(pos, 1, Integer::sum);
    }

    private void decAndMaybeClear(BlockPos pos) {
        this.refCounts.computeIfPresent(pos, (p, c) -> {
            int n = c - 1;
            if (n <= 0) {
                this.clearLight((BlockPos)p);
                return null;
            }
            return n;
        });
    }
}

