/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.potentiometer;

import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.utilities.diode.ElectricDiodeBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PotentiometerBlockEntity
extends ElectricDiodeBlockEntity {
    protected ScrollValueBehaviour outputPercentage;

    public PotentiometerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 100;
        this.outputPercentage = new ScrollValueBehaviour((Component)CreateLang.translateDirect((String)"resistor.allowed_voltage", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new PotentiometerValueBox());
        this.outputPercentage.between(0, max);
        this.outputPercentage.value = 100;
        this.outputPercentage.withCallback(i -> this.updateNextTick());
        this.outputPercentage.withCallback(i -> this.updateInFrontNextTick());
        behaviours.add((BlockEntityBehaviour)this.outputPercentage);
    }

    @Override
    public Direction getDirection() {
        if (!this.m_58900_().m_61138_((Property)DirectionalBlock.f_52588_)) {
            return ((Direction)this.m_58900_().m_61143_((Property)TFMGHorizontalDirectionalBlock.f_54117_)).m_122428_();
        }
        return (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
    }

    @Override
    public int getOutputVoltage() {
        return (int)((float)this.getData().getVoltage() / 100.0f * (float)this.outputPercentage.getValue());
    }

    static class PotentiometerValueBox
    extends ValueBoxTransform.Sided {
        PotentiometerValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
            return super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.of((PoseStack)ms).rotateZDegrees(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
            if (facing.m_122434_().m_122478_()) {
                return direction.m_122434_().m_122479_();
            }
            return direction == Direction.UP;
        }
    }
}

