/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.api;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.api.ISpellData;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public abstract class AbstractSpellData
implements ISpellData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Map<String, Integer> spellCooldowns = new HashMap<String, Integer>();
    public LivingEntity target;
    public ItemStack spellBook = ItemStack.f_41583_;
    public boolean isCasting = false;

    @Override
    public LivingEntity getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @Override
    public ItemStack getSpellBook() {
        return this.spellBook;
    }

    @Override
    public void setSpellBook(ItemStack spellBook) {
        this.spellBook = spellBook;
    }

    @Override
    public boolean isCasting() {
        return this.isCasting;
    }

    @Override
    public void setCasting(boolean casting) {
        this.isCasting = casting;
    }

    @Override
    public boolean isSpellOnCooldown(String spellId) {
        if (spellId == null) {
            return true;
        }
        int remainingCooldown = this.spellCooldowns.getOrDefault(spellId, 0);
        return remainingCooldown > 0;
    }

    @Override
    public void setSpellCooldown(String spellId, int cooldownTicks, EntityMaid maid) {
        CoolDown coolDown = new CoolDown(cooldownTicks, maid);
        if (spellId != null) {
            Global.common_coolDownProcessors.forEach((Consumer<Function<CoolDown, Void>>)((Consumer<Function>)func -> func.apply(coolDown)));
            BaubleStateManager.getBaubles(maid).forEach(bauble -> {
                Function func = Global.bauble_coolDownProcessors.computeIfAbsent(bauble.m_41778_(), k -> cooldown -> null);
                func.apply(coolDown);
            });
            this.spellCooldowns.put(spellId, coolDown.cooldownticks);
        }
    }

    @Override
    public int getSpellCooldown(String spellId) {
        return this.spellCooldowns.getOrDefault(spellId, 0);
    }

    @Override
    public void updateCooldowns() {
        this.spellCooldowns.replaceAll((spellId, cooldown) -> Math.max(0, cooldown - 20));
        this.spellCooldowns.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
    }

    public static class CoolDown {
        public int cooldownticks;
        public EntityMaid maid;

        public CoolDown(int cooldownTicks, EntityMaid maid) {
            this.cooldownticks = cooldownTicks;
            this.maid = maid;
        }
    }
}

