/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.data;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.AbstractSpellData;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class MaidIronsSpellData
extends AbstractSpellData {
    private static final Map<UUID, MaidIronsSpellData> MAID_DATA_MAP = new ConcurrentHashMap<UUID, MaidIronsSpellData>();
    private ItemStack magicSword = ItemStack.f_41583_;
    private ItemStack staff = ItemStack.f_41583_;
    private LivingEntity origin_target = null;
    private SpellData currentCastingSpell = null;
    private final MagicData magicData = new MagicData(true);

    private MaidIronsSpellData() {
    }

    public static MaidIronsSpellData getOrCreate(UUID maidUuid) {
        return MAID_DATA_MAP.computeIfAbsent(maidUuid, k -> new MaidIronsSpellData());
    }

    public static MaidIronsSpellData getOrCreate(EntityMaid maidEntity) {
        UUID maidUuid = maidEntity.m_20148_();
        return MAID_DATA_MAP.computeIfAbsent(maidUuid, k -> new MaidIronsSpellData());
    }

    public static MaidIronsSpellData get(UUID maidUuid) {
        return MAID_DATA_MAP.get(maidUuid);
    }

    public static void remove(UUID maidUuid) {
        MAID_DATA_MAP.remove(maidUuid);
    }

    public void switchTargetToOwner(EntityMaid maid) {
        this.origin_target = this.target;
        this.target = maid.m_269323_();
    }

    public void switchTargetToOrigin(EntityMaid maid) {
        this.target = this.origin_target;
    }

    public LivingEntity getOriginTarget() {
        return this.origin_target;
    }

    public ItemStack getMagicSword() {
        return this.magicSword;
    }

    public void setMagicSword(ItemStack magicSword) {
        this.magicSword = magicSword != null ? magicSword : ItemStack.f_41583_;
    }

    public ItemStack getStaff() {
        return this.staff;
    }

    public void setStaff(ItemStack staff) {
        this.staff = staff != null ? staff : ItemStack.f_41583_;
    }

    public SpellData getCurrentCastingSpell() {
        return this.currentCastingSpell;
    }

    public void setCurrentCastingSpell(SpellData spell) {
        this.currentCastingSpell = spell;
    }

    public MagicData getMagicData() {
        return this.magicData;
    }

    @Override
    public void resetCastingState() {
        this.isCasting = false;
        this.currentCastingSpell = null;
        this.magicData.resetCastingState();
    }

    public ArrayList<ItemStack> getAllSpellContainers() {
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        if (this.spellBook != null) {
            containers.add(this.spellBook);
        }
        if (this.staff != null) {
            containers.add(this.staff);
        }
        if (this.magicSword != null) {
            containers.add(this.magicSword);
        }
        return containers;
    }

    public boolean hasAnySpellContainer() {
        return !this.spellBook.m_41619_() || !this.magicSword.m_41619_() || !this.staff.m_41619_();
    }
}

