/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.yimeng261.maidspell.spell.SimplifiedSpellCaster;
import com.github.yimeng261.maidspell.spell.data.MaidIronsSpellData;
import com.github.yimeng261.maidspell.spell.manager.AllianceManager;
import com.github.yimeng261.maidspell.task.SpellCombatFarTask;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.ModList;
import org.slf4j.Logger;

public class SpellCombatMeleeTask
implements IRangedAttackTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation UID = new ResourceLocation("maidspell", "spell_combat_melee");
    private static final MutableComponent NAME = Component.m_237115_((String)"task.maidspell.spell_combat");
    private static float SPELL_RANGE;

    public static void setSpellRange(Float range) {
        SPELL_RANGE = range.floatValue();
    }

    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return false;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public MutableComponent getName() {
        return NAME;
    }

    public ItemStack getIcon() {
        return Items.f_42690_.m_7968_();
    }

    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound((EntityMaid)maid, (SoundEvent)((SoundEvent)InitSounds.MAID_RANGE_ATTACK.get()), (float)0.5f);
    }

    public boolean isEnable(EntityMaid maid) {
        return true;
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasSpellBook, IAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> this.farAway((LivingEntity)target, maid));
        BehaviorControl moveToTargetTask = MaidRangedWalkToTarget.create((float)0.6f);
        UnifiedSpellCombatBehavior spellCastingTask = new UnifiedSpellCombatBehavior();
        SpellStrafingTask strafingTask = new SpellStrafingTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, (Object)((Object)spellCastingTask)), Pair.of((Object)5, (Object)((Object)strafingTask))});
    }

    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
    }

    public boolean canSee(EntityMaid maid, LivingEntity target) {
        return (double)maid.m_20270_((Entity)target) <= (double)SPELL_RANGE * 1.2 && Math.abs(maid.m_20186_() - target.m_20186_()) < 3.5;
    }

    public AABB searchDimension(EntityMaid maid) {
        float searchRange = SPELL_RANGE;
        return maid.m_21536_() ? new AABB(maid.m_21534_()).m_82400_((double)searchRange) : maid.m_20191_().m_82400_((double)searchRange);
    }

    public float searchRadius(EntityMaid maid) {
        return SPELL_RANGE;
    }

    public boolean hasExtraAttack(EntityMaid maid, Entity target) {
        return this.hasSpellBook(maid) && target instanceof LivingEntity && maid.m_20270_(target) <= SPELL_RANGE;
    }

    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"spell_book", this::hasSpellBook)});
    }

    public boolean isWeapon(EntityMaid maid, ItemStack stack) {
        return true;
    }

    boolean hasSpellBook(EntityMaid maid) {
        return true;
    }

    boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > this.searchRadius(maid);
    }

    class UnifiedSpellCombatBehavior
    extends Behavior<EntityMaid> {
        private SimplifiedSpellCaster currentSpellCaster;

        public UnifiedSpellCombatBehavior() {
            super(Map.of(MemoryModuleType.f_26372_, MemoryStatus.VALUE_PRESENT, MemoryModuleType.f_26371_, MemoryStatus.REGISTERED));
        }

        protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
            LivingEntity target = maid.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
            if (target == null || !target.m_6084_()) {
                return false;
            }
            double distance = maid.m_20270_((Entity)target);
            return distance <= (double)SPELL_RANGE && maid.m_142582_((Entity)target) && SpellCombatMeleeTask.this.hasSpellBook(maid);
        }

        protected boolean canStillUse(ServerLevel level, EntityMaid maid, long gameTime) {
            return this.checkExtraStartConditions(level, maid);
        }

        protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
            AllianceManager.setMaidAlliance(maid, true);
            SimplifiedSpellCaster.clearLookTarget(maid);
            this.currentSpellCaster = new SimplifiedSpellCaster(maid);
            LivingEntity target = maid.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
            if (target == maid.m_269323_() && ModList.get().isLoaded("irons_spellbooks")) {
                target = MaidIronsSpellData.getOrCreate(maid).getOriginTarget();
            }
            if (!(target instanceof Player)) {
                this.currentSpellCaster.setTarget(target);
            }
        }

        protected void tick(ServerLevel level, EntityMaid maid, long gameTime) {
            LivingEntity currentTarget;
            SimplifiedSpellCaster.clearLookTarget(maid);
            if (this.currentSpellCaster != null && !((currentTarget = (LivingEntity)maid.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null)) instanceof Player)) {
                this.currentSpellCaster.setTarget(currentTarget);
                this.currentSpellCaster.melee_tick();
            }
        }

        protected void stop(ServerLevel level, EntityMaid maid, long gameTime) {
            AllianceManager.setMaidAlliance(maid, false);
            if (this.currentSpellCaster != null) {
                this.currentSpellCaster = null;
            }
        }
    }

    static class SpellStrafingTask
    extends Behavior<EntityMaid> {
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        private double optimalMinDistance = SimplifiedSpellCaster.MELEE_RANGE - 1.0;
        private double maxAttackDistance = SPELL_RANGE;
        private double rangeRange = 2.0;

        public SpellStrafingTask() {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
        }

        protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
            SpellCombatFarTask task = new SpellCombatFarTask();
            return task.hasSpellBook(owner) && owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).filter(Entity::m_6084_).isPresent();
        }

        protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
            SpellCombatMeleeTask task = new SpellCombatMeleeTask();
            if (!task.hasSpellBook(owner)) {
                return;
            }
            owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
                double distance = owner.m_20270_((Entity)target);
                double optimalMaxDistance = this.optimalMinDistance + this.rangeRange;
                this.strafingTime = distance < this.maxAttackDistance && owner.canSee(target) ? ++this.strafingTime : -1;
                if (this.strafingTime >= 20) {
                    if ((double)owner.m_217043_().m_188501_() < 0.3) {
                        boolean bl = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)owner.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (distance > optimalMaxDistance) {
                        this.strafingBackwards = false;
                    } else if (distance < this.optimalMinDistance) {
                        this.strafingBackwards = true;
                    }
                    float forwardSpeed = this.strafingBackwards ? -0.7f : 0.5f;
                    float strafeSpeed = this.strafingClockwise ? 0.7f : -0.7f;
                    owner.m_21566_().m_24988_(forwardSpeed, strafeSpeed);
                    owner.m_146922_(Mth.m_14094_((float)owner.m_146908_(), (float)owner.f_20885_, (float)0.0f));
                }
                BehaviorUtils.m_22595_((LivingEntity)owner, (LivingEntity)target);
            });
        }

        protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
            entityIn.setSwingingArms(true);
        }

        protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
            entityIn.setSwingingArms(false);
            entityIn.m_21566_().m_24988_(0.0f, 0.0f);
        }

        protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
            return this.checkExtraStartConditions(worldIn, entityIn);
        }
    }
}

