/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell;

import com.github.yimeng261.maidspell.Config;
import com.github.yimeng261.maidspell.entity.MaidSpellEntities;
import com.github.yimeng261.maidspell.event.MaidSpellEventHandler;
import com.github.yimeng261.maidspell.item.MaidSpellCreativeTab;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.item.bauble.blueNote.contianer.MaidSpellContainers;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import com.github.yimeng261.maidspell.sound.MaidSpellSounds;
import com.github.yimeng261.maidspell.task.SpellCombatMeleeTask;
import com.github.yimeng261.maidspell.worldgen.MaidSpellStructures;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="touhou_little_maid_spell")
public class MaidSpellMod {
    public static final String MOD_ID = "touhou_little_maid_spell";
    public static final String MOD_NAME = "Touhou Little Maid: Spell";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Touhou Little Maid: Spell");
    public static final SpellCombatMeleeTask SPELL_COMBAT_TASK = new SpellCombatMeleeTask();

    public MaidSpellMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(this::setup);
        forgeBus.register((Object)this);
        forgeBus.register(MaidSpellEventHandler.class);
        MaidSpellItems.register(modBus);
        MaidSpellCreativeTab.register(modBus);
        MaidSpellContainers.register(modBus);
        MaidSpellSounds.SOUNDS.register(modBus);
        MaidSpellEntities.register(modBus);
        MaidSpellStructures.STRUCTURE_TYPES.register(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            NetworkHandler.registerMessages();
            if (this.checkDependencies()) {
                LOGGER.info("Dependencies verified - initialization complete");
            }
        });
    }

    private boolean checkDependencies() {
        boolean hasTouhouMaid = this.checkModLoaded("touhou_little_maid");
        return hasTouhouMaid;
    }

    private boolean checkModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

