/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.soulBook;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.api.IExtendBauble;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class SoulBookBauble
implements IExtendBauble {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, Integer> lastHurtTimeMap = new HashMap<UUID, Integer>();
    private static final int DAMAGE_INTERVAL_THRESHOLD = 10;

    @Override
    public void onRemove(EntityMaid maid) {
        UUID maidId = maid.m_20148_();
        lastHurtTimeMap.remove(maidId);
    }

    static {
        Global.bauble_hurtProcessors_pre.put(MaidSpellItems.itemDesc(MaidSpellItems.SOUL_BOOK), (event, maid) -> {
            UUID maidId = maid.m_20148_();
            int currentTime = maid.f_19797_;
            float originalDamage = event.getAmount();
            float maxHealth = maid.m_21233_();
            int lastHurtTime = lastHurtTimeMap.computeIfAbsent(maidId, uuid -> maid.f_19797_);
            int timeDiff = currentTime - lastHurtTime;
            if (timeDiff <= 10) {
                event.setCanceled(true);
                return null;
            }
            float damageThreshold = maxHealth * 0.2f;
            if (originalDamage > damageThreshold) {
                event.setAmount(damageThreshold);
            }
            lastHurtTimeMap.put(maidId, currentTime);
            return null;
        });
    }
}

