/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common.WindSeekingBell;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;

public class StripedLock {
    private final Lock[] locks;
    private final int stripeMask;

    public StripedLock(int stripeCount) {
        if (Integer.bitCount(stripeCount) != 1) {
            throw new IllegalArgumentException("Stripe count must be a power of 2");
        }
        this.locks = new Lock[stripeCount];
        for (int i = 0; i < stripeCount; ++i) {
            this.locks[i] = new ReentrantLock();
        }
        this.stripeMask = stripeCount - 1;
    }

    public Lock getLock(ServerLevel level) {
        int hash = System.identityHashCode(level);
        int index = hash & this.stripeMask;
        return this.locks[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeWithLock(ServerLevel level, Supplier<T> action) {
        Lock lock = this.getLock(level);
        lock.lock();
        try {
            T t = action.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public int getStripeCount() {
        return this.locks.length;
    }
}

