/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack.IBackpackContainerScreen;
import com.github.yimeng261.maidspell.client.event.MaidBackpackEnderPocketIntegration;
import com.github.yimeng261.maidspell.client.gui.EnderPocketScreen;
import com.github.yimeng261.maidspell.item.bauble.enderPocket.EnderPocketService;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class EnderPocketMessage {
    private final Type type;
    private final int maidEntityId;
    private final List<EnderPocketService.EnderPocketMaidInfo> maidInfos;
    private final boolean fromMaidBackpack;

    public EnderPocketMessage(Type type) {
        this.type = type;
        this.maidEntityId = -1;
        this.maidInfos = new ArrayList<EnderPocketService.EnderPocketMaidInfo>();
        this.fromMaidBackpack = false;
    }

    public EnderPocketMessage(Type type, boolean fromMaidBackpack) {
        this.type = type;
        this.maidEntityId = -1;
        this.maidInfos = new ArrayList<EnderPocketService.EnderPocketMaidInfo>();
        this.fromMaidBackpack = fromMaidBackpack;
    }

    public EnderPocketMessage(Type type, int maidEntityId) {
        this.type = type;
        this.maidEntityId = maidEntityId;
        this.maidInfos = new ArrayList<EnderPocketService.EnderPocketMaidInfo>();
        this.fromMaidBackpack = false;
    }

    public EnderPocketMessage(Type type, List<EnderPocketService.EnderPocketMaidInfo> maidInfos) {
        this.type = type;
        this.maidEntityId = -1;
        this.maidInfos = new ArrayList<EnderPocketService.EnderPocketMaidInfo>(maidInfos);
        this.fromMaidBackpack = false;
    }

    public EnderPocketMessage(Type type, List<EnderPocketService.EnderPocketMaidInfo> maidInfos, boolean fromMaidBackpack) {
        this.type = type;
        this.maidEntityId = -1;
        this.maidInfos = new ArrayList<EnderPocketService.EnderPocketMaidInfo>(maidInfos);
        this.fromMaidBackpack = fromMaidBackpack;
    }

    public static void encode(EnderPocketMessage message, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)message.type);
        buf.writeInt(message.maidEntityId);
        buf.writeBoolean(message.fromMaidBackpack);
        buf.writeInt(message.maidInfos.size());
        for (EnderPocketService.EnderPocketMaidInfo info : message.maidInfos) {
            buf.m_130077_(info.maidUUID);
            buf.m_130070_(info.maidName);
            buf.writeInt(info.maidEntityId);
        }
    }

    public static EnderPocketMessage decode(FriendlyByteBuf buf) {
        Type type = (Type)buf.m_130066_(Type.class);
        int maidEntityId = buf.readInt();
        boolean fromMaidBackpack = buf.readBoolean();
        int size = buf.readInt();
        ArrayList<EnderPocketService.EnderPocketMaidInfo> maidInfos = new ArrayList<EnderPocketService.EnderPocketMaidInfo>();
        for (int i = 0; i < size; ++i) {
            UUID maidUUID = buf.m_130259_();
            String maidName = buf.m_130277_();
            int entityId = buf.readInt();
            maidInfos.add(new EnderPocketService.EnderPocketMaidInfo(maidUUID, maidName, entityId));
        }
        switch (type) {
            case RESPONSE_MAID_LIST: 
            case SERVER_PUSH_UPDATE: {
                return new EnderPocketMessage(type, maidInfos, fromMaidBackpack);
            }
            case OPEN_MAID_INVENTORY: {
                return new EnderPocketMessage(type, maidEntityId);
            }
        }
        return new EnderPocketMessage(type, fromMaidBackpack);
    }

    public static void handle(EnderPocketMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isServer()) {
                EnderPocketMessage.handleServerSide(message, context.getSender());
            } else {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> EnderPocketMessage.handleClientSide(message));
            }
        });
        context.setPacketHandled(true);
    }

    private static void handleServerSide(EnderPocketMessage message, ServerPlayer player) {
        if (player == null) {
            return;
        }
        switch (message.type) {
            case REQUEST_MAID_LIST: {
                List<EnderPocketService.EnderPocketMaidInfo> maidInfos = EnderPocketService.getPlayerEnderPocketMaids(player);
                if (maidInfos.isEmpty()) break;
                EnderPocketMessage response = new EnderPocketMessage(Type.RESPONSE_MAID_LIST, maidInfos, message.fromMaidBackpack);
                NetworkHandler.CHANNEL.sendTo((Object)response, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                break;
            }
            case OPEN_MAID_INVENTORY: {
                EnderPocketService.openMaidInventory(player, message.maidEntityId);
                break;
            }
        }
    }

    private static void handleClientSide(EnderPocketMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        switch (message.type) {
            case RESPONSE_MAID_LIST: {
                MaidBackpackEnderPocketIntegration.updateEnderPocketData(message.maidInfos);
                if (message.fromMaidBackpack) {
                    if (!(mc.f_91080_ instanceof IBackpackContainerScreen)) break;
                    mc.f_91080_.m_6575_(mc, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
                    break;
                }
                mc.m_91152_((Screen)new EnderPocketScreen(message.maidInfos));
                break;
            }
            case SERVER_PUSH_UPDATE: {
                MaidBackpackEnderPocketIntegration.updateEnderPocketData(message.maidInfos);
                if (!(mc.f_91080_ instanceof IBackpackContainerScreen)) break;
                mc.f_91080_.m_6575_(mc, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
                break;
            }
        }
    }

    public static EnderPocketMessage requestMaidList() {
        return new EnderPocketMessage(Type.REQUEST_MAID_LIST);
    }

    public static EnderPocketMessage requestMaidListFromBackpack() {
        return new EnderPocketMessage(Type.REQUEST_MAID_LIST, true);
    }

    public static EnderPocketMessage openMaidInventory(int maidEntityId) {
        return new EnderPocketMessage(Type.OPEN_MAID_INVENTORY, maidEntityId);
    }

    public static EnderPocketMessage serverPushUpdate(List<EnderPocketService.EnderPocketMaidInfo> maidInfos) {
        return new EnderPocketMessage(Type.SERVER_PUSH_UPDATE, maidInfos, true);
    }

    public static enum Type {
        REQUEST_MAID_LIST,
        RESPONSE_MAID_LIST,
        OPEN_MAID_INVENTORY,
        SERVER_PUSH_UPDATE;

    }
}

