/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.papi;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class PapiReplacer {
    private static final Map<String, BiFunction<EntityMaid, String, String>> PAPI_MAP = Maps.newLinkedHashMap();

    public static String replace(String input, EntityMaid maid, String language) {
        HashMap valueMap = Maps.newHashMap();
        valueMap.put("main_setting", input);
        for (String key : PAPI_MAP.keySet()) {
            valueMap.put(key, PAPI_MAP.get(key).apply(maid, language));
        }
        Object base = new StrSubstitutor((Map)valueMap).replace("## Character Setting\n${main_setting}\n\n## Title Setting\n- You will call me \"${owner_name}\" and chat with me.\n\n## Background Setting\n- You are now in the world of Minecraft, so please use terms that exist in Minecraft as much as possible.\n\n## Current Environment Context\n- The current time is: ${game_time}\n- The current weather is: ${weather}\n- The dimension you are in: ${dimension}\n- The biome you are in: ${biome}\n- The item in your right hand: ${mainhand_item}\n- The item in your left hand: ${offhand_item}\n- Items in your backpack: ${inventory_items}\n- Your equipped armor: ${armor_items}\n- Your current health: ${healthy}\n- Potion effects on you: ${effects}\n- My current health: ${owner_healthy}\n\n## Function Call Instructions\n- If I haven't provided enough information to call a function, please continue to ask questions to ensure enough information is collected.\n- Decide which function to call based on the conversation and system information.\n- When continuing to ask questions or providing summary content, please also follow the output format requirements below.\n\n## Conversation Text Requirements\n- It is recommended to limit the reply length to within 64 characters.\n\n");
        base = language.equals(maid.getAiChatManager().getTTSLanguage()) ? (String)base + new StrSubstitutor((Map)valueMap).replace("## Output Format Requirements\n- Replies should not contain narrative words describing actions or expressions.\n- The output should be two parts of text:\n    - The first part in ${chat_language}, if the previous prompt word is not in ${chat_language}, please also translate it into ${chat_language} and output it in this part\n    - The second part is a copy of the first part\n    - The two parts are split by ---\n\n## Output Example:\npart1 in ${chat_language} language\n---\npart2 in ${chat_language} language\n") : (String)base + new StrSubstitutor((Map)valueMap).replace("## Output Format Requirements\n- Replies should not contain narrative words describing actions or expressions.\n- The output should be two parts of text:\n    - The first part in ${chat_language}, if the previous prompt word is not in ${chat_language}, please also translate it into ${chat_language} and output it in this part\n    - The second part is the translation of the first part into ${tts_language}\n    - The two parts are split by ---\n\n## Output Example:\npart1 in ${chat_language} language\n---\npart2 in ${tts_language} language\n");
        return base;
    }

    public static void registerContext(String key, BiFunction<EntityMaid, String, String> function) {
        PAPI_MAP.put(key, function);
    }

    private static String language(String languageTag) {
        String[] parts = ((String)languageTag).split("_");
        if (parts.length == 2) {
            languageTag = parts[0] + "-" + parts[1].toUpperCase(Locale.ENGLISH);
        }
        Locale locale = Locale.forLanguageTag((String)languageTag);
        return "%s (%s)".formatted(locale.getDisplayLanguage(), locale.getDisplayCountry());
    }

    private static String getBiome(EntityMaid maid, String chatLanguage) {
        Biome biome = (Biome)maid.f_19853_.m_204166_(maid.m_20183_()).m_203334_();
        ResourceLocation key = maid.f_19853_.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
        return key == null ? "Unknown Biome" : key.toString();
    }

    private static String getEffects(EntityMaid maid, String chatLanguage) {
        ArrayList names = new ArrayList();
        maid.m_21220_().forEach(i -> names.add(i.toString()));
        if (names.isEmpty()) {
            return "None";
        }
        return StringUtils.join(names, (String)", ");
    }

    private static String getArmorItems(EntityMaid maid, String chatLanguage) {
        ArrayList names = new ArrayList();
        maid.m_6168_().forEach(stack -> {
            if (!stack.m_41619_()) {
                String itemName = stack.m_41611_().getString();
                int count = stack.m_41613_();
                names.add("%sx%s".formatted(itemName, count));
            }
        });
        if (names.isEmpty()) {
            return "Empty";
        }
        return StringUtils.join(names, (String)", ");
    }

    private static String getHealthyInfo(EntityMaid maid, String chatLanguage) {
        float maxHealth = maid.m_21233_();
        float health = maid.m_21223_();
        return "%s (max %s)".formatted(Float.valueOf(health), Float.valueOf(maxHealth));
    }

    private static String getOwnerHealthyInfo(EntityMaid maid, String chatLanguage) {
        LivingEntity owner = maid.m_269323_();
        if (owner != null) {
            float maxHealth = owner.m_21233_();
            float health = owner.m_21223_();
            return "%s (max %s)".formatted(Float.valueOf(health), Float.valueOf(maxHealth));
        }
        return "";
    }

    private static String getOwnerName(EntityMaid maid, String chatLanguage) {
        String ownerName = maid.getAiChatManager().ownerName;
        if (StringUtils.isBlank((CharSequence)ownerName)) {
            return "Master (Chinese is '\u4e3b\u4eba')";
        }
        return ownerName;
    }

    private static String getWeather(EntityMaid maid, String chatLanguage) {
        Level level = maid.f_19853_;
        if (level.m_46470_()) {
            return "Thundering";
        }
        if (level.m_46471_()) {
            return "Raining";
        }
        return "Sunny";
    }

    private static String getTime(EntityMaid maid, String chatLanguage) {
        long time = maid.f_19853_.m_46468_();
        long hours = (time / 1000L + 6L) % 24L;
        long minutes = time % 1000L / 16L;
        return "%02d:%02d".formatted(hours, minutes);
    }

    private static String getDimension(EntityMaid maid, String chatLanguage) {
        ResourceKey dimension = maid.f_19853_.m_46472_();
        if (dimension == Level.f_46428_) {
            return "Overworld";
        }
        if (dimension == Level.f_46429_) {
            return "Nether";
        }
        if (dimension == Level.f_46430_) {
            return "End";
        }
        return dimension.m_135782_().toString();
    }

    private static String getSlotItemName(EquipmentSlot slot, EntityMaid maid) {
        ItemStack stack = maid.m_6844_(slot);
        if (stack.m_41619_()) {
            return "Empty";
        }
        String itemName = stack.m_41611_().getString();
        int count = stack.m_41613_();
        return "%sx%s".formatted(itemName, count);
    }

    private static String getInventoryItems(EntityMaid maid, String chatLanguage) {
        ArrayList names = Lists.newArrayList();
        RangedWrapper backpack = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpack.getSlots(); ++i) {
            ItemStack stack = backpack.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            String itemName = stack.m_41611_().getString();
            int count = stack.m_41613_();
            names.add("%sx%s".formatted(itemName, count));
        }
        if (names.isEmpty()) {
            return "Empty";
        }
        return StringUtils.join((Iterable)names, (String)", ");
    }

    static {
        PapiReplacer.registerContext("game_time", PapiReplacer::getTime);
        PapiReplacer.registerContext("weather", PapiReplacer::getWeather);
        PapiReplacer.registerContext("dimension", PapiReplacer::getDimension);
        PapiReplacer.registerContext("mainhand_item", (maid, lang) -> PapiReplacer.getSlotItemName(EquipmentSlot.MAINHAND, maid));
        PapiReplacer.registerContext("offhand_item", (maid, lang) -> PapiReplacer.getSlotItemName(EquipmentSlot.OFFHAND, maid));
        PapiReplacer.registerContext("inventory_items", PapiReplacer::getInventoryItems);
        PapiReplacer.registerContext("chat_language", (maid, lang) -> PapiReplacer.language(lang));
        PapiReplacer.registerContext("tts_language", (maid, lang) -> PapiReplacer.language(maid.getAiChatManager().getTTSLanguage()));
        PapiReplacer.registerContext("healthy", PapiReplacer::getHealthyInfo);
        PapiReplacer.registerContext("owner_healthy", PapiReplacer::getOwnerHealthyInfo);
        PapiReplacer.registerContext("armor_items", PapiReplacer::getArmorItems);
        PapiReplacer.registerContext("effects", PapiReplacer::getEffects);
        PapiReplacer.registerContext("biome", PapiReplacer::getBiome);
        PapiReplacer.registerContext("owner_name", PapiReplacer::getOwnerName);
    }
}

