/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.block.BlockJoy;
import com.github.tartaricacid.touhoulittlemaid.block.properties.GomokuPart;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.GomokuToClientMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockGomoku
extends BlockJoy
implements IBoardGameBlock {
    public static final EnumProperty<GomokuPart> PART = EnumProperty.m_61587_((String)"part", GomokuPart.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape LEFT_UP = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape LEFT_UP_WITH_BOX = Shapes.m_83110_((VoxelShape)LEFT_UP, (VoxelShape)Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)7.0));
    public static final VoxelShape UP = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape RIGHT_UP = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)16.0);
    public static final VoxelShape RIGHT_UP_WITH_BOX = Shapes.m_83110_((VoxelShape)RIGHT_UP, (VoxelShape)Block.m_49796_((double)9.0, (double)0.0, (double)11.0, (double)14.0, (double)4.0, (double)16.0));
    public static final VoxelShape LEFT_CENTER = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape CENTER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape RIGHT_CENTER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)16.0);
    public static final VoxelShape LEFT_DOWN = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    public static final VoxelShape LEFT_DOWN_WITH_BOX = Shapes.m_83110_((VoxelShape)LEFT_DOWN, (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)7.0, (double)4.0, (double)5.0));
    public static final VoxelShape DOWN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    public static final VoxelShape RIGHT_DOWN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)8.0);
    public static final VoxelShape RIGHT_DOWN_WITH_BOX = Shapes.m_83110_((VoxelShape)RIGHT_DOWN, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)9.0, (double)5.0, (double)4.0, (double)14.0));

    public BlockGomoku() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_280606_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)GomokuPart.CENTER))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    protected Vec3 sitPosition() {
        return Vec3.f_82478_;
    }

    @Override
    protected String getTypeName() {
        return Type.GOMOKU.getTypeName();
    }

    @Override
    protected int sitYRot() {
        return 0;
    }

    private static void handleGomokuRemove(Level world, BlockPos pos, BlockState state) {
        if (!world.f_46443_) {
            GomokuPart part = (GomokuPart)((Object)state.m_61143_(PART));
            BlockPos centerPos = pos.m_121996_(new Vec3i(part.getPosX(), 0, part.getPosY()));
            BlockEntity te = world.m_7702_(centerPos);
            BlockGomoku.m_49840_((Level)world, (BlockPos)centerPos, (ItemStack)((Item)InitItems.GOMOKU.get()).m_7968_());
            if (te instanceof TileEntityGomoku) {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        world.m_46597_(centerPos.m_7918_(i, 0, j), Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
    }

    @Nullable
    private static int[] getChessPos(double x, double y, GomokuPart part) {
        switch (part) {
            case LEFT_UP: {
                return BlockGomoku.getData(x, y, 0.505, 0.505, 0.54, 0.54, 0, 0);
            }
            case UP: {
                return BlockGomoku.getData(x, y, 0.037, 0.505, 0.08, 0.54, 4, 0);
            }
            case RIGHT_UP: {
                return BlockGomoku.getData(x, y, -0.037, 0.505, -0.01, 0.54, 11, 0);
            }
            case LEFT_CENTER: {
                return BlockGomoku.getData(x, y, 0.505, 0.037, 0.54, 0.07, 0, 4);
            }
            case CENTER: {
                return BlockGomoku.getData(x, y, 0.037, 0.037, 0.08, 0.07, 4, 4);
            }
            case RIGHT_CENTER: {
                return BlockGomoku.getData(x, y, -0.037, 0.037, -0.01, 0.07, 11, 4);
            }
            case LEFT_DOWN: {
                return BlockGomoku.getData(x, y, 0.505, 0.0, 0.54, 0.0, 0, 11);
            }
            case DOWN: {
                return BlockGomoku.getData(x, y, 0.037, 0.0, 0.08, 0.0, 4, 11);
            }
            case RIGHT_DOWN: {
                return BlockGomoku.getData(x, y, -0.037, 0.0, -0.01, 0.0, 11, 11);
            }
        }
        return null;
    }

    private static boolean isClickChessBox(double x, double y, GomokuPart part, Direction direction) {
        if (direction.m_122434_() == Direction.Axis.Z) {
            if (part == GomokuPart.RIGHT_UP) {
                return 0.5625 <= x && x <= 0.875 && 0.6875 <= y && y <= 1.0;
            }
            if (part == GomokuPart.LEFT_DOWN) {
                return 0.125 <= x && x <= 0.4375 && 0.0 <= y && y <= 0.3125;
            }
        }
        if (direction.m_122434_() == Direction.Axis.X) {
            if (part == GomokuPart.LEFT_UP) {
                return 0.6875 <= x && x <= 1.0 && 0.125 <= y && y <= 0.4375;
            }
            if (part == GomokuPart.RIGHT_DOWN) {
                return 0.0 <= x && x <= 0.3125 && 0.5625 <= y && y <= 0.875;
            }
        }
        return false;
    }

    @Nullable
    private static int[] getData(double x, double y, double xOffset, double yOffset, double xStartOffset, double yStartOffset, int xIndexOffset, int yIndexOffset) {
        boolean checkClick;
        int xIndex = (int)((x - xOffset) / 0.1316);
        int yIndex = (int)((y - yOffset) / 0.1316);
        double xStart = xStartOffset + (double)xIndex * 0.1316;
        double xEnd = xStart + 0.07;
        double yStart = yStartOffset + (double)yIndex * 0.1316;
        double yEnd = yStart + 0.07;
        boolean checkIndex = 0 <= (xIndex += xIndexOffset) && xIndex <= 14 && 0 <= (yIndex += yIndexOffset) && yIndex <= 14;
        boolean bl = checkClick = xStart < x && x < xEnd && yStart < y && y < yEnd;
        if (checkIndex && checkClick) {
            return new int[]{xIndex, yIndex};
        }
        return null;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockGomoku.handleGomokuRemove(world, pos, state);
        super.m_5707_(world, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        BlockGomoku.handleGomokuRemove(world, pos, state);
        super.onBlockExploded(state, world, pos, explosion);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos centerPos = context.m_8083_();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = centerPos.m_7918_(i, 0, j);
                if (context.m_43725_().m_8055_(searchPos).m_60629_(context)) continue;
                return null;
            }
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = pos.m_7918_(i, 0, j);
                GomokuPart part = GomokuPart.getPartByPos(i, j);
                if (part == null || part.isCenter()) continue;
                worldIn.m_7731_(searchPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (hand == InteractionHand.MAIN_HAND && player.m_21205_().m_41619_()) {
                Entity entity;
                GomokuPart part = (GomokuPart)((Object)state.m_61143_(PART));
                BlockPos centerPos = pos.m_121996_(new Vec3i(part.getPosX(), 0, part.getPosY()));
                BlockEntity te = level.m_7702_(centerPos);
                if (!(te instanceof TileEntityGomoku)) {
                    return InteractionResult.FAIL;
                }
                TileEntityGomoku gomoku = (TileEntityGomoku)te;
                Vec3 location = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                if (BlockGomoku.isClickChessBox(location.f_82479_, location.f_82481_, part, facing)) {
                    Entity entity2;
                    level.m_5594_(null, centerPos, (SoundEvent)InitSounds.GOMOKU_RESET.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    gomoku.reset();
                    gomoku.refresh();
                    Entity sitEntity = serverLevel.m_8791_(gomoku.getSitId());
                    if (sitEntity != null && sitEntity.m_6084_() && (entity2 = sitEntity.m_146895_()) instanceof EntityMaid) {
                        EntityMaid maid = (EntityMaid)entity2;
                        maid.getGameRecordManager().resetStatue();
                    }
                    return InteractionResult.SUCCESS;
                }
                Entity sitEntity = serverLevel.m_8791_(gomoku.getSitId());
                if (sitEntity == null || !sitEntity.m_6084_() || !((entity = sitEntity.m_146895_()) instanceof EntityMaid)) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.gomoku.no_maid"));
                    return InteractionResult.FAIL;
                }
                EntityMaid maid = (EntityMaid)entity;
                if (((Boolean)MaidConfig.MAID_GOMOKU_OWNER_LIMIT.get()).booleanValue() && !maid.m_21830_((LivingEntity)player)) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.gomoku.not_owner"));
                    return InteractionResult.FAIL;
                }
                if (!gomoku.isPlayerTurn()) {
                    return InteractionResult.FAIL;
                }
                int[][] chessData = gomoku.getChessData();
                int[] clickPos = BlockGomoku.getChessPos(location.f_82479_, location.f_82481_, part);
                if (clickPos == null) {
                    return InteractionResult.FAIL;
                }
                Point playerPoint = new Point(clickPos[0], clickPos[1], 1);
                if (gomoku.isInProgress() && chessData[playerPoint.x][playerPoint.y] == 0) {
                    gomoku.setChessData(playerPoint.x, playerPoint.y, playerPoint.type);
                    Statue statue = MaidGomokuAI.getStatue(chessData, playerPoint);
                    if (statue == Statue.WIN && maid.m_21830_((LivingEntity)player)) {
                        maid.getFavorabilityManager().apply(Type.GOMOKU_WIN);
                        maid.getGameRecordManager().markStatue(false);
                        int rankBefore = MaidGomokuAI.getRank(maid);
                        maid.getGameRecordManager().increaseGomokuWinCount();
                        int rankAfter = MaidGomokuAI.getRank(maid);
                        if (rankBefore < rankAfter) {
                            NetworkHandler.sendToClientPlayer(new SpawnParticleMessage(maid.m_19879_(), SpawnParticleMessage.Type.RANK_UP), player);
                        }
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            InitTrigger.MAID_EVENT.trigger(serverPlayer, "win_gomoku");
                        }
                    }
                    gomoku.setInProgress(statue == Statue.IN_PROGRESS);
                    level.m_5594_(null, pos, (SoundEvent)InitSounds.GOMOKU.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                    if (gomoku.isInProgress()) {
                        gomoku.setPlayerTurn(false);
                        NetworkHandler.sendToClientPlayer(new GomokuToClientMessage(centerPos, chessData, playerPoint, maid.getGameRecordManager().getGomokuWinCount()), player);
                    }
                    gomoku.refresh();
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void startMaidSit(EntityMaid maid, BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof TileEntityJoy) {
                TileEntityJoy joy = (TileEntityJoy)blockEntity;
                Entity oldSitEntity = serverLevel.m_8791_(joy.getSitId());
                if (oldSitEntity != null && oldSitEntity.m_6084_()) {
                    return;
                }
                Direction face = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
                Vec3 position = new Vec3(0.5 + (double)face.m_122429_() * 1.5, 0.1, 0.5 + (double)face.m_122431_() * 1.5);
                EntitySit newSitEntity = new EntitySit(worldIn, Vec3.m_272021_((Vec3i)pos, (double)position.f_82479_, (double)position.f_82480_, (double)position.f_82481_), this.getTypeName(), pos);
                newSitEntity.m_146922_(face.m_122424_().m_122435_() + (float)this.sitYRot());
                worldIn.m_7967_((Entity)newSitEntity);
                joy.setSitId(newSitEntity.m_20148_());
                joy.m_6596_();
                maid.m_20329_(newSitEntity);
            }
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (((GomokuPart)((Object)state.m_61143_(PART))).isCenter()) {
            return new TileEntityGomoku(pos, state);
        }
        return null;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((GomokuPart)((Object)state.m_61143_(PART))) {
            case LEFT_UP: {
                if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X) {
                    return LEFT_UP_WITH_BOX;
                }
                return LEFT_UP;
            }
            case UP: {
                return UP;
            }
            case RIGHT_UP: {
                if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z) {
                    return RIGHT_UP_WITH_BOX;
                }
                return RIGHT_UP;
            }
            case LEFT_CENTER: {
                return LEFT_CENTER;
            }
            case RIGHT_CENTER: {
                return RIGHT_CENTER;
            }
            case LEFT_DOWN: {
                if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z) {
                    return LEFT_DOWN_WITH_BOX;
                }
                return LEFT_DOWN;
            }
            case DOWN: {
                return DOWN;
            }
            case RIGHT_DOWN: {
                if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X) {
                    return RIGHT_DOWN_WITH_BOX;
                }
                return RIGHT_DOWN;
            }
        }
        return CENTER;
    }
}

