/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.input;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.Player2AppCheck;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.STTCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.DefaultLLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTSite;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class STTChatKey {
    public static final KeyMapping STT_CHAT_KEY = new KeyMapping("key.touhou_little_maid.stt_chat.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 88, "key.category.touhou_little_maid");

    @SubscribeEvent
    public static void onSttChatPress(InputEvent.Key event) {
        if (STTChatKey.keyIsMatch(event)) {
            if (!((Boolean)AIConfig.LLM_ENABLED.get()).booleanValue()) {
                return;
            }
            if (!((Boolean)AIConfig.STT_ENABLED.get()).booleanValue()) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || player.m_5833_()) {
                return;
            }
            if (!STTChatKey.isInGame()) {
                return;
            }
            STT_CHAT_KEY.m_90859_();
            if (event.getAction() == 1) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)InitSounds.RECORDING_START.get()), (float)1.0f));
                STTChatKey.getNearestMaid(player, STTChatKey::sttStart, true);
                return;
            }
            if (event.getAction() == 0) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)InitSounds.RECORDING_END.get()), (float)1.0f));
                STTChatKey.getNearestMaid(player, STTChatKey::sttStop, false);
            }
        }
    }

    private static boolean keyIsMatch(InputEvent.Key event) {
        return STT_CHAT_KEY.m_90832_(event.getKey(), event.getScanCode()) && STT_CHAT_KEY.getKeyModifier().equals((Object)KeyModifier.getActiveModifier());
    }

    private static void getNearestMaid(LocalPlayer player, Consumer<EntityMaid> consumer, boolean isStart) {
        Level level = player.f_19853_;
        int range = (Integer)AIConfig.MAID_CAN_CHAT_DISTANCE.get();
        AABB aabb = player.m_20191_().m_82400_((double)range);
        List maids = level.m_6443_(EntityMaid.class, aabb, maid -> maid.m_21830_((LivingEntity)player) && maid.m_6084_());
        maids.sort(Comparator.comparingDouble(maid -> maid.m_20280_((Entity)player)));
        if (!maids.isEmpty()) {
            consumer.accept((EntityMaid)maids.get(0));
            return;
        }
        if (isStart) {
            player.m_213846_((Component)Component.m_237110_((String)"ai.touhou_little_maid.chat.stt.no_maid_found", (Object[])new Object[]{range}));
        }
    }

    private static boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }

    private static void sttStart(EntityMaid maid) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        STTSite sttSite = AvailableSites.getSTTSite(((STTApiType)((Object)AIConfig.STT_TYPE.get())).getName());
        if (!sttSite.enabled()) {
            player.m_213846_((Component)Component.m_237115_((String)"ai.touhou_little_maid.chat.stt.empty"));
            return;
        }
        if (sttSite.id().equals(DefaultLLMSite.PLAYER2.id())) {
            Player2AppCheck.checkPlayer2AppInStt((Player)player, () -> STTChatKey.tryToStart(maid, player, sttSite));
        } else {
            STTChatKey.tryToStart(maid, player, sttSite);
        }
    }

    private static void tryToStart(EntityMaid maid, LocalPlayer player, STTSite sttSite) {
        STTConfig config = new STTConfig();
        STTCallback callback = new STTCallback((Player)player, maid);
        sttSite.client().startRecord(config, callback);
    }

    private static void sttStop(EntityMaid maid) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        STTSite sttSite = AvailableSites.getSTTSite(((STTApiType)((Object)AIConfig.STT_TYPE.get())).getName());
        if (sttSite.enabled()) {
            STTConfig config = new STTConfig();
            STTCallback callback = new STTCallback((Player)player, maid);
            sttSite.client().stopRecord(config, callback);
        }
    }
}

