/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityPlaceholderModel;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class TileEntityEntityPlaceholderRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final EntityPlaceholderModel BASE_MODEL = new EntityPlaceholderModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/item/entity_placeholder.png");
    private final Function<ResourceLocation, ResourceLocation> recipeToModel = Util.m_143827_(recipeId -> {
        Path path = Paths.get(recipeId.m_135815_(), new String[0]);
        String namespace = recipeId.m_135827_();
        return new ResourceLocation(namespace, "item/%s".formatted(path.getFileName()));
    });
    private final Function<ResourceLocation, ResourceLocation> recipeToTexture = Util.m_143827_(recipeId -> {
        Path path = Paths.get(recipeId.m_135815_(), new String[0]);
        String namespace = recipeId.m_135827_();
        return new ResourceLocation(namespace, String.format("textures/item/%s.png", path.getFileName().toString()));
    });

    public TileEntityEntityPlaceholderRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlay) {
        ResourceLocation recipeId = ItemEntityPlaceholder.getRecipeId(stack);
        BakedModel bakedModel = this.getBakedModel(recipeId);
        poseStack.m_85836_();
        if (bakedModel != null) {
            RenderType renderType = Sheets.m_110791_();
            VertexConsumer buffer = bufferIn.m_6299_(renderType);
            Minecraft.m_91087_().m_91291_().m_115189_(bakedModel, stack, combinedLight, combinedOverlay, poseStack, buffer);
        } else {
            ResourceLocation texture = this.getTexture(recipeId);
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
            BASE_MODEL.m_7695_(poseStack, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    @Nullable
    private BakedModel getBakedModel(@Nullable ResourceLocation recipeId) {
        ResourceLocation modelId;
        if (recipeId == null) {
            return null;
        }
        ModelManager manager = Minecraft.m_91087_().m_91304_();
        BakedModel model = manager.getModel(modelId = this.recipeToModel.apply(recipeId));
        if (model == manager.m_119409_()) {
            return null;
        }
        return model;
    }

    private ResourceLocation getTexture(@Nullable ResourceLocation recipeId) {
        ResourceLocation texture;
        if (recipeId == null) {
            return TEXTURE;
        }
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        if (manager.m_213713_(texture = this.recipeToTexture.apply(recipeId)).isPresent()) {
            return texture;
        }
        return TEXTURE;
    }
}

