/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunCommonUtil;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;

public class GunShootTargetTask
extends Behavior<EntityMaid> {
    private int attackCooldown = -1;
    private int seeTime;

    public GunShootTargetTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        if (!GunCommonUtil.isGun(owner.m_21205_())) {
            return false;
        }
        return owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).filter(owner::canSee).isPresent();
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
        owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
            boolean seeTimeMoreThanZero;
            owner.m_21563_().m_24946_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSee = owner.canSee((LivingEntity)target);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            ItemStack mainHandItem = owner.m_21205_();
            GunCommonUtil.tick(owner, target, mainHandItem);
            if (--this.attackCooldown <= 0 && this.seeTime >= -60 && canSee) {
                try {
                    this.attackCooldown = GunCommonUtil.performGunAttack(owner, target, mainHandItem);
                }
                catch (Exception e) {
                    TouhouLittleMaid.LOGGER.error("Error while performing gun attack for EntityMaid: {}", (Object)owner.m_20148_(), (Object)e);
                    this.attackCooldown = 100;
                }
            }
        });
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    protected void stop(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.seeTime = 0;
        this.attackCooldown = -1;
        maid.setSwingingArms(false);
        maid.setAiming(false);
        GunCommonUtil.onStop(maid, this);
    }
}

