/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.immersivemelodies;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoBone;
import immersive_melodies.client.animation.accessors.ModelAccessor;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Mob;

public class GeckoMaidArmsAndHeadAccessor
implements ModelAccessor<Mob> {
    private final Mob maid;
    @Nullable
    private final AnimatedGeoBone head;
    @Nullable
    private final AnimatedGeoBone hat;
    @Nullable
    private final AnimatedGeoBone leftArm;
    @Nullable
    private final AnimatedGeoBone rightArm;

    GeckoMaidArmsAndHeadAccessor(Mob maid, @Nullable AnimatedGeoBone head, @Nullable AnimatedGeoBone hat, @Nullable AnimatedGeoBone leftArm, @Nullable AnimatedGeoBone rightArm) {
        this.maid = maid;
        this.head = head;
        this.hat = hat;
        this.leftArm = leftArm;
        this.rightArm = rightArm;
    }

    public Mob getEntity() {
        return this.maid;
    }

    public float headYaw() {
        return this.getMaidHead().map(AnimatedGeoBone::getRotationY).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void headYaw(float yaw) {
        this.getMaidHead().ifPresent(bone -> bone.setRotationY(this.flipHands() ? yaw : -yaw));
        this.getMaidHat().ifPresent(bone -> bone.setRotationY(this.flipHands() ? yaw : -yaw));
    }

    public float headPitch() {
        return this.getMaidHat().map(AnimatedGeoBone::getRotationX).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void headPitch(float pitch) {
        this.getMaidHead().ifPresent(bone -> bone.setRotationX(-pitch));
        this.getMaidHat().ifPresent(bone -> bone.setRotationX(-pitch));
    }

    public float leftArmYaw() {
        return this.getMaidFlippedLeftArm().map(AnimatedGeoBone::getRotationY).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void leftArmYaw(float yaw) {
        this.getMaidFlippedLeftArm().ifPresent(bone -> bone.setRotationY(this.flipHands() ? yaw : -yaw));
    }

    public float leftArmPitch() {
        return this.getMaidFlippedLeftArm().map(AnimatedGeoBone::getRotationX).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void leftArmPitch(float pitch) {
        this.getMaidFlippedLeftArm().ifPresent(bone -> bone.setRotationX(-pitch));
    }

    public float leftArmRoll() {
        return this.getMaidFlippedLeftArm().map(AnimatedGeoBone::getRotationZ).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void leftArmRoll(float roll) {
        this.getMaidFlippedLeftArm().ifPresent(bone -> bone.setRotationZ(this.flipHands() ? roll : -roll));
    }

    public float rightArmYaw() {
        return this.getMaidFlippedRightArm().map(AnimatedGeoBone::getRotationY).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void rightArmYaw(float yaw) {
        this.getMaidFlippedRightArm().ifPresent(bone -> bone.setRotationY(this.flipHands() ? yaw : -yaw));
    }

    public float rightArmPitch() {
        return this.getMaidFlippedRightArm().map(AnimatedGeoBone::getRotationX).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void rightArmPitch(float pitch) {
        this.getMaidFlippedRightArm().ifPresent(bone -> bone.setRotationX(-pitch));
    }

    public float rightArmRoll() {
        return this.getMaidFlippedRightArm().map(AnimatedGeoBone::getRotationZ).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void rightArmRoll(float roll) {
        this.getMaidFlippedRightArm().ifPresent(bone -> bone.setRotationY(this.flipHands() ? -roll : roll));
    }

    private Optional<AnimatedGeoBone> getMaidHead() {
        return Optional.ofNullable(this.head);
    }

    private Optional<AnimatedGeoBone> getMaidHat() {
        return Optional.ofNullable(this.hat);
    }

    private Optional<AnimatedGeoBone> getMaidFlippedLeftArm() {
        return this.flipHands() ? this.getMaidRightArm() : this.getMaidLeftArm();
    }

    private Optional<AnimatedGeoBone> getMaidFlippedRightArm() {
        return this.flipHands() ? this.getMaidLeftArm() : this.getMaidRightArm();
    }

    private Optional<AnimatedGeoBone> getMaidLeftArm() {
        return Optional.ofNullable(this.leftArm);
    }

    private Optional<AnimatedGeoBone> getMaidRightArm() {
        return Optional.ofNullable(this.rightArm);
    }
}

