/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.patchouli;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class AltarRecipeComponent
implements IComponentProcessor {
    private static final String RECIPE_ID = "recipe_id";
    private static final String INPUT = "input";
    private static final String POWER_COST = "power_cost";
    private static final String OUTPUT_ITEM = "output_item";
    private static final String OUTPUT_ENTITY = "output_entity";
    private static final String OUTPUT_DESC = "output_desc";
    @Nullable
    private AltarRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        ResourceLocation recipeId = new ResourceLocation(variables.get(RECIPE_ID).asString());
        List allAltarRecipes = level.m_7465_().m_44013_(InitRecipes.ALTAR_CRAFTING);
        for (AltarRecipe recipe : allAltarRecipes) {
            if (!recipe.m_6423_().equals((Object)recipeId)) continue;
            this.recipe = recipe;
            return;
        }
        this.recipe = new AltarRecipe(new ResourceLocation("touhou_little_maid", "empty"), EntityType.f_20461_, null, 0.0f, Ingredient.f_43901_);
        TouhouLittleMaid.LOGGER.error("Altar recipe not found: {}", (Object)recipeId);
    }

    @Nullable
    public IVariable process(Level level, String key) {
        if (key.startsWith(INPUT)) {
            int index = Integer.parseInt(key.substring(INPUT.length())) - 1;
            if (index < 0 || index >= this.recipe.m_7527_().size()) {
                return IVariable.from((Object)ItemStack.f_41583_);
            }
            Ingredient ingredient = (Ingredient)this.recipe.m_7527_().get(index);
            ItemStack[] stacks = ingredient.m_43908_();
            if (stacks.length == 0) {
                return IVariable.from((Object)ItemStack.f_41583_);
            }
            ArrayList stackNames = Lists.newArrayList();
            for (ItemStack stack : stacks) {
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                if (itemId == null) continue;
                stackNames.add(itemId.toString());
            }
            return IVariable.wrap((String)StringUtils.join((Iterable)stackNames, (String)","));
        }
        switch (key) {
            case "power_cost": {
                float powerCost = this.recipe.getPowerCost();
                return IVariable.wrap((String)String.format("x%.2f", Float.valueOf(powerCost)));
            }
            case "output_item": {
                return IVariable.from((Object)this.recipe.m_8043_(level.m_9598_()));
            }
            case "output_desc": {
                String langKey;
                String namespace = this.recipe.m_6423_().m_135827_().toLowerCase(Locale.US);
                if (this.recipe.isItemCraft()) {
                    langKey = String.format("jei.%s.altar_craft.%s.result", namespace, "item_craft");
                } else {
                    Path path = Paths.get(this.recipe.m_6423_().m_135815_().toLowerCase(Locale.US), new String[0]);
                    langKey = String.format("jei.%s.altar_craft.%s.result", namespace, path.getFileName());
                }
                return IVariable.wrap((String)I18n.m_118938_((String)langKey, (Object[])new Object[0]));
            }
            case "output_entity": {
                ResourceLocation entityId;
                EntityType entityType = this.recipe.getEntityType();
                if (entityType.equals(InitEntities.BOX.get())) {
                    entityType = (EntityType)InitEntities.MAID.get();
                }
                if ((entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType)) != null) {
                    return IVariable.wrap((String)entityId.toString());
                }
                return IVariable.wrap((String)"minecraft:item");
            }
        }
        return null;
    }
}

